/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.util;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.NatTableConfigAttributes;
import org.eclipse.nebula.widgets.nattable.layer.IDpiConverter;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class GUIHelper {
    private static final String KEY_PREFIX = GUIHelper.class.getCanonicalName() + ".";
    public static final Color COLOR_GRAY = Display.getDefault().getSystemColor(15);
    public static final Color COLOR_WHITE = Display.getDefault().getSystemColor(1);
    public static final Color COLOR_DARK_GRAY = Display.getDefault().getSystemColor(16);
    public static final Color COLOR_BLACK = Display.getDefault().getSystemColor(2);
    public static final Color COLOR_BLUE = Display.getDefault().getSystemColor(9);
    public static final Color COLOR_RED = Display.getDefault().getSystemColor(3);
    public static final Color COLOR_YELLOW = Display.getDefault().getSystemColor(7);
    public static final Color COLOR_GREEN = Display.getDefault().getSystemColor(5);
    public static final Color COLOR_LIST_BACKGROUND = Display.getDefault().getSystemColor(25);
    public static final Color COLOR_LIST_FOREGROUND = Display.getDefault().getSystemColor(24);
    public static final Color COLOR_LIST_SELECTION = Display.getDefault().getSystemColor(26);
    public static final Color COLOR_LIST_SELECTION_TEXT = Display.getDefault().getSystemColor(27);
    public static final Color COLOR_WIDGET_BACKGROUND = Display.getDefault().getSystemColor(22);
    public static final Color COLOR_WIDGET_FOREGROUND = Display.getDefault().getSystemColor(21);
    public static final Color COLOR_TITLE_INACTIVE_BACKGROUND = Display.getDefault().getSystemColor(34);
    public static final Color COLOR_WIDGET_BORDER = Display.getDefault().getSystemColor(23);
    public static final Color COLOR_WIDGET_DARK_SHADOW = Display.getDefault().getSystemColor(17);
    public static final Color COLOR_WIDGET_LIGHT_SHADOW = Display.getDefault().getSystemColor(19);
    public static final Color COLOR_WIDGET_NORMAL_SHADOW = Display.getDefault().getSystemColor(18);
    public static final Color COLOR_WIDGET_HIGHLIGHT_SHADOW = Display.getDefault().getSystemColor(20);
    public static final Font DEFAULT_FONT = Display.getDefault().getSystemFont();
    public static final int DEFAULT_RESIZE_HANDLE_SIZE = 4;
    public static final int DEFAULT_MIN_DISPLAY_SIZE = 5;
    public static final int DEFAULT_ANTIALIAS = -1;
    public static final int DEFAULT_TEXT_ANTIALIAS = -1;
    private static final String[] IMAGE_DIRS = new String[]{"org/eclipse/nebula/widgets/nattable/images/", ""};
    private static final String[] IMAGE_EXTENSIONS = new String[]{".png", ".gif"};
    private static final AtomicLong atomicLong = new AtomicLong(0L);
    private static Point dpi;

    private GUIHelper() {
    }

    public static Color getColor(RGB rgb) {
        return GUIHelper.getColor(rgb.red, rgb.green, rgb.blue);
    }

    public static Color getColor(int red, int green, int blue) {
        String key = GUIHelper.getColorKey(red, green, blue);
        if (JFaceResources.getColorRegistry().hasValueFor(key)) {
            return JFaceResources.getColorRegistry().get(key);
        }
        JFaceResources.getColorRegistry().put(key, new RGB(red, green, blue));
        return GUIHelper.getColor(key);
    }

    public static Color getColor(String key) {
        return JFaceResources.getColorRegistry().get(key);
    }

    private static String getColorKey(int red, int green, int blue) {
        return KEY_PREFIX + "_COLOR_" + red + "_" + green + "_" + blue;
    }

    public static Font getFont(FontData ... fontDatas) {
        StringBuilder keyBuilder = new StringBuilder();
        FontData[] fontDataArray = fontDatas;
        int n = fontDatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            keyBuilder.append(fontData.toString());
            ++n2;
        }
        String key = keyBuilder.toString();
        if (JFaceResources.getFontRegistry().hasValueFor(key)) {
            return JFaceResources.getFont((String)key);
        }
        JFaceResources.getFontRegistry().put(key, fontDatas);
        return JFaceResources.getFont((String)key);
    }

    public static Font getFont(String key) {
        return JFaceResources.getFont((String)key);
    }

    public static Font getScaledFont(Font font, float fontScalingFactor) {
        if (font != null && fontScalingFactor != 1.0f) {
            FontData[] fontData;
            int fontHeight = (int)((float)font.getFontData()[0].getHeight() * fontScalingFactor);
            FontData[] fontDataArray = fontData = font.getFontData();
            int n = fontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData data = fontDataArray[n2];
                data.setHeight(fontHeight);
                ++n2;
            }
            return GUIHelper.getFont(fontData);
        }
        return font;
    }

    public static Image getImageByURL(URL url) {
        String basename = url.toString();
        basename = basename.substring(basename.lastIndexOf(47) + 1, basename.lastIndexOf(46));
        return GUIHelper.getImageByURL(basename, url);
    }

    public static Image getImageByURL(String key, URL url) {
        return GUIHelper.getImageByURL(key, url, GUIHelper.needScaling(), false);
    }

    public static Image getDisplayImageByURL(URL url) {
        String basename = url.toString();
        basename = basename.substring(basename.lastIndexOf(47) + 1, basename.lastIndexOf(46));
        return GUIHelper.getDisplayImageByURL(basename, url);
    }

    public static Image getDisplayImageByURL(String key, URL url) {
        return GUIHelper.getImageByURL(key, url, GUIHelper.needScaling(true), true);
    }

    public static Image getImageByURL(String key, URL url, boolean considerScaling, boolean forDisplayDPI) {
        String internalKey = GUIHelper.getImageKey(key, considerScaling, forDisplayDPI);
        Image image = JFaceResources.getImage((String)internalKey);
        if (image == null) {
            if (considerScaling) {
                String urlString = url.toString();
                int extIndex = urlString.lastIndexOf(46);
                String ext = urlString.substring(extIndex, urlString.length());
                String base = urlString.substring(0, extIndex);
                try {
                    URL scaleURL = new URL(base + GUIHelper.getScalingImageSuffix() + ext);
                    URLConnection con = scaleURL.openConnection();
                    con.connect();
                    JFaceResources.getImageRegistry().put(internalKey, ImageDescriptor.createFromURL((URL)scaleURL));
                }
                catch (IOException e) {
                    ImageData imageData = ImageDescriptor.createFromURL((URL)url).getImageData(100);
                    imageData = imageData.scaledTo(GUIHelper.convertHorizontalPixelToDpi(imageData.width), GUIHelper.convertVerticalPixelToDpi(imageData.height));
                    JFaceResources.getImageRegistry().put(internalKey, new Image((Device)Display.getDefault(), imageData));
                }
            } else {
                JFaceResources.getImageRegistry().put(internalKey, ImageDescriptor.createFromURL((URL)url));
            }
            image = JFaceResources.getImage((String)internalKey);
        }
        return image;
    }

    public static Image getImage(String imageName) {
        return GUIHelper.getImage(imageName, GUIHelper.needScaling(), false);
    }

    public static Image getDisplayImage(String imageName) {
        return GUIHelper.getImage(imageName, GUIHelper.needScaling(true), true);
    }

    public static Image getImage(String imageName, boolean considerScaling, boolean forDisplayDPI) {
        URL imageUrl;
        String key = GUIHelper.getImageKey(imageName, considerScaling, forDisplayDPI);
        Image image = JFaceResources.getImage((String)key);
        if (image == null && (imageUrl = GUIHelper.getInternalImageUrl(imageName, considerScaling, forDisplayDPI)) != null) {
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)imageUrl);
            if (considerScaling && !imageUrl.getFile().contains(GUIHelper.getScalingImageSuffix(forDisplayDPI))) {
                ImageData imageData = imageDescriptor.getImageData(100);
                imageData = imageData.scaledTo(GUIHelper.convertHorizontalPixelToDpi(imageData.width, forDisplayDPI), GUIHelper.convertVerticalPixelToDpi(imageData.height, forDisplayDPI));
                JFaceResources.getImageRegistry().put(key, new Image((Device)Display.getDefault(), imageData));
            } else {
                JFaceResources.getImageRegistry().put(key, imageDescriptor.createImage());
            }
            image = JFaceResources.getImage((String)key);
        }
        return image;
    }

    private static String getImageKey(String key, boolean needScaling, boolean forDisplayDPI) {
        if (needScaling) {
            return key + GUIHelper.getScalingImageSuffix(forDisplayDPI);
        }
        return key;
    }

    public static ImageDescriptor getImageDescriptor(String imageName) {
        ImageDescriptor imageDescriptor = null;
        URL imageUrl = GUIHelper.getInternalImageUrl(imageName, GUIHelper.needScaling());
        if (imageUrl != null) {
            imageDescriptor = ImageDescriptor.createFromURL((URL)imageUrl);
        }
        return imageDescriptor;
    }

    public static URL getInternalImageUrl(String imageName) {
        return GUIHelper.getInternalImageUrl(imageName, false);
    }

    public static URL getInternalImageUrl(String imageName, boolean needScaling) {
        return GUIHelper.getInternalImageUrl(imageName, needScaling, false);
    }

    public static URL getInternalImageUrl(String imageName, boolean needScaling, boolean forDisplayDPI) {
        String[] stringArray = IMAGE_DIRS;
        int n = IMAGE_DIRS.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            String[] stringArray2 = IMAGE_EXTENSIONS;
            int n3 = IMAGE_EXTENSIONS.length;
            int n4 = 0;
            while (n4 < n3) {
                String ext = stringArray2[n4];
                URL url = null;
                if (needScaling) {
                    url = GUIHelper.class.getClassLoader().getResource(dir + imageName + GUIHelper.getScalingImageSuffix(forDisplayDPI) + ext);
                }
                if (url == null) {
                    url = GUIHelper.class.getClassLoader().getResource(dir + imageName + ext);
                }
                if (url != null) {
                    return url;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static String getSequenceNumber() {
        long id = atomicLong.addAndGet(1L);
        return String.valueOf(id);
    }

    public static RGB blend(RGB val1, RGB val2) {
        int red = GUIHelper.blend(val1.red, val2.red);
        int green = GUIHelper.blend(val1.green, val2.green);
        int blue = GUIHelper.blend(val1.blue, val2.blue);
        return new RGB(red, green, blue);
    }

    private static int blend(int temp1, int temp2) {
        return Math.abs(temp1 - temp2) / 2 + Math.min(temp1, temp2);
    }

    public static float getDpiFactor(int dpi) {
        return Math.max(0.1f, (float)Math.round((float)dpi / 96.0f * 100.0f) / 100.0f);
    }

    public static void setDpi(int x, int y) {
        dpi = new Point(x, y);
    }

    public static boolean needScaling() {
        return GUIHelper.getDpiX() != 96 || GUIHelper.getDpiY() != 96;
    }

    public static boolean needScaling(boolean forDisplay) {
        return GUIHelper.getDpiX(forDisplay) != 96 || GUIHelper.getDpiY(forDisplay) != 96;
    }

    public static int getDpiX() {
        return GUIHelper.getDpiX(false);
    }

    public static int getDpiX(boolean displayDPI) {
        if (!displayDPI && dpi != null) {
            return GUIHelper.dpi.x;
        }
        return Display.getDefault().getDPI().x;
    }

    public static int getDpiY() {
        return GUIHelper.getDpiY(false);
    }

    public static int getDpiY(boolean displayDPI) {
        if (!displayDPI && dpi != null) {
            return GUIHelper.dpi.y;
        }
        return Display.getDefault().getDPI().y;
    }

    public static String getScalingImageSuffix() {
        return "_" + GUIHelper.getDpiX() + "_" + GUIHelper.getDpiY();
    }

    public static String getScalingImageSuffix(boolean forDisplayDPI) {
        return "_" + GUIHelper.getDpiX(forDisplayDPI) + "_" + GUIHelper.getDpiY(forDisplayDPI);
    }

    public static int convertHorizontalPixelToDpi(int pixel) {
        return Math.round((float)pixel * GUIHelper.getDpiFactor(GUIHelper.getDpiX()));
    }

    public static int convertHorizontalPixelToDpi(int pixel, boolean forDisplayDPI) {
        return Math.round((float)pixel * GUIHelper.getDpiFactor(GUIHelper.getDpiX(forDisplayDPI)));
    }

    public static int convertHorizontalDpiToPixel(int dpi) {
        return Math.round((float)dpi / GUIHelper.getDpiFactor(GUIHelper.getDpiX()));
    }

    public static int convertHorizontalDpiToPixel(int dpi, boolean forDisplayDPI) {
        return Math.round((float)dpi / GUIHelper.getDpiFactor(GUIHelper.getDpiX(forDisplayDPI)));
    }

    public static int convertVerticalPixelToDpi(int pixel) {
        return Math.round((float)pixel * GUIHelper.getDpiFactor(GUIHelper.getDpiY()));
    }

    public static int convertVerticalPixelToDpi(int pixel, boolean forDisplayDPI) {
        return Math.round((float)pixel * GUIHelper.getDpiFactor(GUIHelper.getDpiY(forDisplayDPI)));
    }

    public static int convertVerticalDpiToPixel(int dpi) {
        return Math.round((float)dpi / GUIHelper.getDpiFactor(GUIHelper.getDpiY()));
    }

    public static int convertVerticalDpiToPixel(int dpi, boolean forDisplayDPI) {
        return Math.round((float)dpi / GUIHelper.getDpiFactor(GUIHelper.getDpiY(forDisplayDPI)));
    }

    public static int convertHorizontalPixelToDpi(int pixel, IConfigRegistry configRegistry) {
        IDpiConverter converter;
        if (configRegistry != null && (converter = configRegistry.getConfigAttribute(NatTableConfigAttributes.HORIZONTAL_DPI_CONVERTER, DisplayMode.NORMAL, new String[0])) != null) {
            return converter.convertPixelToDpi(pixel);
        }
        return GUIHelper.convertHorizontalPixelToDpi(pixel);
    }

    public static int convertHorizontalDpiToPixel(int dpi, IConfigRegistry configRegistry) {
        IDpiConverter converter;
        if (configRegistry != null && (converter = configRegistry.getConfigAttribute(NatTableConfigAttributes.HORIZONTAL_DPI_CONVERTER, DisplayMode.NORMAL, new String[0])) != null) {
            return converter.convertDpiToPixel(dpi);
        }
        return GUIHelper.convertHorizontalDpiToPixel(dpi);
    }

    public static int convertVerticalPixelToDpi(int pixel, IConfigRegistry configRegistry) {
        IDpiConverter converter;
        if (configRegistry != null && (converter = configRegistry.getConfigAttribute(NatTableConfigAttributes.VERTICAL_DPI_CONVERTER, DisplayMode.NORMAL, new String[0])) != null) {
            return converter.convertPixelToDpi(pixel);
        }
        return GUIHelper.convertVerticalPixelToDpi(pixel);
    }

    public static int convertVerticalDpiToPixel(int dpi, IConfigRegistry configRegistry) {
        IDpiConverter converter;
        if (configRegistry != null && (converter = configRegistry.getConfigAttribute(NatTableConfigAttributes.VERTICAL_DPI_CONVERTER, DisplayMode.NORMAL, new String[0])) != null) {
            return converter.convertDpiToPixel(dpi);
        }
        return GUIHelper.convertVerticalDpiToPixel(dpi);
    }
}

