/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.replaydebugging;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.fordiac.ide.debug.replaydebugging.IReplayNavigatorRegistrationListener;
import org.eclipse.fordiac.ide.debug.replaydebugging.ReplayNavigator;

public class ReplayNavigatorManager {
    private static final ReplayNavigatorManager INSTANCE = new ReplayNavigatorManager();
    private final CopyOnWriteArrayList<IReplayNavigatorRegistrationListener> listeners = new CopyOnWriteArrayList();
    private final Map<ReplayNavigator.Identifier, ReplayNavigator> registeredNavigators = new ConcurrentHashMap<ReplayNavigator.Identifier, ReplayNavigator>();

    private ReplayNavigatorManager() {
    }

    public static ReplayNavigatorManager getDefault() {
        return INSTANCE;
    }

    public void addListener(IReplayNavigatorRegistrationListener listener) {
        this.listeners.add(listener);
        for (ReplayNavigator replayNavigator : this.registeredNavigators.values()) {
            listener.replayNavigatorRegistered(replayNavigator);
        }
    }

    public void removeListener(IReplayNavigatorRegistrationListener listener) {
        this.listeners.remove(listener);
    }

    public void registerNavigator(ReplayNavigator navigator) {
        this.registeredNavigators.put(navigator.getIdentifier(), navigator);
        for (IReplayNavigatorRegistrationListener listener : this.listeners) {
            listener.replayNavigatorRegistered(navigator);
        }
    }

    public void unregisterNavigator(ReplayNavigator navigator) {
        this.registeredNavigators.remove(navigator.getIdentifier());
        for (IReplayNavigatorRegistrationListener listener : this.listeners) {
            listener.replayNavigatorUnregistered(navigator);
        }
    }
}

