/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;

public class ReadEventDetails
extends HistoryReadDetails
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=644");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=646");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=645");
    private final UInteger numValuesPerNode;
    private final DateTime startTime;
    private final DateTime endTime;
    private final EventFilter filter;

    public ReadEventDetails(UInteger numValuesPerNode, DateTime startTime, DateTime endTime, EventFilter filter) {
        this.numValuesPerNode = numValuesPerNode;
        this.startTime = startTime;
        this.endTime = endTime;
        this.filter = filter;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public UInteger getNumValuesPerNode() {
        return this.numValuesPerNode;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public EventFilter getFilter() {
        return this.filter;
    }

    protected ReadEventDetails(ReadEventDetailsBuilder<?, ?> b) {
        super((HistoryReadDetails.HistoryReadDetailsBuilder<?, ?>)b);
        this.numValuesPerNode = ((ReadEventDetailsBuilder)b).numValuesPerNode;
        this.startTime = ((ReadEventDetailsBuilder)b).startTime;
        this.endTime = ((ReadEventDetailsBuilder)b).endTime;
        this.filter = ((ReadEventDetailsBuilder)b).filter;
    }

    public static ReadEventDetailsBuilder<?, ?> builder() {
        return new ReadEventDetailsBuilderImpl();
    }

    public ReadEventDetailsBuilder<?, ?> toBuilder() {
        return new ReadEventDetailsBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadEventDetails)) {
            return false;
        }
        ReadEventDetails other = (ReadEventDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UInteger this$numValuesPerNode = this.getNumValuesPerNode();
        UInteger other$numValuesPerNode = other.getNumValuesPerNode();
        if (this$numValuesPerNode == null ? other$numValuesPerNode != null : !((Object)this$numValuesPerNode).equals(other$numValuesPerNode)) {
            return false;
        }
        DateTime this$startTime = this.getStartTime();
        DateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        DateTime this$endTime = this.getEndTime();
        DateTime other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        EventFilter this$filter = this.getFilter();
        EventFilter other$filter = other.getFilter();
        return !(this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ReadEventDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UInteger $numValuesPerNode = this.getNumValuesPerNode();
        result = result * 59 + ($numValuesPerNode == null ? 43 : ((Object)$numValuesPerNode).hashCode());
        DateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        DateTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        EventFilter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ReadEventDetails(numValuesPerNode=" + this.getNumValuesPerNode() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", filter=" + this.getFilter() + ")";
    }

    private static final class ReadEventDetailsBuilderImpl
    extends ReadEventDetailsBuilder<ReadEventDetails, ReadEventDetailsBuilderImpl> {
        private ReadEventDetailsBuilderImpl() {
        }

        @Override
        protected ReadEventDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public ReadEventDetails build() {
            return new ReadEventDetails(this);
        }
    }

    public static abstract class ReadEventDetailsBuilder<C extends ReadEventDetails, B extends ReadEventDetailsBuilder<C, B>>
    extends HistoryReadDetails.HistoryReadDetailsBuilder<C, B> {
        private UInteger numValuesPerNode;
        private DateTime startTime;
        private DateTime endTime;
        private EventFilter filter;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ReadEventDetailsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ReadEventDetails instance, ReadEventDetailsBuilder<?, ?> b) {
            b.numValuesPerNode(instance.numValuesPerNode);
            b.startTime(instance.startTime);
            b.endTime(instance.endTime);
            b.filter(instance.filter);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B numValuesPerNode(UInteger numValuesPerNode) {
            this.numValuesPerNode = numValuesPerNode;
            return (B)this.self();
        }

        public B startTime(DateTime startTime) {
            this.startTime = startTime;
            return (B)this.self();
        }

        public B endTime(DateTime endTime) {
            this.endTime = endTime;
            return (B)this.self();
        }

        public B filter(EventFilter filter) {
            this.filter = filter;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ReadEventDetails.ReadEventDetailsBuilder(super=" + super.toString() + ", numValuesPerNode=" + this.numValuesPerNode + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", filter=" + this.filter + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ReadEventDetails> {
        @Override
        public Class<ReadEventDetails> getType() {
            return ReadEventDetails.class;
        }

        @Override
        public ReadEventDetails decode(SerializationContext context, UaDecoder decoder) {
            UInteger numValuesPerNode = decoder.readUInt32("NumValuesPerNode");
            DateTime startTime = decoder.readDateTime("StartTime");
            DateTime endTime = decoder.readDateTime("EndTime");
            EventFilter filter = (EventFilter)decoder.readStruct("Filter", EventFilter.TYPE_ID);
            return new ReadEventDetails(numValuesPerNode, startTime, endTime, filter);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ReadEventDetails value) {
            encoder.writeUInt32("NumValuesPerNode", value.getNumValuesPerNode());
            encoder.writeDateTime("StartTime", value.getStartTime());
            encoder.writeDateTime("EndTime", value.getEndTime());
            encoder.writeStruct("Filter", (Object)value.getFilter(), EventFilter.TYPE_ID);
        }
    }
}

