/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.coordinate;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Range {
    public int start = 0;
    public int end = 0;

    public Range(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public int size() {
        return this.end - this.start;
    }

    public boolean contains(int position) {
        return position >= this.start && position < this.end;
    }

    public boolean overlap(Range range) {
        return this.start < this.end && range.start < range.end && (this.contains(range.start) || this.contains(range.end - 1) || range.contains(this.start) || range.contains(this.end - 1));
    }

    public Set<Integer> getMembers() {
        HashSet<Integer> members = new HashSet<Integer>();
        int i = this.start;
        while (i < this.end) {
            members.add(i);
            ++i;
        }
        return members;
    }

    public int[] getMembersArray() {
        int[] result = new int[this.end - this.start];
        int i = 0;
        int pos = this.start;
        while (pos < this.end) {
            result[i] = pos++;
            ++i;
        }
        return result;
    }

    public String toString() {
        return "Range[" + this.start + "," + this.end + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (this.end != other.end) {
            return false;
        }
        return this.start == other.start;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.end;
        result = 31 * result + this.start;
        return result;
    }

    public static void sortByStart(List<Range> ranges) {
        Collections.sort(ranges, Comparator.comparing(r -> r.start));
    }
}

