/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.util.stream.LongStream;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.factory.bag.primitive.MutableLongBagFactory;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.factory.primitive.LongBags;
import org.eclipse.collections.impl.utility.Iterate;

@ServiceProvider(value=MutableLongBagFactory.class)
public class MutableLongBagFactoryImpl
implements MutableLongBagFactory {
    public static final MutableLongBagFactory INSTANCE = new MutableLongBagFactoryImpl();

    public MutableLongBag empty() {
        return new LongHashBag();
    }

    public MutableLongBag of() {
        return this.empty();
    }

    public MutableLongBag with() {
        return this.empty();
    }

    public MutableLongBag of(long ... items) {
        return this.with(items);
    }

    public MutableLongBag with(long ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        return LongHashBag.newBagWith(items);
    }

    public MutableLongBag ofAll(LongIterable items) {
        return this.withAll(items);
    }

    public MutableLongBag withAll(LongIterable items) {
        return LongHashBag.newBag(items);
    }

    public MutableLongBag ofAll(Iterable<Long> iterable) {
        return this.withAll(iterable);
    }

    public MutableLongBag withAll(Iterable<Long> iterable) {
        return Iterate.collectLong(iterable, Long::longValue, LongBags.mutable.empty());
    }

    public MutableLongBag ofAll(LongStream items) {
        return this.withAll(items);
    }

    public MutableLongBag withAll(LongStream items) {
        LongHashBag bag = new LongHashBag();
        items.forEach(arg_0 -> ((MutableLongBag)bag).add(arg_0));
        return bag;
    }
}

