/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.language.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.fordiac.ide.export.language.ILanguageSupportFactory;

public class LanguageSupportRegistryImpl
implements ILanguageSupportFactory.Registry {
    final Map<String, Map<Class<?>, ILanguageSupportFactory>> filterClassToFactoryMap = new ConcurrentHashMap();

    @Override
    public ILanguageSupportFactory getFactory(String filter, Class<?> sourceClass) {
        Map<Class<?>, ILanguageSupportFactory> classToFactoryMap = this.filterClassToFactoryMap.get(filter);
        if (classToFactoryMap != null) {
            return classToFactoryMap.get(sourceClass);
        }
        return null;
    }

    @Override
    public ILanguageSupportFactory registerFactory(String filter, Class<?> sourceClass, ILanguageSupportFactory factory) {
        Map classToFactoryMap = ILanguageSupportFactory.Registry.INSTANCE.getFilterClassToFactoryMap().computeIfAbsent(filter, f -> new ConcurrentHashMap());
        return classToFactoryMap.put(sourceClass, factory);
    }

    @Override
    public Map<String, Map<Class<?>, ILanguageSupportFactory>> getFilterClassToFactoryMap() {
        return this.filterClassToFactoryMap;
    }
}

