/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.library.ui.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.fordiac.ide.library.model.library.Manifest;
import org.eclipse.fordiac.ide.library.model.util.ManifestHelper;
import org.eclipse.fordiac.ide.library.ui.Messages;
import org.eclipse.fordiac.ide.library.ui.refactoring.DeleteLibraryDependencyChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;

public class DeleteLibraryRefactoringParticipant
extends DeleteParticipant {
    private IProject project;
    private Manifest manifest;
    private boolean block;

    /*
     * WARNING - void declaration
     */
    protected boolean initialize(Object element) {
        void resource;
        if (!(element instanceof IResource)) {
            return false;
        }
        IResource iResource = (IResource)element;
        this.project = resource.getProject();
        if (this.project.getFolder("Standard Libraries").getFullPath().isPrefixOf(resource.getFullPath()) || this.project.getFolder("External Libraries").getFullPath().isPrefixOf(resource.getFullPath())) {
            IFolder folder;
            this.block = true;
            if (resource instanceof IFolder && (folder = (IFolder)resource).getFullPath().segmentCount() == 3) {
                this.manifest = ManifestHelper.getContainerManifest((IContainer)folder);
                this.block = this.manifest == null || !ManifestHelper.isLibrary((Manifest)this.manifest);
            }
            return true;
        }
        return false;
    }

    public String getName() {
        return Messages.DeleteLibraryParticipant_Name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (this.block) {
            status.addFatalError(Messages.DeleteLibraryParticipant_Block_Delete);
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.block) {
            return null;
        }
        return new DeleteLibraryDependencyChange(this.project, this.manifest.getProduct().getSymbolicName());
    }
}

