/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.libraryElement.provider;

import java.util.Collection;
import org.eclipse.fordiac.ide.model.data.InternalDataType;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.provider.AttributeItemProvider;

final class AttributeItemProviderAnnotation {
    static String getText(Attribute attribute, AttributeItemProvider provider) {
        Object label = attribute.getName();
        if (label == null || ((String)label).isBlank()) {
            return provider.getString("_UI_Attribute_type");
        }
        if (attribute.getAttributeDeclaration() != null && attribute.getAttributeDeclaration().getTypeEntry() != null && attribute.getAttributeDeclaration().getTypeEntry().getPackageName() != null && !attribute.getAttributeDeclaration().getTypeEntry().getPackageName().isBlank()) {
            label = (String)label + " [" + attribute.getAttributeDeclaration().getTypeEntry().getPackageName() + "]";
        }
        if (attribute.getType() != null && attribute.getAttributeDeclaration() == null) {
            label = (String)label + " : " + attribute.getType().getQualifiedName();
        }
        if (attribute.getValue() != null && !attribute.getValue().isBlank()) {
            label = (String)label + " := " + attribute.getValue();
        }
        return label;
    }

    public static Collection<?> filterInternalAttributes(Collection<?> children) {
        return children.stream().filter(obj -> !AttributeItemProviderAnnotation.isInternalAttribute(obj)).toList();
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isInternalAttribute(Object obj) {
        void att;
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)obj;
        return att.getType() instanceof InternalDataType || InternalAttributeDeclarations.isInternalAttribute((AttributeDeclaration)att.getAttributeDeclaration());
    }

    private AttributeItemProviderAnnotation() {
        throw new UnsupportedOperationException("Helper class shall not be instantiated!");
    }
}

