/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.st;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.EvaluatorPrepareException;
import org.eclipse.fordiac.ide.model.eval.st.StructuredTextEvaluator;
import org.eclipse.fordiac.ide.model.eval.value.BoolValue;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.eval.variable.VariableEvaluator;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.structuredtextalgorithm.util.StructuredTextParseUtil;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpressionSource;
import org.eclipse.xtext.EcoreUtil2;

public class ECTransitionEvaluator
extends StructuredTextEvaluator
implements VariableEvaluator {
    private final ECTransition transition;
    private STExpressionSource parseResult;

    public ECTransitionEvaluator(ECTransition transition, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        super("anonymous", context, variables, parent);
        this.transition = transition;
    }

    public void prepare() {
        if (this.parseResult == null && VariableOperations.hasConditionExpression((ECTransition)this.transition)) {
            ArrayList<String> errors = new ArrayList<String>();
            ArrayList<String> warnings = new ArrayList<String>();
            ArrayList<String> infos = new ArrayList<String>();
            this.parseResult = this.parseConditionExpression(errors, warnings, infos);
            errors.forEach(arg_0 -> ((ECTransitionEvaluator)this).error(arg_0));
            warnings.forEach(arg_0 -> ((ECTransitionEvaluator)this).warn(arg_0));
            infos.forEach(arg_0 -> ((ECTransitionEvaluator)this).info(arg_0));
            if (this.parseResult == null) {
                throw new EvaluatorPrepareException(errors.stream().collect(Collectors.joining(", ")), (Evaluator)this);
            }
        }
    }

    public void cleanup() {
        this.parseResult = null;
    }

    private STExpressionSource parseConditionExpression(List<String> errors, List<String> warnings, List<String> infos) {
        return StructuredTextParseUtil.parse((String)this.transition.getConditionExpression(), (LibraryElement)IecTypes.ElementaryTypes.BOOL, (LibraryElement)((LibraryElement)EcoreUtil2.getContainerOfType((EObject)this.transition, FBType.class)), errors, warnings, infos);
    }

    public Value evaluate() throws InterruptedException {
        this.prepare();
        if (this.parseResult != null && this.parseResult.getExpression() != null) {
            return this.evaluateExpression((STExpression)this.trap(this.parseResult.getExpression()));
        }
        return BoolValue.TRUE;
    }

    public Variable<?> evaluateVariable() throws EvaluatorException, InterruptedException {
        this.prepare();
        Variable result = VariableOperations.newVariable((String)"", (LibraryElement)IecTypes.ElementaryTypes.BOOL, (Value)BoolValue.TRUE);
        if (this.parseResult != null && this.parseResult.getExpression() != null) {
            result.setValue(this.evaluateExpression(((STExpressionSource)this.trap(this.parseResult)).getExpression()));
        }
        return result;
    }

    public boolean validateVariable(List<String> errors, List<String> warnings, List<String> infos) throws EvaluatorException, InterruptedException {
        if (VariableOperations.hasConditionExpression((ECTransition)this.transition)) {
            return this.parseConditionExpression(errors, warnings, infos) != null;
        }
        return true;
    }

    public LibraryElement evaluateResultType() {
        return IecTypes.ElementaryTypes.BOOL;
    }

    public boolean validateResultType(List<String> errors, List<String> warnings, List<String> infos) {
        return true;
    }

    public ECTransition getSourceElement() {
        return this.transition;
    }

    public Set<String> getDependencies() {
        this.prepare();
        if (this.parseResult != null) {
            return StructuredTextParseUtil.collectUsedTypes((EObject)this.parseResult);
        }
        return Collections.emptySet();
    }
}

