/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.nat;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;

public class TypeNode {
    private final String name;
    private final String fullName;
    private final List<TypeNode> children = new ArrayList<TypeNode>();
    private TypeNode parent;
    private final Object type;

    public TypeNode(String name) {
        this(name, name, null);
    }

    public TypeNode(LibraryElement libraryElement) {
        this(libraryElement.getName(), PackageNameHelper.getFullTypeName((LibraryElement)libraryElement), libraryElement);
    }

    public TypeNode(TypeEntry typeEntry) {
        this(typeEntry.getTypeName(), typeEntry.getFullTypeName(), typeEntry);
    }

    public TypeNode(String name, String fullName, Object type) {
        this.name = name;
        this.fullName = fullName;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getPackageName() {
        return PackageNameHelper.extractPackageName((String)this.fullName);
    }

    public List<TypeNode> getChildren() {
        return this.children;
    }

    public TypeNode getParent() {
        return this.parent;
    }

    public LibraryElement getType() {
        Object object = this.type;
        if (object instanceof LibraryElement) {
            LibraryElement libraryElement = (LibraryElement)object;
            return libraryElement;
        }
        Object object2 = this.type;
        if (object2 instanceof TypeEntry) {
            TypeEntry typeEntry = (TypeEntry)object2;
            return typeEntry.getType();
        }
        return null;
    }

    public TypeEntry getTypeEntry() {
        Object object = this.type;
        if (object instanceof TypeEntry) {
            TypeEntry typeEntry = (TypeEntry)object;
            return typeEntry;
        }
        Object object2 = this.type;
        if (object2 instanceof LibraryElement) {
            LibraryElement libraryElement = (LibraryElement)object2;
            return libraryElement.getTypeEntry();
        }
        return null;
    }

    public boolean isDirectory() {
        return this.type == null;
    }

    public void addChild(TypeNode child) {
        this.children.add(child);
        child.parent = this;
    }

    public int hashCode() {
        return Objects.hash(this.fullName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeNode other = (TypeNode)obj;
        return Objects.equals(this.fullName, other.fullName);
    }

    public void sortChildren() {
        this.children.sort(Comparator.comparing(TypeNode::getName, String.CASE_INSENSITIVE_ORDER).thenComparing(TypeNode::getFullName));
        this.children.forEach(TypeNode::sortChildren);
    }
}

