/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.validation;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fordiac.ide.globalconstantseditor.globalConstants.GlobalConstantsPackage;
import org.eclipse.fordiac.ide.globalconstantseditor.globalConstants.STVarGlobalDeclarationBlock;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.structuredtextcore.resource.STCoreResourceDescriptionStrategy;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCorePackage;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

public class STCoreTypeUsageCollector {
    private static final Set<EReference> IGNORED_REFERENCES = Set.of(STCorePackage.Literals.ST_MEMBER_ACCESS_EXPRESSION__MEMBER, STCorePackage.Literals.ST_CALL_NAMED_INPUT_ARGUMENT__PARAMETER, STCorePackage.Literals.ST_CALL_NAMED_OUTPUT_ARGUMENT__PARAMETER, STCorePackage.Literals.ST_FOR_STATEMENT__VARIABLE, STCorePackage.Literals.ST_STRUCT_INIT_ELEMENT__VARIABLE);
    @Inject
    private IQualifiedNameProvider nameProvider;
    @Inject
    private IQualifiedNameConverter nameConverter;
    @Inject
    private LinkingHelper linkingHelper;
    @Inject
    private IScopeProvider scopeProvider;
    private final Set<QualifiedName> usedTypes = new HashSet<QualifiedName>();
    private boolean includeFullyQualifiedReferences;
    private boolean includeUnresolvedReferences;

    public Set<QualifiedName> collectUsedTypes(EObject object) {
        for (EReference reference : object.eClass().getEAllReferences()) {
            if (!object.eIsSet((EStructuralFeature)reference) || IGNORED_REFERENCES.contains(reference)) continue;
            if (reference.isContainment()) {
                this.handleContainment(object, reference);
                continue;
            }
            if (reference.isContainer()) continue;
            this.handleCrossReference(object, reference);
        }
        return this.usedTypes;
    }

    protected void handleContainment(EObject object, EReference reference) {
        if (reference.isMany()) {
            List children = (List)object.eGet((EStructuralFeature)reference);
            for (EObject child : children) {
                this.collectUsedTypes(child);
            }
        } else {
            EObject child = (EObject)object.eGet((EStructuralFeature)reference);
            if (child != null) {
                this.collectUsedTypes(child);
            }
        }
    }

    protected void handleCrossReference(EObject object, EReference reference) {
        if (reference.isMany()) {
            List targets = (List)object.eGet((EStructuralFeature)reference);
            int index = 0;
            while (index < targets.size()) {
                this.handleCrossReference(object, reference, index, (EObject)targets.get(index));
                ++index;
            }
        } else {
            EObject target = (EObject)object.eGet((EStructuralFeature)reference);
            if (target != null) {
                this.handleCrossReference(object, reference, 0, target);
            }
        }
    }

    protected void handleCrossReference(EObject source, EReference reference, int index, EObject target) {
        if (STCoreTypeUsageCollector.isExternalReference(source, target)) {
            QualifiedName name = this.getCrossReferenceName(source, reference, index);
            if (target.eIsProxy()) {
                this.handleUnresolvedReference(source, reference, name);
            } else {
                this.handleExternalReference(source, reference, name, target);
            }
        }
    }

    protected void handleExternalReference(EObject source, EReference reference, QualifiedName name, EObject target) {
        IScope scope = this.scopeProvider.getScope(source, reference);
        if (name != null) {
            IEObjectDescription description = scope.getSingleElement(name);
            if (description != null) {
                this.addUsedType(description);
            }
        } else {
            IEObjectDescription description = scope.getSingleElement(target);
            if (description != null) {
                this.addUsedType(description);
            }
        }
    }

    protected void handleUnresolvedReference(EObject source, EReference reference, QualifiedName name) {
        if (name == null || !this.includeUnresolvedReferences) {
            return;
        }
        IScope scope = this.scopeProvider.getScope(source, reference);
        AliasedEObjectDescription result = null;
        for (IEObjectDescription candidate : scope.getAllElements()) {
            QualifiedName candidateName = candidate.getName();
            if (!STCoreTypeUsageCollector.isVisible(candidate) || !STCoreTypeUsageCollector.endsWith(candidateName, name)) continue;
            if (result == null) {
                result = new AliasedEObjectDescription(name, candidate);
                continue;
            }
            if (result.getQualifiedName().equals((Object)candidate.getQualifiedName())) continue;
            return;
        }
        if (result != null) {
            this.addUsedType((IEObjectDescription)result);
        }
    }

    protected static boolean isVisible(IEObjectDescription description) {
        return description.getQualifiedName().getSegmentCount() == 1 || LibraryElementPackage.eINSTANCE.getLibraryElement().isSuperTypeOf(description.getEClass()) || STCorePackage.eINSTANCE.getSTVarDeclaration().equals(description.getEClass()) && STCoreTypeUsageCollector.isGlobalVariable(description);
    }

    protected static boolean isGlobalVariable(IEObjectDescription description) {
        String containerEClassName = description.getUserData(STCoreResourceDescriptionStrategy.CONTAINER_ECLASS_NAME);
        if (containerEClassName != null) {
            return GlobalConstantsPackage.Literals.ST_VAR_GLOBAL_DECLARATION_BLOCK.getName().equals(containerEClassName);
        }
        return description.getEObjectOrProxy().eContainer() instanceof STVarGlobalDeclarationBlock;
    }

    protected static boolean endsWith(QualifiedName name, QualifiedName suffix) {
        if (suffix.getSegmentCount() > name.getSegmentCount()) {
            return false;
        }
        int offset = name.getSegmentCount() - suffix.getSegmentCount();
        int i = 0;
        while (i < suffix.getSegmentCount()) {
            if (!name.getSegment(i + offset).equalsIgnoreCase(suffix.getSegment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected QualifiedName getCrossReferenceName(EObject source, EReference reference, int index) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)source, (EStructuralFeature)reference);
        if (index >= nodes.size()) {
            return null;
        }
        String crossRefString = this.linkingHelper.getCrossRefNodeAsString((INode)nodes.get(index), true);
        if (crossRefString == null || crossRefString.isBlank()) {
            return null;
        }
        return this.nameConverter.toQualifiedName(crossRefString);
    }

    public void addUsedType(LibraryElement libraryElement) {
        QualifiedName qualifiedName = (QualifiedName)this.nameProvider.apply((Object)libraryElement);
        if (this.includeFullyQualifiedReferences || qualifiedName.getSegmentCount() > 1) {
            this.usedTypes.add(qualifiedName);
        }
    }

    protected void addUsedType(IEObjectDescription description) {
        QualifiedName relativeName = description.getName();
        QualifiedName qualifiedName = description.getQualifiedName();
        if (relativeName.getSegmentCount() < qualifiedName.getSegmentCount()) {
            this.usedTypes.add(qualifiedName.skipLast(relativeName.getSegmentCount() - 1));
        } else if (this.includeFullyQualifiedReferences) {
            this.usedTypes.add(qualifiedName);
        }
    }

    protected static boolean isExternalReference(EObject source, EObject target) {
        return source.eResource() != target.eResource();
    }

    public STCoreTypeUsageCollector includeFullyQualifiedReferences() {
        this.includeFullyQualifiedReferences = true;
        return this;
    }

    public STCoreTypeUsageCollector includeUnresolvedReferences() {
        this.includeUnresolvedReferences = true;
        return this;
    }

    public Set<QualifiedName> getUsedTypes() {
        return this.usedTypes;
    }
}

