/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.widget;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractChooserControl
extends Composite {
    private final List<IChooserValueChanged> listeners = new ArrayList<IChooserValueChanged>();
    private Text text = null;

    protected AbstractChooserControl(Composite parent, int style, String label, boolean labelInParent) {
        super(parent, style);
        this.initialize(label, labelInParent);
    }

    private void initialize(String labelText, boolean labelInParent) {
        GridLayoutFactory.fillDefaults().numColumns(3).margins(0, 5).applyTo((Composite)this);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).applyTo((Control)this);
        final Label label = new Label((Composite)(labelInParent ? this.getParent() : this), 0);
        label.setText(labelText);
        if (labelInParent) {
            label.moveAbove((Control)this);
        }
        this.text = new Text((Composite)this, 2048);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).applyTo((Control)this.text);
        Button button = new Button((Composite)this, 0);
        button.setText(FordiacMessages.DirectoryChooserControl_LABEL_Browse);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedValue = AbstractChooserControl.this.openChooserDialog(label.getText(), AbstractChooserControl.this.text.getText());
                if (selectedValue != null) {
                    AbstractChooserControl.this.text.setText(selectedValue);
                    AbstractChooserControl.this.notifyListeners();
                }
            }
        });
        this.text.addTraverseListener(e -> {
            if (e.detail == 4) {
                e.doit = false;
                this.notifyListeners();
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AbstractChooserControl.this.notifyListeners();
            }
        });
    }

    protected abstract String openChooserDialog(String var1, String var2);

    public void addChooserValueChangedListener(IChooserValueChanged listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeChooserChangedListener(IChooserValueChanged listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (IChooserValueChanged l : this.listeners) {
            l.chooserChanged(this.text.getText());
        }
    }

    public String getValue() {
        return this.text.getText();
    }

    public void setValue(String newValue) {
        this.text.setText(newValue);
    }

    public static interface IChooserValueChanged {
        public void chooserChanged(String var1);
    }
}

