/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.scaling;

import java.util.function.Consumer;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.KeyEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.scaling.ResetScalingAction;
import org.eclipse.nebula.widgets.nattable.ui.scaling.ScalingMouseWheelListener;
import org.eclipse.nebula.widgets.nattable.ui.scaling.ZoomInScalingAction;
import org.eclipse.nebula.widgets.nattable.ui.scaling.ZoomOutScalingAction;
import org.eclipse.nebula.widgets.nattable.util.PlatformHelper;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseWheelListener;

public class ScalingUiBindingConfiguration
extends AbstractUiBindingConfiguration {
    private Consumer<IConfigRegistry> updater;
    private boolean percentageScalingChange = false;

    public ScalingUiBindingConfiguration(NatTable natTable) {
        this(natTable, false, null);
    }

    public ScalingUiBindingConfiguration(NatTable natTable, Consumer<IConfigRegistry> updater) {
        this(natTable, false, updater);
    }

    public ScalingUiBindingConfiguration(NatTable natTable, boolean percentageScalingChange) {
        this(natTable, percentageScalingChange, null);
    }

    public ScalingUiBindingConfiguration(NatTable natTable, boolean percentageScalingChange, Consumer<IConfigRegistry> updater) {
        if (natTable != null && !PlatformHelper.isRAP()) {
            PlatformHelper.callSetter((Object)natTable, "addMouseWheelListener", MouseWheelListener.class, new ScalingMouseWheelListener(percentageScalingChange, updater));
        }
        this.percentageScalingChange = percentageScalingChange;
        this.updater = updater;
    }

    @Override
    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        uiBindingRegistry.registerKeyBinding(new KeyEventMatcher(SWT.MOD1, 48), new ResetScalingAction(this.updater));
        uiBindingRegistry.registerKeyBinding(new KeyEventMatcher(SWT.MOD1, 43), new ZoomInScalingAction(this.percentageScalingChange, this.updater));
        uiBindingRegistry.registerKeyBinding(new KeyEventMatcher(SWT.MOD1, 61), new ZoomInScalingAction(this.percentageScalingChange, this.updater));
        uiBindingRegistry.registerKeyBinding(new KeyEventMatcher(SWT.MOD1, 45), new ZoomOutScalingAction(this.percentageScalingChange, this.updater));
        uiBindingRegistry.registerKeyBinding(new KeyEventMatcher(SWT.MOD1, 0x1000030), new ResetScalingAction(this.updater));
        uiBindingRegistry.registerKeyBinding(new KeyEventMatcher(SWT.MOD1, 16777259), new ZoomInScalingAction(this.percentageScalingChange, this.updater));
        uiBindingRegistry.registerKeyBinding(new KeyEventMatcher(SWT.MOD1, 16777261), new ZoomOutScalingAction(this.percentageScalingChange, this.updater));
    }
}

