/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.debug.ide.launch;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.net.URI;
import org.eclipse.acceleo.aql.ls.debug.ide.AcceleoDebugPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.lsp4e.debug.launcher.DSPLaunchDelegate;

public class AcceleoLaunchConfigurationDelegate
extends DSPLaunchDelegate {
    public static final String ID = "org.eclipse.acceleo.aql.ls.debug.ide.launchConfigurationType";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
        JsonObject param = new JsonObject();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (wc.hasAttribute("module")) {
            IFile module = root.getFile((IPath)new Path(wc.getAttribute("module", null)));
            URI moduleUri = module.getLocation().toFile().getAbsoluteFile().toURI();
            param.addProperty("module", moduleUri.toString());
        }
        if (wc.hasAttribute("model")) {
            URI modelUri;
            String modelAttribute = wc.getAttribute("model", null);
            if (modelAttribute.startsWith("file:")) {
                modelUri = URI.create(modelAttribute);
            } else {
                IFile model = root.getFile((IPath)new Path(modelAttribute));
                modelUri = model.getLocation().toFile().getAbsoluteFile().toURI();
            }
            param.addProperty("model", modelUri.toString());
        }
        if (wc.hasAttribute("destination")) {
            URI destinationUri;
            String destinationAttribute = wc.getAttribute("destination", null);
            if (destinationAttribute.startsWith("file:")) {
                destinationUri = URI.create(destinationAttribute);
                File file = new File(destinationUri);
                if (!file.exists()) {
                    file.mkdirs();
                }
            } else {
                Path destinationPath = new Path(destinationAttribute);
                IResource destination = root.findMember((IPath)destinationPath);
                if (destination instanceof IFile) {
                    destination = destination.getParent();
                } else if (destination == null && !(destination = root.getFolder((IPath)destinationPath)).exists()) {
                    ((IFolder)destination).create(true, true, monitor);
                }
                destinationUri = destination.getLocation().toFile().getAbsoluteFile().toURI();
            }
            param.addProperty("destination", destinationUri.toString());
        }
        if (wc.hasAttribute("options")) {
            param.addProperty("options", wc.getAttribute("options", null));
        }
        if ("profile".equals(mode)) {
            if (wc.hasAttribute("profileModel")) {
                URI profileModelUri;
                String profileModelAttribute = wc.getAttribute("profileModel", null);
                if (profileModelAttribute.startsWith("file:")) {
                    profileModelUri = URI.create(profileModelAttribute);
                } else {
                    IFile profileModel = root.getFile((IPath)new Path(profileModelAttribute));
                    profileModelUri = profileModel.getLocation().toFile().getAbsoluteFile().toURI();
                }
                param.addProperty("profileModel", profileModelUri.toString());
            }
            if (wc.hasAttribute("modelRepresentation")) {
                param.addProperty("modelRepresentation", wc.getAttribute("modelRepresentation", null));
            }
        }
        wc.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_CUSTOM_LAUNCH_PARAMS", true);
        wc.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_PARAM", new Gson().toJson((JsonElement)param));
        wc.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MODE", "connect to server");
        wc.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MONITOR_ADAPTER", true);
        wc.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_SERVER_HOST", AcceleoDebugPlugin.getPlugin().getHost());
        wc.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_SERVER_PORT", AcceleoDebugPlugin.getPlugin().getPort());
        if ("profile".equals(mode)) {
            super.launch(wc.doSave(), "run", launch, monitor);
        } else {
            super.launch(wc.doSave(), mode, launch, monitor);
        }
    }
}

