/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.collection;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.services.collection.AbstractCollectionService;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;

public class IncludingService
extends AbstractCollectionService {
    public IncludingService(Method serviceMethod, Object serviceInstance, boolean forWorkspace) {
        super(serviceMethod, serviceInstance, forWorkspace);
    }

    @Override
    public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        result.add(this.createReturnCollectionWithType(queryEnvironment, ((ICollectionType)argTypes.get(0)).getCollectionType()));
        result.add(this.createReturnCollectionWithType(queryEnvironment, argTypes.get(1)));
        return result;
    }

    @Override
    public Set<IType> validateAllType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, Map<List<IType>, Set<IType>> allTypes) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<List<IType>, Set<IType>> entry : allTypes.entrySet()) {
            for (IType type : entry.getValue()) {
                if (((ICollectionType)type).getCollectionType() instanceof NothingType) {
                    builder.append("\n ");
                    builder.append(((NothingType)((ICollectionType)type).getCollectionType()).getMessage());
                    continue;
                }
                result.add(type);
            }
        }
        if (result.isEmpty()) {
            result.add(this.createReturnCollectionWithType(queryEnvironment, services.nothing("Nothing left after %s:" + builder.toString(), this.getName())));
        }
        return result;
    }
}

