/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.services.workspace;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.acceleo.aql.ls.AcceleoLanguageServer;
import org.eclipse.acceleo.aql.ls.services.textdocument.AcceleoTextDocument;
import org.eclipse.acceleo.aql.ls.services.workspace.AcceleoWorkspace;
import org.eclipse.acceleo.query.runtime.namespace.workspace.IQueryProject;
import org.eclipse.acceleo.query.runtime.namespace.workspace.IQueryWorkspaceQualifiedNameResolver;

public class AcceleoProject
implements IQueryProject {
    private String name;
    private final AcceleoWorkspace workspace;
    private final Map<String, AcceleoTextDocument> qualifiedNameToDocuments = new HashMap<String, AcceleoTextDocument>();

    public AcceleoProject(String name, AcceleoWorkspace workspace) {
        this.name = name;
        this.workspace = workspace;
    }

    public String getName() {
        return this.name;
    }

    public void addDocument(AcceleoTextDocument acceleoTextDocument) {
        this.qualifiedNameToDocuments.put(acceleoTextDocument.getModuleQualifiedName(), acceleoTextDocument);
    }

    public void removeDocument(AcceleoTextDocument acceleoTextDocument) {
        this.qualifiedNameToDocuments.remove(acceleoTextDocument.getModuleQualifiedName());
    }

    public AcceleoTextDocument getDocument(String qualifiedName) {
        return this.qualifiedNameToDocuments.get(qualifiedName);
    }

    public AcceleoWorkspace getWorkspace() {
        return this.workspace;
    }

    public IQueryWorkspaceQualifiedNameResolver getResolver() {
        return this.workspace.getResolver(this);
    }

    public AcceleoLanguageServer getLanguageServer() {
        return this.workspace.getOwner();
    }

    public String toString() {
        return "Acceleo Project " + this.getName();
    }
}

