/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.util.regex.Pattern;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.runtime.ICompletionResult;
import org.eclipse.acceleo.query.runtime.IProposalFilter;
import org.eclipse.acceleo.query.runtime.impl.completion.EClassifierCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.EEnumLiteralCompletionProposal;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;

public class BasicFilter
implements IProposalFilter {
    private static final Pattern CAMEL_CASE_PATTERN = Pattern.compile("([a-z]+|[A-Z][a-z]*)");
    private static final Pattern CAMEL_CASE_PREFIX_PATTERN = Pattern.compile("^([a-z]+)");
    private final ICompletionResult completionResult;

    public BasicFilter(ICompletionResult result) {
        this.completionResult = result;
    }

    @Override
    public boolean keepProposal(ICompletionProposal proposal) {
        boolean result;
        String prefix = this.completionResult.getPrefix();
        if (prefix == null) {
            result = true;
        } else if (proposal instanceof EClassifierCompletionProposal) {
            String[] segments = prefix.split("::?");
            EClassifier eClassifier = ((EClassifierCompletionProposal)proposal).getObject();
            if (segments.length == 3) {
                result = false;
            } else if (segments.length == 2) {
                result = BasicFilter.startsWithOrMatchCamelCase(eClassifier.getEPackage().getName(), segments[0]) && BasicFilter.startsWithOrMatchCamelCase(eClassifier.getName(), segments[1]);
            } else if (segments.length == 1) {
                boolean endsWithEmptySegment = prefix.endsWith(":");
                result = BasicFilter.startsWithOrMatchCamelCase(eClassifier.getEPackage().getName(), segments[0]) || !endsWithEmptySegment && BasicFilter.startsWithOrMatchCamelCase(eClassifier.getName(), segments[0]);
            } else {
                result = true;
            }
        } else if (proposal instanceof EEnumLiteralCompletionProposal) {
            String[] segments = prefix.split("::?");
            EEnumLiteral eEnumLiteral = ((EEnumLiteralCompletionProposal)proposal).getObject();
            if (segments.length == 3) {
                result = BasicFilter.startsWithOrMatchCamelCase(eEnumLiteral.getEEnum().getEPackage().getName(), segments[0]) && BasicFilter.startsWithOrMatchCamelCase(eEnumLiteral.getEEnum().getName(), segments[1]) && BasicFilter.startsWithOrMatchCamelCase(eEnumLiteral.getName(), segments[2]);
            } else if (segments.length == 2) {
                boolean endsWithEmptySegment = prefix.endsWith(":");
                result = BasicFilter.startsWithOrMatchCamelCase(eEnumLiteral.getEEnum().getEPackage().getName(), segments[0]) && (BasicFilter.startsWithOrMatchCamelCase(eEnumLiteral.getEEnum().getName(), segments[1]) || !endsWithEmptySegment && BasicFilter.startsWithOrMatchCamelCase(eEnumLiteral.getName(), segments[1]));
            } else if (segments.length == 1) {
                boolean endsWithEmptySegment = prefix.endsWith(":");
                result = BasicFilter.startsWithOrMatchCamelCase(eEnumLiteral.getEEnum().getEPackage().getName(), segments[0]) || !endsWithEmptySegment && BasicFilter.startsWithOrMatchCamelCase(eEnumLiteral.getEEnum().getName(), segments[0]) || !endsWithEmptySegment && BasicFilter.startsWithOrMatchCamelCase(eEnumLiteral.getName(), segments[0]);
            } else {
                result = true;
            }
        } else {
            result = BasicFilter.startsWithOrMatchCamelCase(proposal.getProposal(), prefix);
        }
        return result;
    }

    public static boolean startsWithOrMatchCamelCase(String candidate, String query) {
        boolean result;
        String localQuery;
        String localCandidate = candidate != null && candidate.startsWith("_") ? candidate.substring(1) : candidate;
        if (BasicFilter.startsWithIgnoreCase(localCandidate, localQuery = candidate != null && query.startsWith("_") ? query.substring(1) : query)) {
            result = true;
        } else if (localCandidate != null) {
            Object regex = CAMEL_CASE_PATTERN.matcher(localQuery).replaceAll("$1[^A-Z]*") + ".*";
            regex = CAMEL_CASE_PREFIX_PATTERN.matcher((CharSequence)regex).replaceFirst("(?i)$1(?-i)");
            regex = ".*?" + (String)regex;
            result = localCandidate.matches((String)regex);
        } else {
            result = false;
        }
        return result;
    }

    private static boolean startsWithIgnoreCase(String candidate, String prefix) {
        return candidate != null && candidate.regionMatches(true, 0, prefix, 0, prefix.length());
    }
}

