/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl.namespace;

import java.util.Objects;
import org.eclipse.acceleo.query.runtime.namespace.ISourceLocation;

public class Position
implements ISourceLocation.IPosition {
    private final int line;
    private final int column;
    private final int position;

    public Position(int line, int column, int position) {
        this.line = line;
        this.column = column;
        this.position = position;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public static ISourceLocation.IPosition getCorrespondingPosition(int characterIndex, String text) {
        Objects.requireNonNull(text);
        int currentLine = 0;
        int currentColumn = 0;
        int i = 0;
        while (i < characterIndex) {
            int textLength = text.length();
            int newLineLength = Position.newLineAt(text, textLength, i);
            if (newLineLength != 0) {
                ++currentLine;
                currentColumn = 0;
                i += newLineLength;
                continue;
            }
            ++currentColumn;
            ++i;
        }
        return new Position(currentLine, currentColumn, characterIndex);
    }

    private static int newLineAt(String text, int textLength, int index) {
        int res = index < textLength ? (text.charAt(index) == '\r' && index + 1 < textLength && text.charAt(index + 1) == '\n' ? 2 : (text.charAt(index) == '\n' || text.charAt(index) == '\r' ? 1 : 0)) : 0;
        return res;
    }
}

