/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.profiler.internal;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.acceleo.aql.profiler.IProfiler;
import org.eclipse.acceleo.aql.profiler.ProfileEntry;
import org.eclipse.acceleo.aql.profiler.ProfilerFactory;
import org.eclipse.acceleo.aql.profiler.ProfilerPackage;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public abstract class AbstractProfiler
implements IProfiler {
    public static final EObject INTERNAL = ProfilerPackage.eINSTANCE.getEClassifier("Internal");

    @Override
    public void save(URI modelURI) throws IOException {
        this.addDefaultNodes();
        this.computePercentage();
        if (this.getResource() != null) {
            this.save(this.getResource(), modelURI);
        }
    }

    private void computePercentage() {
        if (this.getResource() != null && this.getResource().getEntry() != null) {
            ProfileEntry root = this.getResource().getEntry();
            long baseTime = root.getDuration();
            root.setPercentage(100.0f);
            TreeIterator it = root.eAllContents();
            while (it.hasNext()) {
                ProfileEntry node = (ProfileEntry)it.next();
                if (node.getDuration() == baseTime) {
                    node.setPercentage(100.0f);
                    continue;
                }
                node.setPercentage((float)node.getDuration() * 100.0f / (float)baseTime);
            }
        }
    }

    protected void addDefaultNodes() {
        if (this.getResource() != null && this.getResource().getEntry() != null) {
            this.addDefaultNodes(this.getResource().getEntry());
        }
    }

    private void addDefaultNodes(ProfileEntry entry) {
        long childrenDuration = 0L;
        for (ProfileEntry child : entry.getCallees()) {
            childrenDuration += child.getDuration();
            this.addDefaultNodes(child);
        }
        if (entry.getCallees().size() > 0 && entry.getDuration() - childrenDuration > 0L) {
            ProfileEntry def = ProfilerFactory.eINSTANCE.createProfileEntry();
            def.setCreationTime(System.currentTimeMillis());
            def.setDuration(entry.getDuration() - childrenDuration);
            def.setMonitored(INTERNAL);
            entry.getCallees().add((Object)def);
        }
    }

    private void save(EObject result, URI modelURI) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource newModelResource = resourceSet.createResource(modelURI);
        newModelResource.getContents().add((Object)result);
        HashMap options = new HashMap();
        newModelResource.save(options);
        newModelResource.unload();
    }
}

