/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.profiler.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.acceleo.aql.profiler.ProfileEntry;
import org.eclipse.acceleo.aql.profiler.ProfileResource;
import org.eclipse.acceleo.aql.profiler.ProfilerFactory;
import org.eclipse.acceleo.aql.profiler.internal.AbstractProfiler;
import org.eclipse.acceleo.aql.profiler.internal.ArrayStack;
import org.eclipse.acceleo.aql.profiler.internal.IStack;
import org.eclipse.emf.ecore.EObject;

public final class FlatProfiler
extends AbstractProfiler {
    private final Map<EObject, ProfileEntry> map = new HashMap<EObject, ProfileEntry>();
    private final ProfilerFactory profilerFactory;
    private final String startResource;
    private ProfileResource resource;
    private ProfileEntry root;
    private final IStack<ProfileEntry> stack = new ArrayStack<ProfileEntry>(200);

    public FlatProfiler(ProfilerFactory profilerFactory, String startResource) {
        this.profilerFactory = profilerFactory;
        this.startResource = startResource;
    }

    @Override
    public void reset() {
        this.map.clear();
        this.resource = null;
        this.root = null;
        this.stack.clear();
    }

    @Override
    public <L extends ProfileEntry> L start(EObject monitored) {
        ProfileEntry entry;
        if (this.resource == null) {
            this.resource = this.profilerFactory.createProfileResource();
            this.resource.setStartResource(this.startResource);
            this.root = this.profilerFactory.createProfileEntry();
            this.resource.setEntry(this.root);
            this.root.start();
        }
        if ((entry = this.map.get(monitored)) == null) {
            entry = this.profilerFactory.createProfileEntry();
            entry.setMonitored(monitored);
            this.map.put(monitored, entry);
            this.root.getCallees().add((Object)entry);
        }
        entry.start();
        this.stack.push(entry);
        return (L)entry;
    }

    @Override
    public <L extends ProfileEntry> L stop() {
        ProfileEntry currentEntry = this.stack.pop();
        currentEntry.stop();
        if (this.stack.size() == 0) {
            this.root.stop();
        }
        return (L)currentEntry;
    }

    @Override
    public ProfileResource getResource() {
        return this.resource;
    }
}

