/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import com.ibm.icu.util.ULocale;
import java.net.URL;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.CoreTestUtil;
import org.eclipse.birt.report.model.core.DesignSession;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.TextItem;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class DesignSessionTest
extends BaseTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testOpenDesign() throws DesignFileException {
        ULocale defaultULocale = ULocale.getDefault();
        ULocale.setDefault((ULocale)ULocale.CHINESE);
        DesignSession session = new DesignSession(null);
        DesignSessionTest.assertEquals((Object)ULocale.CHINESE, (Object)CoreTestUtil.getSessionLocale((DesignSession)session));
        session = new DesignSession(ULocale.ENGLISH);
        DesignSessionTest.assertEquals((Object)ULocale.ENGLISH, (Object)CoreTestUtil.getSessionLocale((DesignSession)session));
        ReportDesign design = session.createDesign(null, null);
        DesignSessionTest.assertNotNull((Object)design);
        DesignSessionTest.assertEquals((Object)session, (Object)CoreTestUtil.getDesignSession((Module)design));
        design = session.openDesign(this.getResource("input/DesignSessionTest.xml").toString());
        DesignSessionTest.assertEquals((Object)session, (Object)CoreTestUtil.getDesignSession((Module)design));
        design = session.openDesign(this.getResource("input/DesignSessionTest.xml").toString());
        DesignSessionTest.assertEquals((int)3, (int)CoreTestUtil.getDesigns((DesignSession)session).size());
        session.drop((Module)design);
        DesignSessionTest.assertEquals((int)2, (int)CoreTestUtil.getDesigns((DesignSession)session).size());
        design = session.createDesign("template", null);
        DesignSessionTest.assertEquals((int)3, (int)CoreTestUtil.getDesigns((DesignSession)session).size());
        ULocale.setDefault((ULocale)defaultULocale);
    }

    public void testCreateDesignFromTemplate() throws DesignFileException {
        DesignSession session = new DesignSession(null);
        URL url = this.getResource("input/CreateDesignFromTemplateTest.xml");
        this.design = session.createDesignFromTemplate(url.toString());
        Label label = (Label)this.design.findElement("Label1");
        DesignSessionTest.assertNotNull((Object)label);
        DesignSessionTest.assertEquals((Object)"Test", (Object)label.getProperty(this.design.getRoot(), "text"));
        DesignSessionTest.assertEquals(null, (String)this.design.getFileName());
        TextItem text = (TextItem)this.design.findElement("NewText");
        DesignSessionTest.assertEquals((Object)"blue", (Object)text.getProperty(this.design.getRoot(), "color"));
        DesignSessionTest.assertEquals((Object)"\"Arial\"", (Object)text.getProperty(this.design.getRoot(), "fontFamily"));
        DesignSessionTest.assertEquals((Object)"white", (Object)text.getProperty(this.design.getRoot(), "backgroundColor"));
        DesignSessionTest.assertEquals((Object)"hello world", (Object)text.getProperty(this.design.getRoot(), "content"));
        List libs = this.design.getLibraries();
        DesignSessionTest.assertEquals((int)1, (int)libs.size());
        Library lib = (Library)libs.get(0);
        DesignSessionTest.assertEquals((String)"LibraryForCreateDesignFromTemplateTest", (String)lib.getNamespace());
    }

    public void testCreateLibraryFromTemplate() throws Exception {
        DesignSession session = new DesignSession(null);
        URL url = this.getResource("input/CreateLibraryFromTemplateTest.xml");
        Library library = session.createLibraryFromTemplate(url.toString());
        Label label = (Label)library.findElement("NewLabel");
        DesignSessionTest.assertNotNull((Object)label);
        DesignSessionTest.assertEquals((long)5L, (long)label.getID());
        DesignSessionTest.assertEquals((Object)"aaa", (Object)label.getProperty(library.getRoot(), "text"));
        DesignSessionTest.assertEquals((Object)"blue", (Object)label.getProperty(library.getRoot(), "color"));
        DesignSessionTest.assertEquals((Object)"aqua", (Object)label.getProperty(library.getRoot(), "backgroundColor"));
        DesignSessionTest.assertEquals(null, (String)library.getFileName());
        url = this.getResource("input/CreateLibraryFromTemplateTest_1.xml");
        library = session.createLibraryFromTemplate(url.toString());
        this.save(library.getModuleHandle());
        DesignSessionTest.assertTrue((boolean)this.compareFile("DesignSessionTest_golden.xml"));
    }

    public void testSetValue() throws PropertyValueException {
        DesignSession session = new DesignSession(null);
        DesignSessionTest.assertEquals((int)3, (int)session.getColorFormat());
        session.setColorFormat(2);
        DesignSessionTest.assertEquals((int)2, (int)session.getColorFormat());
        try {
            session.setColorFormat(999999);
            DesignSessionTest.fail();
        }
        catch (PropertyValueException e) {
            DesignSessionTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        DesignSessionTest.assertEquals((int)2, (int)session.getColorFormat());
        DesignSessionTest.assertEquals((String)"in", (String)session.getUnits());
        session.setUnits("cm");
        DesignSessionTest.assertEquals((String)"cm", (String)session.getUnits());
        try {
            session.setUnits("wrong units");
            DesignSessionTest.fail();
        }
        catch (PropertyValueException e) {
            DesignSessionTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        DesignSessionTest.assertEquals((String)"cm", (String)session.getUnits());
        DesignSessionTest.assertNull((Object)session.getDefaultValue("fontSize"));
        session.setDefaultValue("fontSize", (Object)"3cm");
        DesignSessionTest.assertEquals((String)"3cm", (String)((DimensionValue)session.getDefaultValue("fontSize")).toString());
        try {
            session.setDefaultValue("fontSize", (Object)"wrong value");
            DesignSessionTest.fail();
        }
        catch (PropertyValueException pve) {
            DesignSessionTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)pve.getErrorCode());
        }
        session.setDefaultValue("fontSize", null);
    }
}

