/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.extension;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class OdaElementExtensionTest
extends BaseTestCase {
    private static final String DATASOURCE_EXTENSION_ID = "org.eclipse.birt.report.data.oda.jdbc";
    private static final String DATASET_EXTENSION_ID = "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testParser() throws DesignFileException {
        this.openDesign("ODAElementExtensionTest.xml");
        OdaDataSourceHandle dataSourceHandle = (OdaDataSourceHandle)this.designHandle.findDataSource("dataSource");
        OdaElementExtensionTest.assertEquals((String)DATASOURCE_EXTENSION_ID, (String)dataSourceHandle.getExtensionID());
        OdaElementExtensionTest.assertEquals((String)"User", (String)dataSourceHandle.getStringProperty("odaUser"));
        OdaElementExtensionTest.assertEquals((String)"DoNotKnow", (String)dataSourceHandle.getStringProperty("odaPassword"));
        OdaElementExtensionTest.assertEquals((String)"URL", (String)dataSourceHandle.getStringProperty("odaURL"));
        OdaElementExtensionTest.assertEquals((String)"DriverClass", (String)dataSourceHandle.getStringProperty("odaDriverClass"));
        OdaDataSetHandle dataSetHandle = (OdaDataSetHandle)this.designHandle.findDataSet("dataSet");
        OdaElementExtensionTest.assertEquals((String)DATASET_EXTENSION_ID, (String)dataSetHandle.getExtensionID());
        OdaElementExtensionTest.assertEquals((String)"dataSource", (String)dataSetHandle.getStringProperty("dataSource"));
        OdaElementExtensionTest.assertEquals((String)"select * from customers", (String)dataSetHandle.getStringProperty("queryText"));
        OdaElementExtensionTest.assertEquals((String)"30", (String)dataSetHandle.getStringProperty("queryTimeOut"));
    }

    public void testWriter() throws Exception {
        this.openDesign("ODAElementExtensionTest.xml");
        OdaDataSourceHandle dataSourceHandle = (OdaDataSourceHandle)this.designHandle.findDataSource("dataSource");
        dataSourceHandle.setProperty("odaUser", (Object)"NewUser");
        dataSourceHandle.setProperty("odaPassword", (Object)"NewPassword");
        dataSourceHandle.setProperty("odaURL", (Object)"NewURL");
        dataSourceHandle.setProperty("odaDriverClass", (Object)"NewDriverClass");
        OdaDataSetHandle dataSetHandle = (OdaDataSetHandle)this.designHandle.findDataSet("dataSet");
        dataSetHandle.setProperty("queryText", (Object)"select * from cities");
        dataSetHandle.setProperty("queryTimeOut", (Object)"60");
        this.save();
        OdaElementExtensionTest.assertTrue((boolean)this.compareFile("ODAElementExtensionTest_golden.xml"));
    }

    public void testNewElementFrom() throws Exception {
        this.openDesign("ODAElementExtensionTest.xml");
        OdaDataSourceHandle dataSource = (OdaDataSourceHandle)this.designHandle.findDataSource("dataSource");
        OdaElementExtensionTest.assertEquals((String)DATASOURCE_EXTENSION_ID, (String)dataSource.getExtensionID());
        OdaDataSourceHandle extendsSource = (OdaDataSourceHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)dataSource, "dataSource1");
        OdaElementExtensionTest.assertEquals((String)DATASOURCE_EXTENSION_ID, (String)extendsSource.getExtensionID());
        OdaDataSetHandle dataSet = (OdaDataSetHandle)this.designHandle.findDataSet("dataSet");
        OdaElementExtensionTest.assertEquals((String)DATASET_EXTENSION_ID, (String)dataSet.getExtensionID());
        OdaDataSetHandle extendsSet = (OdaDataSetHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)dataSet, "dataSet1");
        OdaElementExtensionTest.assertEquals((String)DATASET_EXTENSION_ID, (String)extendsSet.getExtensionID());
    }

    public void testSetExtends() throws Exception {
        this.sessionHandle = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.designHandle = this.sessionHandle.createDesign();
        OdaDataSourceHandle dataSource1 = this.designHandle.getElementFactory().newOdaDataSource("ds1", DATASOURCE_EXTENSION_ID);
        this.designHandle.getDataSources().add((DesignElementHandle)dataSource1);
        OdaDataSourceHandle dataSource2 = this.designHandle.getElementFactory().newOdaDataSource("ds2", null);
        this.designHandle.getDataSources().add((DesignElementHandle)dataSource2);
        try {
            dataSource2.setExtends((DesignElementHandle)dataSource1);
            OdaElementExtensionTest.fail();
        }
        catch (ExtendsException e) {
            OdaElementExtensionTest.assertEquals((String)"Error.WrongTypeException.WRONG_TYPE", (String)e.getErrorCode());
        }
        try {
            dataSource1.setExtends((DesignElementHandle)dataSource2);
            OdaElementExtensionTest.fail();
        }
        catch (ExtendsException e) {
            OdaElementExtensionTest.assertEquals((String)"Error.WrongTypeException.WRONG_TYPE", (String)e.getErrorCode());
        }
        dataSource2.getElement().setProperty("extensionID", (Object)DATASOURCE_EXTENSION_ID);
        dataSource2.setExtends((DesignElementHandle)dataSource1);
    }
}

