/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import java.util.Locale;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.TextArea;
import org.eclipse.birt.report.engine.layout.pdf.WordRecognizerWrapper;
import org.eclipse.birt.report.engine.layout.pdf.font.FontHandler;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManager;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.DefaultHyphenationManager;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.Hyphenation;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.IWordRecognizer;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.Word;
import org.eclipse.birt.report.engine.layout.pdf.text.Chunk;
import org.eclipse.birt.report.engine.layout.pdf.text.ChunkGenerator;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public class TextCompositor {
    private int letterSpacing = 0;
    private int wordSpacing = 0;
    private FontInfo fontInfo;
    private int lineBaseLevel;
    private int runLevel;
    int offset = 0;
    private ChunkGenerator remainChunks;
    private IWordRecognizer remainWords;
    private Word remainWord;
    private Word wordVestige;
    private boolean hasLineBreak = false;
    private boolean isNewLine = true;
    boolean textWrapping;
    boolean bidiProcessing;
    boolean fontSubstitution;
    boolean hyphenation;
    private ITextContent textContent;
    private FontMappingManager fontManager;
    private Locale locale;
    protected IStyle areaStyle = null;

    public TextCompositor(ITextContent textContent, FontMappingManager fontManager, boolean bidiProcessing, boolean fontSubstitution, boolean textWrapping, boolean hyphenation, Locale locale) {
        this.textContent = textContent;
        this.fontManager = fontManager;
        this.bidiProcessing = bidiProcessing;
        this.fontSubstitution = fontSubstitution;
        this.hyphenation = hyphenation;
        this.locale = locale;
        IStyle style = textContent.getComputedStyle();
        this.letterSpacing = PropertyUtil.getDimensionValue(style.getProperty(70));
        this.wordSpacing = PropertyUtil.getDimensionValue(style.getProperty(42));
        this.textWrapping = textWrapping && !PropertyUtil.isWhiteSpaceNoWrap(style.getProperty(61));
        this.remainChunks = new ChunkGenerator(fontManager, textContent, bidiProcessing, fontSubstitution);
    }

    public boolean hasNextArea() {
        if (!this.textWrapping && this.hasLineBreak) {
            return false;
        }
        return this.offset < this.textContent.getText().length();
    }

    public void setNewLineStatus(boolean status) {
        this.isNewLine = status;
    }

    public TextArea getNextArea(int maxLineWidth) {
        if (!this.hasNextArea()) {
            throw new RuntimeException("No more text.");
        }
        TextArea textArea = this.getNextTextArea(maxLineWidth);
        this.offset += textArea.getTextLength();
        return textArea;
    }

    private TextArea getNextTextArea(int maxLineWidth) {
        if (this.wordVestige != null) {
            TextArea textArea = this.createTextArea(this.textContent, this.offset, this.lineBaseLevel, this.runLevel, this.fontInfo);
            textArea.setMaxWidth(maxLineWidth);
            textArea.setWidth(0);
            this.addWordIntoTextArea(textArea, this.wordVestige);
            return textArea;
        }
        if (this.remainWord != null) {
            TextArea textArea = this.createTextArea(this.textContent, this.offset, this.lineBaseLevel, this.runLevel, this.fontInfo);
            textArea.setMaxWidth(maxLineWidth);
            textArea.setWidth(0);
            this.addWordIntoTextArea(textArea, this.remainWord);
            this.remainWord = null;
            return textArea;
        }
        if (this.remainWords == null || !this.remainWords.hasWord()) {
            Chunk chunk = this.remainChunks.getNext();
            if (chunk == Chunk.HARD_LINE_BREAK) {
                FontHandler handler = new FontHandler(this.fontManager, this.textContent, false);
                TextArea textArea = (TextArea)AreaFactory.createTextArea(this.textContent, handler.getFontInfo(), true);
                textArea.setTextLength(chunk.getLength());
                this.hasLineBreak = true;
                return textArea;
            }
            this.fontInfo = chunk.getFontInfo();
            this.lineBaseLevel = chunk.getBaseLevel();
            this.runLevel = chunk.getRunLevel();
            this.remainWords = new WordRecognizerWrapper(chunk.getText(), this.locale);
        }
        TextArea textArea = this.createTextArea(this.textContent, this.offset, this.lineBaseLevel, this.runLevel, this.fontInfo);
        textArea.setMaxWidth(maxLineWidth);
        textArea.setWidth(0);
        this.addWordsIntoTextArea(textArea, this.remainWords);
        return textArea;
    }

    protected TextArea createTextArea(ITextContent textContent, int offset, int baseLevel, int runLevel, FontInfo fontInfo) {
        if (this.areaStyle == null) {
            TextArea textArea = (TextArea)AreaFactory.createTextArea(textContent, offset, this.lineBaseLevel, runLevel, fontInfo);
            this.areaStyle = textArea.getStyle();
            return textArea;
        }
        return (TextArea)AreaFactory.createTextArea(textContent, this.areaStyle, offset, this.lineBaseLevel, runLevel, fontInfo);
    }

    private void addWordsIntoTextArea(TextArea textArea, IWordRecognizer words) {
        while (words.hasWord()) {
            Word word = words.getNextWord();
            this.addWordIntoTextArea(textArea, word);
            if (!textArea.isLineBreak()) continue;
            return;
        }
    }

    private void addWordIntoTextArea(TextArea textArea, Word word) {
        int textLength = word.getLength();
        int wordWidth = this.getWordWidth(this.fontInfo, word);
        if (textArea.hasSpace(wordWidth += this.letterSpacing * textLength)) {
            this.addWord(textArea, textLength, wordWidth);
            this.wordVestige = null;
            if (this.remainWords.hasWord()) {
                if (textArea.hasSpace(this.wordSpacing)) {
                    textArea.addWordSpacing(this.wordSpacing);
                } else {
                    textArea.setLineBreak(true);
                    this.hasLineBreak = true;
                }
            }
        } else {
            if (this.isNewLine && textArea.isEmpty()) {
                if (this.hyphenation) {
                    this.doHyphenation(word.getValue(), textArea);
                } else {
                    this.addWord(textArea, textLength, wordWidth);
                }
            } else {
                this.wordVestige = null;
                this.remainWord = word;
            }
            textArea.setLineBreak(true);
            this.hasLineBreak = true;
        }
    }

    private void doHyphenation(String str, TextArea area) {
        DefaultHyphenationManager hm = new DefaultHyphenationManager();
        Hyphenation hyph = hm.getHyphenation(str);
        FontInfo fi = area.getFontInfo();
        if (area.getMaxWidth() < 0) {
            this.addWordVestige(area, 1, this.getTextWidth(fi, hyph.getHyphenText(0, 1)), str.substring(1));
            return;
        }
        int endHyphenIndex = this.hyphen(0, area.getMaxWidth() - area.getWidth(), hyph, fi);
        if (endHyphenIndex == 0 && area.getWidth() == 0) {
            this.addWordVestige(area, 1, this.getTextWidth(fi, hyph.getHyphenText(0, 1)), str.substring(1));
        } else {
            this.addWordVestige(area, endHyphenIndex, this.getTextWidth(fi, hyph.getHyphenText(0, endHyphenIndex)) + this.letterSpacing * (endHyphenIndex - 1), str.substring(endHyphenIndex));
        }
    }

    private void addWordVestige(TextArea area, int vestigeTextLength, int vestigeWordWidth, String vestigeString) {
        this.addWord(area, vestigeTextLength, vestigeWordWidth);
        this.wordVestige = vestigeString.length() == 0 ? null : new Word(vestigeString, 0, vestigeString.length());
    }

    private int hyphen(int startIndex, int width, Hyphenation hyphenation, FontInfo fi) {
        assert (startIndex >= 0);
        if (startIndex > hyphenation.length() - 1) {
            return -1;
        }
        int last = 0;
        int current = 0;
        int i = startIndex + 1;
        while (i < hyphenation.length()) {
            last = current;
            String pre = hyphenation.getHyphenText(startIndex, i);
            current = (int)(fi.getWordWidth(pre) * 1000.0f) + this.letterSpacing * pre.length();
            if (width > last && width <= current) {
                return i - 1;
            }
            ++i;
        }
        return hyphenation.length() - 1;
    }

    private int getTextWidth(FontInfo fontInfo, String text) {
        return (int)(fontInfo.getWordWidth(text) * 1000.0f);
    }

    private int getWordWidth(FontInfo fontInfo, Word word) {
        return this.getTextWidth(fontInfo, word.getValue());
    }

    private void addWord(TextArea textArea, int textLength, int wordWidth) {
        textArea.addWord(textLength, wordWidth);
    }
}

