/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.util.DimensionValueUtil;

public class StringUtil {
    public static final String EMPTY_STRING = "";
    private static final Map<Integer, NumberFormatter> formatters = new HashMap<Integer, NumberFormatter>(6);

    static {
        formatters.put(ULocale.ENGLISH.toString().hashCode(), new NumberFormatter(ULocale.US));
        formatters.put(ULocale.ENGLISH.toString().hashCode(), new NumberFormatter(ULocale.ENGLISH));
        formatters.put(ULocale.SIMPLIFIED_CHINESE.toString().hashCode(), new NumberFormatter(ULocale.SIMPLIFIED_CHINESE));
    }

    public static String trimString(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        return value;
    }

    public static String toRgbText(int rgb) {
        if (rgb > 0xFFFFFF) {
            rgb = 0xFFFFFF;
        }
        if (rgb < 0) {
            rgb = 0;
        }
        String str = "000000" + Integer.toHexString(rgb);
        return "#" + str.substring(str.length() - 6);
    }

    public static boolean isValidLocale(String locale) {
        return true;
    }

    public static boolean isBlank(String str) {
        return StringUtil.trimString(str) == null;
    }

    public static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static boolean isEqual(String str1, String str2) {
        return str1 == str2 || str1 != null && str1.equals(str2);
    }

    public static boolean isEqualIgnoreCase(String str1, String str2) {
        return str1 == str2 || str1 != null && str1.equalsIgnoreCase(str2);
    }

    public static String doubleToString(double d, int fNumber) {
        return StringUtil.doubleToString(d, fNumber, ULocale.ENGLISH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doubleToString(double d, int fNumber, ULocale locale) {
        Integer localeCode;
        NumberFormatter formatter;
        if (fNumber < 0) {
            fNumber = 0;
        }
        String pattern = null;
        switch (fNumber) {
            case 0: {
                pattern = "#0";
                break;
            }
            default: {
                pattern = "#0.";
                StringBuilder b = new StringBuilder(pattern);
                int i = 0;
                while (i < fNumber) {
                    b.append('#');
                    ++i;
                }
                pattern = b.toString();
            }
        }
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        if ((formatter = formatters.get(localeCode = Integer.valueOf(locale.toString().hashCode()))) == null) {
            Map<Integer, NumberFormatter> map = formatters;
            synchronized (map) {
                formatter = formatters.get(localeCode);
                if (formatter == null) {
                    formatter = new NumberFormatter(locale);
                    formatters.put(localeCode, formatter);
                }
            }
        }
        formatter.applyPattern(pattern);
        String value = formatter.format(d);
        return value;
    }

    public static DimensionValue parse(String value) throws PropertyValueException {
        return DimensionValueUtil.doParse(value, false, null);
    }

    public static DimensionValue parseInput(String value, ULocale locale) throws PropertyValueException {
        return DimensionValueUtil.doParse(value, true, locale);
    }

    public static String extractFileName(String filePathName) {
        int backSlashPos;
        if (filePathName == null) {
            return null;
        }
        int dotPos = filePathName.lastIndexOf(46);
        int slashPos = filePathName.lastIndexOf(92);
        int n = slashPos = slashPos > (backSlashPos = filePathName.lastIndexOf(47)) ? slashPos : backSlashPos;
        if (dotPos > slashPos) {
            return filePathName.substring(slashPos > 0 ? slashPos + 1 : 0, dotPos);
        }
        return filePathName.substring(slashPos > 0 ? slashPos + 1 : 0);
    }

    public static String extractFileNameWithSuffix(String filePathName) {
        int backSlashPos;
        if (filePathName == null) {
            return null;
        }
        int slashPos = filePathName.lastIndexOf(92);
        slashPos = slashPos > (backSlashPos = filePathName.lastIndexOf(47)) ? slashPos : backSlashPos;
        return filePathName.substring(slashPos > 0 ? slashPos + 1 : 0);
    }

    public static String extractNamespace(String qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        int pos = qualifiedName.indexOf(46);
        if (pos == -1) {
            return null;
        }
        return StringUtil.trimString(qualifiedName.substring(0, pos));
    }

    public static String extractName(String qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        int pos = qualifiedName.indexOf(46);
        if (pos == -1) {
            return qualifiedName;
        }
        return StringUtil.trimString(qualifiedName.substring(pos + 1));
    }

    public static String buildQualifiedReference(String namespace, String value) {
        if (StringUtil.isBlank(namespace)) {
            return value;
        }
        return namespace + "." + value;
    }

    public static String trimQuotes(String value) {
        if (value == null) {
            return value;
        }
        if ((value = value.trim()).startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }
}

