/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.text.pdf.events;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.openpdf.text.Document;
import org.openpdf.text.DocumentException;
import org.openpdf.text.ExceptionConverter;
import org.openpdf.text.Rectangle;
import org.openpdf.text.error_messages.MessageLocalization;
import org.openpdf.text.pdf.PdfContentByte;
import org.openpdf.text.pdf.PdfFormField;
import org.openpdf.text.pdf.PdfName;
import org.openpdf.text.pdf.PdfPCell;
import org.openpdf.text.pdf.PdfPCellEvent;
import org.openpdf.text.pdf.PdfPageEventHelper;
import org.openpdf.text.pdf.PdfRectangle;
import org.openpdf.text.pdf.PdfWriter;
import org.openpdf.text.pdf.TextField;

public class FieldPositioningEvents
extends PdfPageEventHelper
implements PdfPCellEvent {
    public float padding;
    protected Map<String, PdfFormField> genericChunkFields = new HashMap<String, PdfFormField>();
    protected PdfFormField cellField = null;
    protected PdfWriter fieldWriter = null;
    protected PdfFormField parent = null;

    public FieldPositioningEvents() {
    }

    public FieldPositioningEvents(PdfWriter writer, PdfFormField field) {
        this.cellField = field;
        this.fieldWriter = writer;
    }

    public FieldPositioningEvents(PdfFormField parent, PdfFormField field) {
        this.cellField = field;
        this.parent = parent;
    }

    public FieldPositioningEvents(PdfWriter writer, String text) throws IOException, DocumentException {
        this.fieldWriter = writer;
        TextField tf = new TextField(writer, new Rectangle(0.0f, 0.0f), text);
        tf.setFontSize(14.0f);
        this.cellField = tf.getTextField();
    }

    public FieldPositioningEvents(PdfWriter writer, PdfFormField parent, String text) throws IOException, DocumentException {
        this.parent = parent;
        TextField tf = new TextField(writer, new Rectangle(0.0f, 0.0f), text);
        tf.setFontSize(14.0f);
        this.cellField = tf.getTextField();
    }

    public void addField(String text, PdfFormField field) {
        this.genericChunkFields.put(text, field);
    }

    public void setPadding(float padding) {
        this.padding = padding;
    }

    public void setParent(PdfFormField parent) {
        this.parent = parent;
    }

    @Override
    public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {
        rect.setBottom(rect.getBottom() - 3.0f);
        PdfFormField field = this.genericChunkFields.get(text);
        if (field == null) {
            TextField tf = new TextField(writer, new Rectangle(rect.getLeft(this.padding), rect.getBottom(this.padding), rect.getRight(this.padding), rect.getTop(this.padding)), text);
            tf.setFontSize(14.0f);
            try {
                field = tf.getTextField();
            }
            catch (Exception e) {
                throw new ExceptionConverter(e);
            }
        } else {
            field.put(PdfName.RECT, new PdfRectangle(rect.getLeft(this.padding), rect.getBottom(this.padding), rect.getRight(this.padding), rect.getTop(this.padding)));
        }
        if (this.parent == null) {
            writer.addAnnotation(field);
        } else {
            this.parent.addKid(field);
        }
    }

    @Override
    public void cellLayout(PdfPCell cell, Rectangle rect, PdfContentByte[] canvases) {
        if (this.cellField == null || this.fieldWriter == null && this.parent == null) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("you.have.used.the.wrong.constructor.for.this.fieldpositioningevents.class"));
        }
        this.cellField.put(PdfName.RECT, new PdfRectangle(rect.getLeft(this.padding), rect.getBottom(this.padding), rect.getRight(this.padding), rect.getTop(this.padding)));
        if (this.parent == null) {
            this.fieldWriter.addAnnotation(this.cellField);
        } else {
            this.parent.addKid(this.cellField);
        }
    }
}

