/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.common.project.facet.core.StandardJreRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeBridge;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;

public final class JavaRuntimeBridge
implements IRuntimeBridge {
    public Set<String> getExportedRuntimeNames() throws CoreException {
        HashSet<String> result = new HashSet<String>();
        IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
        int n = iVMInstallTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstallType vmInstallType = iVMInstallTypeArray[n2];
            IVMInstall[] iVMInstallArray = vmInstallType.getVMInstalls();
            int n3 = iVMInstallArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IVMInstall vmInstall = iVMInstallArray[n4];
                result.add(vmInstall.getName());
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    public IRuntimeBridge.IStub bridge(String name) throws CoreException {
        IVMInstall vmInstall = null;
        IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
        int n = iVMInstallTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstallType vmInstallType = iVMInstallTypeArray[n2];
            vmInstall = vmInstallType.findVMInstallByName(name);
            if (vmInstall != null) break;
            ++n2;
        }
        return new Stub(vmInstall);
    }

    private static class Stub
    extends IRuntimeBridge.Stub {
        private final IVMInstall vmInstall;

        public Stub(IVMInstall vmInstall) {
            this.vmInstall = vmInstall;
        }

        public List<IRuntimeComponent> getRuntimeComponents() {
            IRuntimeComponent rc = StandardJreRuntimeComponent.create(this.vmInstall);
            return Collections.singletonList(rc);
        }

        public Map<String, String> getProperties() {
            return Collections.emptyMap();
        }
    }
}

