/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.designer.internal.ui.command.CommandUtils;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.ContextSelectionAction;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class DeleteColumnAction
extends ContextSelectionAction {
    private static final String ACTION_MSG_DELETE = Messages.getString((String)"DeleteColumnAction.actionMsg.delete");
    public static final String ID = "DeleteGroupAction.DeleteColumnAction";

    public DeleteColumnAction(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
        this.setText(ACTION_MSG_DELETE);
        ISharedImages shareImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(shareImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(shareImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setAccelerator(127);
    }

    @Override
    protected boolean calculateEnabled() {
        return !this.getColumnHandles().isEmpty() && this.canDrop(this.getColumnHandles());
    }

    private boolean canDrop(List columnHandles) {
        Iterator it = columnHandles.iterator();
        while (it.hasNext()) {
            if (this.canDrop((ColumnHandle)it.next())) continue;
            return false;
        }
        return true;
    }

    private boolean canDrop(ColumnHandle handle) {
        return handle.canDrop();
    }

    public void run() {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Delete column action >> Run ...");
        }
        try {
            CommandUtils.executeCommand("org.eclipse.birt.report.designer.ui.command.deleteColumnCommand", null);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

