/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.bidi.utils.ui;

import org.eclipse.birt.report.data.bidi.utils.core.BidiConstants;
import org.eclipse.birt.report.data.bidi.utils.core.BidiFormat;
import org.eclipse.birt.report.data.bidi.utils.i18n.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class BidiGUIUtility {
    private Combo orderingSchemeCombo;
    private Combo textDirectionCombo;
    private Combo symSwapCombo;
    private Combo shapingCombo;
    private Combo numShapingCombo;
    public static final String EXTERNAL_SYSTEM_METADATA_SETTING = "External_system_metadata_setting_area";
    public static final String EXTERNAL_SYSTEM_CONTENT_SETTING = "External_system_content_setting_area";
    public static BidiGUIUtility INSTANCE = new BidiGUIUtility();

    public Group addBiDiFormatFrame(Composite mainComposite, String biDiFormatOption, BidiFormat bidiFormat) {
        Group externalBiDiFormatFrame = new Group(mainComposite, 0);
        externalBiDiFormatFrame.setLayout((Layout)new GridLayout());
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.verticalSpan = 5;
        data.verticalIndent = 5;
        boolean isMetadataSetting = EXTERNAL_SYSTEM_METADATA_SETTING.equalsIgnoreCase(biDiFormatOption);
        if (isMetadataSetting) {
            externalBiDiFormatFrame.setText(Messages.getString((String)"metadata.bidiframe.title"));
        } else {
            externalBiDiFormatFrame.setText(Messages.getString((String)"content.bidiframe.title"));
        }
        externalBiDiFormatFrame.setLayoutData((Object)data);
        externalBiDiFormatFrame.setEnabled(true);
        GridData innerFrameGridData = new GridData(768);
        innerFrameGridData.grabExcessHorizontalSpace = true;
        innerFrameGridData.horizontalSpan = 1;
        innerFrameGridData.horizontalAlignment = 4;
        innerFrameGridData.verticalIndent = 5;
        innerFrameGridData.minimumWidth = -1;
        GridLayout innerFrameLayout = new GridLayout();
        innerFrameLayout.numColumns = 2;
        innerFrameLayout.marginWidth = 5;
        innerFrameLayout.marginHeight = 10;
        GridData arabicGridData = new GridData();
        arabicGridData.grabExcessHorizontalSpace = true;
        arabicGridData.horizontalSpan = 2;
        arabicGridData.horizontalAlignment = 4;
        arabicGridData.verticalIndent = 5;
        GridLayout arabicInnerFrameLayout = new GridLayout();
        arabicInnerFrameLayout.numColumns = 2;
        arabicInnerFrameLayout.marginWidth = 1;
        arabicInnerFrameLayout.marginHeight = 15;
        arabicInnerFrameLayout.horizontalSpacing = 1;
        externalBiDiFormatFrame.setLayout((Layout)innerFrameLayout);
        this.createOrderSchemaField(bidiFormat, externalBiDiFormatFrame, innerFrameGridData, isMetadataSetting);
        this.createTextDirectionField(bidiFormat, externalBiDiFormatFrame, innerFrameGridData, isMetadataSetting);
        this.createSystemSwapSettingField(bidiFormat, externalBiDiFormatFrame, innerFrameGridData, isMetadataSetting);
        this.createContentSettingArea(bidiFormat, externalBiDiFormatFrame, innerFrameGridData, arabicGridData, arabicInnerFrameLayout, isMetadataSetting);
        return externalBiDiFormatFrame;
    }

    private void createSystemSwapSettingField(BidiFormat bidiFormat, Group externalBiDiFormatFrame, GridData innerFrameGridData, boolean isMetadataSetting) {
        Label symSwapLabel = new Label((Composite)externalBiDiFormatFrame, 0);
        symSwapLabel.setText(isMetadataSetting ? BidiConstants.SYMSWAP_TITLE_METADATA : BidiConstants.SYMSWAP_TITLE_CONTENT);
        symSwapLabel.setLayoutData((Object)innerFrameGridData);
        this.symSwapCombo = new Combo((Composite)externalBiDiFormatFrame, 12);
        this.symSwapCombo.setToolTipText(BidiConstants.SYMSWAP_TOOLTIP);
        this.symSwapCombo.add(BidiConstants.SYMSWAP_TRUE, 0);
        this.symSwapCombo.add(BidiConstants.SYMSWAP_FALSE, 1);
        if (bidiFormat.getSymSwap()) {
            this.symSwapCombo.select(0);
        } else {
            this.symSwapCombo.select(1);
        }
        this.symSwapCombo.setLayoutData((Object)innerFrameGridData);
    }

    private void createTextDirectionField(BidiFormat bidiFormat, Group externalBiDiFormatFrame, GridData innerFrameGridData, boolean isMetadataSetting) {
        Label textDirectionLabel = new Label((Composite)externalBiDiFormatFrame, 0);
        textDirectionLabel.setText(isMetadataSetting ? BidiConstants.TEXT_DIRECTION_TITLE_METADATA : BidiConstants.TEXT_DIRECTION_TITLE_CONTENT);
        textDirectionLabel.setLayoutData((Object)innerFrameGridData);
        this.textDirectionCombo = new Combo((Composite)externalBiDiFormatFrame, 12);
        this.textDirectionCombo.setToolTipText(BidiConstants.TEXT_DIRECTION_TOOLTIP);
        this.textDirectionCombo.add(BidiConstants.TEXT_DIRECTION_LTR, 0);
        this.textDirectionCombo.add(BidiConstants.TEXT_DIRECTION_RTL, 1);
        this.textDirectionCombo.add(BidiConstants.TEXT_DIRECTION_CONTEXTLTR, 2);
        this.textDirectionCombo.add(BidiConstants.TEXT_DIRECTION_CONTEXTRTL, 3);
        this.textDirectionCombo.select(BidiGUIUtility.getTextDirectionComboIndx(bidiFormat.getTextDirection()));
        this.textDirectionCombo.setLayoutData((Object)innerFrameGridData);
    }

    private void createOrderSchemaField(BidiFormat bidiFormat, Group externalBiDiFormatFrame, GridData innerFrameGridData, boolean isMetadataSetting) {
        Label orderingSchemeLabel = new Label((Composite)externalBiDiFormatFrame, 0);
        orderingSchemeLabel.setText(isMetadataSetting ? BidiConstants.ORDERING_SCHEME_TITLE_METADATA : BidiConstants.ORDERING_SCHEME_TITLE_CONTENT);
        orderingSchemeLabel.setLayoutData((Object)innerFrameGridData);
        this.orderingSchemeCombo = new Combo((Composite)externalBiDiFormatFrame, 12);
        this.orderingSchemeCombo.setToolTipText(BidiConstants.ORDERING_SCHEME_TOOLTIP);
        this.orderingSchemeCombo.add(BidiConstants.ORDERING_SCHEME_LOGICAL, 0);
        this.orderingSchemeCombo.add(BidiConstants.ORDERING_SCHEME_VISUAL, 1);
        this.orderingSchemeCombo.select(BidiGUIUtility.getOrderingSchemeComboIndx(bidiFormat.getOrderingScheme()));
        this.orderingSchemeCombo.setLayoutData((Object)innerFrameGridData);
    }

    private void createContentSettingArea(BidiFormat bidiFormat, Group externalBiDiFormatFrame, GridData innerFrameGridData, GridData arabicGridData, GridLayout arabicInnerFrameLayout, boolean isMetadataSetting) {
        Group arabicBiDiFormatFrame = new Group((Composite)externalBiDiFormatFrame, 0);
        arabicBiDiFormatFrame.setText(BidiConstants.ARABIC_TITLE);
        arabicBiDiFormatFrame.setLayout((Layout)arabicInnerFrameLayout);
        arabicBiDiFormatFrame.setLayoutData((Object)arabicGridData);
        Label shapingLabel = new Label((Composite)arabicBiDiFormatFrame, 0);
        shapingLabel.setText(isMetadataSetting ? BidiConstants.SHAPING_TITLE_METADATA : BidiConstants.SHAPING_TITLE_CONTENT);
        shapingLabel.setLayoutData((Object)innerFrameGridData);
        this.shapingCombo = new Combo((Composite)arabicBiDiFormatFrame, 12);
        this.shapingCombo.setToolTipText(BidiConstants.SHAPING_TOOLTIP);
        this.shapingCombo.add(BidiConstants.SHAPING_SHAPED, 0);
        this.shapingCombo.add(BidiConstants.SHAPING_NOMINAL, 1);
        this.shapingCombo.select(BidiGUIUtility.getShapingComboIndx(bidiFormat.getTextShaping()));
        this.shapingCombo.setLayoutData((Object)innerFrameGridData);
        Label numShapingLabel = new Label((Composite)arabicBiDiFormatFrame, 0);
        numShapingLabel.setText(isMetadataSetting ? BidiConstants.NUMSHAPING_TITLE_METADATA : BidiConstants.NUMSHAPING_TITLE_CONTENT);
        numShapingLabel.setLayoutData((Object)innerFrameGridData);
        this.numShapingCombo = new Combo((Composite)arabicBiDiFormatFrame, 12);
        this.numShapingCombo.setToolTipText(BidiConstants.NUMSHAPING_TOOLTIP);
        this.numShapingCombo.add(BidiConstants.NUMSHAPING_NOMINAL, 0);
        this.numShapingCombo.add(BidiConstants.NUMSHAPING_NATIONAL, 1);
        this.numShapingCombo.add(BidiConstants.NUMSHAPING_CONTEXT, 2);
        this.numShapingCombo.select(BidiGUIUtility.getNumShapingComboIndx(bidiFormat.getNumeralShaping()));
        this.numShapingCombo.setLayoutData((Object)innerFrameGridData);
        numShapingLabel.setEnabled(this.numShapingCombo.isEnabled());
    }

    public static int getOrderingSchemeComboIndx(String orderingScheme) {
        if (orderingScheme.equals(BidiConstants.ORDERING_SCHEME_LOGICAL)) {
            return 0;
        }
        return 1;
    }

    public static int getTextDirectionComboIndx(String textDirection) {
        if (textDirection.equals(BidiConstants.TEXT_DIRECTION_LTR)) {
            return 0;
        }
        if (textDirection.equals(BidiConstants.TEXT_DIRECTION_RTL)) {
            return 1;
        }
        if (textDirection.equals(BidiConstants.TEXT_DIRECTION_CONTEXTLTR)) {
            return 2;
        }
        return 3;
    }

    public static int getShapingComboIndx(String textShaping) {
        if (textShaping.equals(BidiConstants.SHAPING_NOMINAL)) {
            return 1;
        }
        return 0;
    }

    public static int getNumShapingComboIndx(String numShaping) {
        if (numShaping.equals(BidiConstants.NUMSHAPING_CONTEXT)) {
            return 2;
        }
        if (numShaping.equals(BidiConstants.NUMSHAPING_NATIONAL)) {
            return 1;
        }
        return 0;
    }

    public BidiFormat getBiDiFormat(Group bidiFormatFrame) {
        Group arabicGroup = null;
        Control[] arabicSubControls = null;
        Control[] controls = bidiFormatFrame.getChildren();
        int i = 0;
        while (i < controls.length) {
            if (controls[i] instanceof Combo) {
                if (BidiConstants.ORDERING_SCHEME_TOOLTIP.equals(((Combo)controls[i]).getToolTipText())) {
                    this.orderingSchemeCombo = (Combo)controls[i];
                } else if (BidiConstants.TEXT_DIRECTION_TOOLTIP.equals(((Combo)controls[i]).getToolTipText())) {
                    this.textDirectionCombo = (Combo)controls[i];
                } else if (BidiConstants.SYMSWAP_TOOLTIP.equals(((Combo)controls[i]).getToolTipText())) {
                    this.symSwapCombo = (Combo)controls[i];
                }
            }
            if (controls[i] instanceof Group) {
                arabicGroup = (Group)controls[i];
                arabicSubControls = arabicGroup.getChildren();
                int j = 0;
                while (j < arabicSubControls.length) {
                    if (arabicSubControls[j] instanceof Combo) {
                        if (BidiConstants.SHAPING_TOOLTIP.equals(((Combo)arabicSubControls[j]).getToolTipText())) {
                            this.shapingCombo = (Combo)arabicSubControls[j];
                        } else if (BidiConstants.NUMSHAPING_TOOLTIP.equals(((Combo)arabicSubControls[j]).getToolTipText())) {
                            this.numShapingCombo = (Combo)arabicSubControls[j];
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        String orderingScheme = switch (this.orderingSchemeCombo.getSelectionIndex()) {
            case 0 -> BidiConstants.ORDERING_SCHEME_LOGICAL;
            case 1 -> BidiConstants.ORDERING_SCHEME_VISUAL;
            default -> "";
        };
        String textDirection = switch (this.textDirectionCombo.getSelectionIndex()) {
            case 0 -> BidiConstants.TEXT_DIRECTION_LTR;
            case 1 -> BidiConstants.TEXT_DIRECTION_RTL;
            case 2 -> BidiConstants.TEXT_DIRECTION_CONTEXTLTR;
            case 3 -> BidiConstants.TEXT_DIRECTION_CONTEXTRTL;
            default -> "";
        };
        boolean symSwap = this.symSwapCombo.getSelectionIndex() == 0;
        return new BidiFormat(orderingScheme, textDirection, symSwap, switch (this.shapingCombo.getSelectionIndex()) {
            case 1 -> BidiConstants.SHAPING_NOMINAL;
            case 0 -> BidiConstants.SHAPING_SHAPED;
            default -> "";
        }, switch (this.numShapingCombo.getSelectionIndex()) {
            case 0 -> BidiConstants.NUMSHAPING_NOMINAL;
            case 1 -> BidiConstants.NUMSHAPING_NATIONAL;
            case 2 -> BidiConstants.NUMSHAPING_CONTEXT;
            default -> "";
        });
    }

    public void performDefaults() {
        this.orderingSchemeCombo.select(0);
        this.textDirectionCombo.select(0);
        this.symSwapCombo.select(0);
        this.shapingCombo.select(1);
        this.numShapingCombo.select(0);
    }
}

