/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.ui.impl.contols;

import java.io.File;
import org.eclipse.birt.data.oda.pojo.ui.impl.contols.IMenuButtonHelper;
import org.eclipse.birt.data.oda.pojo.ui.impl.contols.IMenuButtonProvider;
import org.eclipse.birt.data.oda.pojo.ui.impl.contols.MenuButtonHelper;
import org.eclipse.birt.data.oda.pojo.ui.impl.contols.MenuButtonProvider;
import org.eclipse.birt.data.oda.pojo.ui.impl.contols.POJOClassTabFolderPage;
import org.eclipse.birt.data.oda.pojo.ui.impl.models.ClassPathElement;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.MenuButton;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class ClassSelectionButton {
    private MenuButton button;
    private IMenuButtonHelper helper;
    private IMenuButtonProvider provider;
    private Menu menu;
    private POJOClassTabFolderPage folderPage;
    private SelectionAdapter listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Widget widget = e.widget;
            if (widget instanceof MenuItem) {
                String exprType = (String)widget.getData();
                ClassSelectionButton.this.provider.handleSelectionEvent(exprType);
                ClassSelectionButton.this.refresh();
            }
            if (widget instanceof MenuButton) {
                ClassSelectionButton.this.provider.handleSelectionEvent(((MenuButtonProvider)ClassSelectionButton.this.provider).getDefaultOptionType());
            }
        }
    };

    public ClassSelectionButton(Composite parent, int style, IMenuButtonProvider provider) {
        this.button = new MenuButton(parent, style);
        this.button.addSelectionListener((SelectionListener)this.listener);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClassSelectionButton.this.refreshMenuItems();
            }
        });
        this.menu = new Menu((Decorations)parent.getShell(), 8);
        this.button.setDropDownMenu(this.menu);
        this.setMenuButtonProvider(provider);
        this.refresh();
    }

    protected void refreshMenuItems() {
        ((MenuButtonProvider)this.provider).resetProperties();
        this.populateMenuItems();
    }

    public void setContainer(POJOClassTabFolderPage folderPage) {
        this.folderPage = folderPage;
    }

    public void setEnabled(boolean enable) {
        this.button.setEnabled(enable);
    }

    public boolean isEnabled() {
        return this.button.isEnabled();
    }

    public MenuButton getControl() {
        return this.button;
    }

    public IMenuButtonProvider getProvider() {
        return this.provider;
    }

    public void notifyExpressionChangeEvent(String oldExpression, String newExpression) {
        if (this.helper != null) {
            this.helper.notifyExpressionChangeEvent(oldExpression, newExpression);
        }
    }

    public void setMenuButtonHelper(IMenuButtonHelper helper) {
        this.helper = helper;
    }

    public IMenuButtonHelper getMenuButtonHelper() {
        return this.helper;
    }

    public void refresh() {
    }

    public void setMenuButtonProvider(IMenuButtonProvider provider) {
        if (provider != null && provider != this.provider) {
            this.provider = provider;
            provider.setInput(this);
            this.populateMenuItems();
        }
    }

    private void populateMenuItems() {
        int i = 0;
        while (i < this.menu.getItemCount()) {
            this.menu.getItem(i).dispose();
            --i;
            ++i;
        }
        String[] types = this.provider.getMenuItems();
        int i2 = 0;
        while (i2 < types.length) {
            MenuItem item = new MenuItem(this.menu, 8);
            item.setText(this.provider.getMenuItemText(types[i2]));
            item.setData((Object)types[i2]);
            item.setImage(this.provider.getMenuItemImage(types[i2]));
            item.addSelectionListener((SelectionListener)this.listener);
            ++i2;
        }
        if (this.menu.getItemCount() <= 0) {
            this.button.setDropDownMenu(null);
        }
        this.button.setText(this.provider.getButtonText());
        this.refresh();
    }

    public void handleSelection(String[] paths, String rootPath, boolean isRelative) {
        ClassPathElement[] elements = this.createClassPathElements(paths, rootPath, isRelative);
        ((MenuButtonHelper)this.helper).updateTableElementsList();
        this.helper.addClassPathElements(elements, true);
        if (this.folderPage != null) {
            this.folderPage.updateWizardPageStatus();
            this.synchronizeClassPath();
        }
    }

    private void synchronizeClassPath() {
        if (!this.folderPage.getTabFriendClassTabFolderPage().isPageEditable()) {
            this.folderPage.getTabFriendClassTabFolderPage().resetJarElements(this.folderPage.getJarElements());
            this.folderPage.getTabFriendClassTabFolderPage().updateWizardPageStatus();
        }
    }

    private ClassPathElement[] createClassPathElements(String[] paths, String rootPath, boolean isRelative) {
        ClassPathElement[] elements = new ClassPathElement[paths.length];
        int i = 0;
        while (i < paths.length) {
            String fullPath = rootPath == null ? paths[i] : rootPath + File.separator + paths[i];
            elements[i] = new ClassPathElement(new File(paths[i]).getName(), fullPath, isRelative);
            ++i;
        }
        return elements;
    }
}

