/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.axis;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.ComponentPackage;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.util.DefaultValueProvider;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartCheckbox;
import org.eclipse.birt.chart.ui.swt.ChartCombo;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.TextEditorComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetImpl;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class AxisSheetImpl
extends SubtaskSheetImpl {
    private static final int HORIZONTAL_SPACING = 10;
    private boolean enableAxisPercent = false;

    @Override
    public void createControl(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatChartAxis_ID");
        this.enableAxisPercent = ChartUtil.isStudyLayout((Chart)((Chart)this.getChart()));
        int columnNumber = 6;
        if (this.enableAxisPercent) {
            ++columnNumber;
        }
        this.cmpContent = new Composite(parent, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Point p = super.computeSize(wHint, hHint, changed);
                p.y = 200;
                return p;
            }
        };
        GridLayout glContent = new GridLayout(1, false);
        glContent.horizontalSpacing = 10;
        this.cmpContent.setLayout((Layout)glContent);
        GridData gd = new GridData(1808);
        this.cmpContent.setLayoutData((Object)gd);
        ScrolledComposite cmpScroll = new ScrolledComposite(this.cmpContent, 512);
        gd = new GridData(1808);
        cmpScroll.setLayoutData((Object)gd);
        cmpScroll.setMinHeight((ChartUIUtil.getOrthogonalAxisNumber((Chart)((Chart)this.getChart())) + (ChartUIUtil.is3DType((Chart)((Chart)this.getChart())) ? 2 : 1)) * 24 + 80);
        cmpScroll.setExpandVertical(true);
        cmpScroll.setExpandHorizontal(true);
        Composite cmpList = new Composite((Composite)cmpScroll, 0);
        GridLayout glContent2 = new GridLayout(columnNumber, false);
        glContent2.horizontalSpacing = 10;
        cmpList.setLayout((Layout)glContent2);
        cmpScroll.setContent((Control)cmpList);
        Label lblAxis = new Label(cmpList, 64);
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 0x1000000;
        lblAxis.setLayoutData((Object)gd2);
        lblAxis.setFont(JFaceResources.getBannerFont());
        lblAxis.setText(Messages.getString("AxisSheetImpl.Label.Axis"));
        Label lblType = new Label(cmpList, 64);
        GridData gd3 = new GridData();
        gd3.horizontalAlignment = 0x1000000;
        lblType.setLayoutData((Object)gd3);
        lblType.setFont(JFaceResources.getBannerFont());
        lblType.setText(Messages.getString("AxisSheetImpl.Label.Type"));
        Label lblColor = new Label(cmpList, 64);
        GridData gd4 = new GridData();
        gd4.horizontalAlignment = 0x1000000;
        lblColor.setLayoutData((Object)gd4);
        lblColor.setFont(JFaceResources.getBannerFont());
        lblColor.setText(Messages.getString("AxisSheetImpl.Label.Color"));
        Label lblVisible = new Label(cmpList, 0x1000040);
        GridData gd5 = new GridData();
        gd5.horizontalAlignment = 0x1000000;
        lblVisible.setLayoutData((Object)gd5);
        lblVisible.setFont(JFaceResources.getBannerFont());
        lblVisible.setText(Messages.getString("AxisSheetImpl.Label.Visible"));
        Label lblAligned = new Label(cmpList, 0x1000040);
        GridData gd6 = new GridData();
        gd6.horizontalAlignment = 0x1000000;
        lblAligned.setLayoutData((Object)gd6);
        lblAligned.setFont(JFaceResources.getBannerFont());
        lblAligned.setText(Messages.getString("AxisSheetImpl.Label.Aligned"));
        Label lblSideBySide = new Label(cmpList, 0x1000040);
        GridData gd7 = new GridData();
        gd7.horizontalAlignment = 0x1000000;
        lblSideBySide.setLayoutData((Object)gd7);
        lblSideBySide.setFont(JFaceResources.getBannerFont());
        lblSideBySide.setText(Messages.getString("AxisSheetImpl.Label.SideBySide"));
        if (this.enableAxisPercent) {
            Label lblAxisPercent = new Label(cmpList, 0x1000040);
            GridData gd8 = new GridData();
            gd8.horizontalAlignment = 0x1000000;
            lblAxisPercent.setLayoutData((Object)gd8);
            lblAxisPercent.setFont(JFaceResources.getBannerFont());
            lblAxisPercent.setText(Messages.getString("AxisSheetImpl.Label.AxisPercent"));
        }
        int treeIndex = 0;
        new AxisOptionChoser(ChartUIUtil.getAxisXForProcessing((ChartWithAxes)((ChartWithAxes)this.getChart())), Messages.getString("AxisSheetImpl.Label.CategoryX"), 1, treeIndex++, DefaultValueProvider.defChartWithAxes().getBaseAxes()[0]).placeComponents(cmpList);
        int yaxisNumber = ChartUIUtil.getOrthogonalAxisNumber((Chart)((Chart)this.getChart()));
        int i = 0;
        while (i < yaxisNumber) {
            String text = Messages.getString("AxisSheetImpl.Label.ValueY");
            new AxisOptionChoser(ChartUIUtil.getAxisYForProcessing((ChartWithAxes)((ChartWithAxes)this.getChart()), (int)i), (String)(yaxisNumber == 1 ? text : text + " - " + (i + 1)), 2, treeIndex++, (Axis)DefaultValueProvider.defChartWithAxes().getBaseAxes()[0].getAssociatedAxes().get(0)).placeComponents(cmpList);
            ++i;
        }
        if (ChartUIUtil.is3DType((Chart)((Chart)this.getChart()))) {
            new AxisOptionChoser(ChartUIUtil.getAxisZForProcessing((ChartWithAxes)((ChartWithAxes)this.getChart())), Messages.getString("AxisSheetImpl.Label.AncillaryZ"), 3, treeIndex++, (Axis)DefaultValueProvider.defChartWithAxes().getBaseAxes()[0].getAncillaryAxes().get(0)).placeComponents(cmpList);
        }
    }

    protected Series getDesignTimeSeries(Axis axis) {
        return ((SeriesDefinition)axis.getSeriesDefinitions().get(0)).getDesignTimeSeries();
    }

    private class AxisOptionChoser
    implements SelectionListener,
    Listener {
        private Link linkAxis;
        private ChartCombo cmbTypes;
        private ChartCheckbox btnVisible;
        private FillChooserComposite cmbColor;
        private Axis axis;
        private String axisName;
        private int angleType;
        private int treeIndex = 0;
        private ChartCheckbox btnAligned;
        private ChartCheckbox btnSideBySide;
        private TextEditorComposite compAxisPercent;
        private Axis defAxis;

        public AxisOptionChoser(Axis axis, String axisName, int angleType, int treeIndex, Axis defAxis) {
            this.axis = axis;
            this.axisName = axisName;
            this.angleType = angleType;
            this.treeIndex = treeIndex;
            this.defAxis = defAxis;
        }

        public void placeComponents(Composite parent) {
            this.linkAxis = new Link(parent, 0);
            GridData gd = new GridData(768);
            this.linkAxis.setLayoutData((Object)gd);
            this.linkAxis.setText("<a>" + this.axisName + "</a>");
            this.linkAxis.addSelectionListener((SelectionListener)this);
            this.cmbTypes = ((ChartWizardContext)AxisSheetImpl.this.getContext()).getUIFactory().createChartCombo(parent, 12, (EObject)this.axis, "type", this.defAxis.getType().getName());
            gd = new GridData(4, 0x1000000, false, false);
            this.cmbTypes.setLayoutData((Object)gd);
            NameSet ns = ChartUIUtil.getCompatibleAxisType((Series)AxisSheetImpl.this.getDesignTimeSeries(this.axis));
            this.cmbTypes.setItems(ns.getDisplayNames());
            this.cmbTypes.setItemData(ns.getNames());
            this.cmbTypes.setSelection(this.axis.getType().getName());
            this.cmbTypes.addSelectionListener((SelectionListener)this);
            this.cmbTypes.addScreenReaderAccessibility(Messages.getString("AxisSheetImpl.Label.Type"));
            ColorDefinition clrCurrent = null;
            if (this.axis.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getAxis_LineAttributes())) {
                clrCurrent = this.axis.getLineAttributes().getColor();
            }
            this.cmbColor = new FillChooserComposite(parent, 12, (ChartWizardContext)AxisSheetImpl.this.getContext(), (Fill)clrCurrent, false, false, true, true);
            GridData gd2 = new GridData(768);
            this.cmbColor.setLayoutData(gd2);
            this.cmbColor.addListener(this);
            this.cmbColor.addScreenReaderAccessibility(Messages.getString("AxisSheetImpl.Label.Color"));
            this.btnVisible = ((ChartWizardContext)AxisSheetImpl.this.getContext()).getUIFactory().createChartCheckbox(parent, 0, this.defAxis.getLineAttributes().isVisible());
            gd2 = new GridData();
            gd2.horizontalAlignment = 0x1000000;
            this.btnVisible.setLayoutData((Object)gd2);
            this.btnVisible.setSelectionState(this.axis.getLineAttributes().isSetVisible() ? (this.axis.getLineAttributes().isVisible() ? 1 : 2) : 0);
            this.btnVisible.addSelectionListener((SelectionListener)this);
            this.btnVisible.addScreenReaderAccessiblity(Messages.getString("AxisSheetImpl.Label.Visible"));
            this.btnAligned = ((ChartWizardContext)AxisSheetImpl.this.getContext()).getUIFactory().createChartCheckbox(parent, 0, this.defAxis.isAligned());
            gd2 = new GridData();
            gd2.horizontalAlignment = 0x1000000;
            this.btnAligned.setLayoutData((Object)gd2);
            this.btnAligned.setSelectionState(this.axis.isSetAligned() ? (this.axis.isAligned() ? 1 : 2) : 0);
            this.btnAligned.addSelectionListener((SelectionListener)this);
            this.btnAligned.addScreenReaderAccessiblity(Messages.getString("AxisSheetImpl.Label.Aligned"));
            this.updateBtnAlignedStatus();
            this.btnSideBySide = ((ChartWizardContext)AxisSheetImpl.this.getContext()).getUIFactory().createChartCheckbox(parent, 0, this.defAxis.isSideBySide());
            gd2 = new GridData();
            gd2.horizontalAlignment = 0x1000000;
            this.btnSideBySide.setLayoutData((Object)gd2);
            this.btnSideBySide.setSelectionState(this.axis.isSetSideBySide() ? (this.axis.isSideBySide() ? 1 : 2) : 0);
            this.btnSideBySide.addSelectionListener((SelectionListener)this);
            this.btnSideBySide.addScreenReaderAccessiblity(Messages.getString("AxisSheetImpl.Label.SideBySide"));
            this.updateBtnSideBySidStatus();
            if (AxisSheetImpl.this.enableAxisPercent) {
                if (this.angleType == 2) {
                    this.compAxisPercent = new TextEditorComposite(parent, 2048, 1){

                        @Override
                        public void keyPressed(KeyEvent e) {
                            char c = e.character;
                            if (c == '0' && "".equals(AxisOptionChoser.this.compAxisPercent.getText().trim())) {
                                e.doit = false;
                                return;
                            }
                            super.keyPressed(e);
                        }
                    };
                    this.compAxisPercent.setDefaultValue(null);
                    gd2 = new GridData();
                    gd2.horizontalAlignment = 0x1000000;
                    gd2.widthHint = 30;
                    this.compAxisPercent.setLayoutData(gd2);
                    if (this.axis.isSetAxisPercent()) {
                        this.compAxisPercent.setText(String.valueOf(this.axis.getAxisPercent()));
                    }
                    this.compAxisPercent.addListener(this);
                } else {
                    new Label(parent, 0);
                }
            }
        }

        private void updateBtnAlignedStatus() {
            this.btnAligned.setEnabled(this.angleType == 2 && this.axis.isSetType() && this.axis.getType().getValue() == 0);
        }

        private void updateBtnSideBySidStatus() {
            this.btnSideBySide.setEnabled(this.angleType == 2 && AxisSheetImpl.this.getDesignTimeSeries(this.axis) instanceof BarSeries);
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.btnVisible) {
                if (this.btnVisible.getSelectionState() == 0) {
                    this.axis.getLineAttributes().unsetVisible();
                } else {
                    this.axis.getLineAttributes().setVisible(this.btnVisible.getSelectionState() == 1);
                }
            } else if (e.widget.equals(this.cmbTypes)) {
                String axisTypeName = this.cmbTypes.getSelectedItemData();
                boolean isNotificaionIgnored = ChartAdapter.isNotificationIgnored();
                ChartAdapter.ignoreNotifications((boolean)true);
                AxisType axisType = axisTypeName == null ? this.defAxis.getType() : AxisType.getByName((String)axisTypeName);
                this.convertSampleData(axisType);
                ChartAdapter.ignoreNotifications((boolean)isNotificaionIgnored);
                if (axisTypeName != null) {
                    this.axis.setType(axisType);
                }
                this.updateBtnAlignedStatus();
            } else if (e.widget.equals(this.linkAxis)) {
                this.switchTo(this.treeIndex);
            } else if (e.widget == this.btnAligned) {
                if (this.btnAligned.getSelectionState() == 0) {
                    this.axis.unsetAligned();
                } else {
                    this.axis.setAligned(this.btnAligned.getSelectionState() == 1);
                }
            } else if (e.widget == this.btnSideBySide) {
                if (this.btnSideBySide.getSelectionState() == 0) {
                    this.axis.unsetSideBySide();
                } else {
                    this.axis.setSideBySide(this.btnSideBySide.getSelectionState() == 1);
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void handleEvent(Event event) {
            if (((Object)((Object)this.cmbColor)).equals(event.widget)) {
                if (event.type == 1) {
                    this.axis.getLineAttributes().setColor((ColorDefinition)event.data);
                }
            } else if (event.widget == this.compAxisPercent) {
                try {
                    int value = Integer.parseInt(this.compAxisPercent.getText());
                    if (value == 0) {
                        this.compAxisPercent.setText("");
                        this.axis.unsetAxisPercent();
                    } else {
                        this.axis.setAxisPercent(value);
                    }
                }
                catch (NumberFormatException e) {
                    this.compAxisPercent.setText("");
                    this.axis.unsetAxisPercent();
                }
            }
        }

        private void convertSampleData(AxisType axisType) {
            if (this.angleType == 1) {
                if (axisType == null) {
                    axisType = AxisType.TEXT_LITERAL;
                }
                BaseSampleData bsd = (BaseSampleData)((Chart)AxisSheetImpl.this.getChart()).getSampleData().getBaseSampleData().get(0);
                bsd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)axisType, (String)bsd.getDataSetRepresentation(), (int)0));
            } else if (this.angleType == 2) {
                if (axisType == null) {
                    axisType = AxisType.LINEAR_LITERAL;
                }
                int iStartIndex = this.getFirstSeriesDefinitionIndexForAxis();
                int iEndIndex = iStartIndex + this.axis.getSeriesDefinitions().size();
                int iOSDSize = ((Chart)AxisSheetImpl.this.getChart()).getSampleData().getOrthogonalSampleData().size();
                int i = 0;
                while (i < iOSDSize) {
                    OrthogonalSampleData osd = (OrthogonalSampleData)((Chart)AxisSheetImpl.this.getChart()).getSampleData().getOrthogonalSampleData().get(i);
                    if (osd.getSeriesDefinitionIndex() >= iStartIndex && osd.getSeriesDefinitionIndex() <= iEndIndex) {
                        osd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)axisType, (String)osd.getDataSetRepresentation(), (int)i));
                    }
                    ++i;
                }
            }
        }

        private int getFirstSeriesDefinitionIndexForAxis() {
            int iTmp = 0;
            int i = 0;
            while (i < AxisSheetImpl.this.getIndex()) {
                iTmp += ChartUIUtil.getAxisYForProcessing((ChartWithAxes)((ChartWithAxes)AxisSheetImpl.this.getChart()), (int)i).getSeriesDefinitions().size();
                ++i;
            }
            return iTmp;
        }

        private void switchTo(int index) {
            TreeItem currentItem = AxisSheetImpl.this.getParentTask().getNavigatorTree().getSelection()[0];
            TreeItem[] children = currentItem.getItems();
            if (index < children.length) {
                AxisSheetImpl.this.getParentTask().switchToTreeItem(children[index]);
            }
        }
    }
}

