/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.UnrecoverableExceptions;

@API(status=API.Status.INTERNAL, since="1.0")
public final class StringUtils {
    private static final Pattern ISO_CONTROL_PATTERN = StringUtils.compileIsoControlPattern();
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");

    static Pattern compileIsoControlPattern() {
        try {
            return Pattern.compile("\\p{Cntrl}", 256);
        }
        catch (IllegalArgumentException e) {
            return Pattern.compile("\\p{Cntrl}");
        }
    }

    private StringUtils() {
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static boolean containsWhitespace(String str) {
        return str != null && str.codePoints().anyMatch(Character::isWhitespace);
    }

    public static boolean doesNotContainWhitespace(String str) {
        return !StringUtils.containsWhitespace(str);
    }

    public static boolean containsIsoControlCharacter(String str) {
        return str != null && str.codePoints().anyMatch(Character::isISOControl);
    }

    public static boolean doesNotContainIsoControlCharacter(String str) {
        return !StringUtils.containsIsoControlCharacter(str);
    }

    public static String nullSafeToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        try {
            if (obj.getClass().isArray()) {
                if (obj.getClass().getComponentType().isPrimitive()) {
                    if (obj instanceof boolean[]) {
                        return Arrays.toString((boolean[])obj);
                    }
                    if (obj instanceof char[]) {
                        return Arrays.toString((char[])obj);
                    }
                    if (obj instanceof short[]) {
                        return Arrays.toString((short[])obj);
                    }
                    if (obj instanceof byte[]) {
                        return Arrays.toString((byte[])obj);
                    }
                    if (obj instanceof int[]) {
                        return Arrays.toString((int[])obj);
                    }
                    if (obj instanceof long[]) {
                        return Arrays.toString((long[])obj);
                    }
                    if (obj instanceof float[]) {
                        return Arrays.toString((float[])obj);
                    }
                    if (obj instanceof double[]) {
                        return Arrays.toString((double[])obj);
                    }
                }
                return Arrays.deepToString((Object[])obj);
            }
            String result = obj.toString();
            return result != null ? result : "null";
        }
        catch (Throwable throwable) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(throwable);
            return StringUtils.defaultToString(obj);
        }
    }

    public static String defaultToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    public static String replaceIsoControlCharacters(String str, String replacement) {
        Preconditions.notNull(replacement, "replacement must not be null");
        return str == null ? null : ISO_CONTROL_PATTERN.matcher(str).replaceAll(replacement);
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    public static String replaceWhitespaceCharacters(String str, String replacement) {
        Preconditions.notNull(replacement, "replacement must not be null");
        return str == null ? null : WHITESPACE_PATTERN.matcher(str).replaceAll(replacement);
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static TwoPartSplitResult splitIntoTwo(char separator, String value) {
        Preconditions.notNull(value, "value must not be null");
        return StringUtils.splitIntoTwo(value, value.indexOf(separator), 1);
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static TwoPartSplitResult splitIntoTwo(String separator, String value) {
        Preconditions.notNull(separator, "separator must not be null");
        Preconditions.notNull(value, "value must not be null");
        return StringUtils.splitIntoTwo(value, value.indexOf(separator), separator.length());
    }

    private static TwoPartSplitResult splitIntoTwo(String value, int index, int length) {
        if (index == -1) {
            return new OnePart(value);
        }
        return new TwoParts(value.substring(0, index), value.substring(index + length));
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static interface TwoPartSplitResult {
        default public <T> T mapTwo(Supplier<? extends RuntimeException> onePartExceptionCreator, BiFunction<String, String, ? extends T> twoPartsMapper) {
            Function<String, Object> onePartMapper = __ -> {
                throw (RuntimeException)onePartExceptionCreator.get();
            };
            return this.map(onePartMapper, twoPartsMapper);
        }

        public <T> T map(Function<String, ? extends T> var1, BiFunction<String, String, ? extends T> var2);
    }

    private static final class OnePart
    implements TwoPartSplitResult {
        private final String value;

        OnePart(String value) {
            this.value = value;
        }

        @Override
        public <T> T map(Function<String, ? extends T> onePartMapper, BiFunction<String, String, ? extends T> twoPartsMapper) {
            return onePartMapper.apply(this.value);
        }
    }

    private static final class TwoParts
    implements TwoPartSplitResult {
        private final String first;
        private final String second;

        TwoParts(String first, String second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public <T> T map(Function<String, ? extends T> onePartMapper, BiFunction<String, String, ? extends T> twoPartsMapper) {
            return twoPartsMapper.apply(this.first, this.second);
        }
    }
}

