/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionTest;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class QueryTest
extends ConnectionTest {
    private PreparedStatement m_statement;

    PreparedStatement getStatement() {
        return this.m_statement;
    }

    @Before
    public void querySetUp() throws Exception {
        String command = "select * from \"testtable\"";
        this.m_statement = this.getConnection().prepareStatement(command, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
    }

    @After
    public void queryTearDown() throws Exception {
        this.m_statement.close();
    }

    public final void testSortSpecMessages() {
        try {
            new SortSpec(100);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"Invalid sort mode specified: 100.", (Object)ex.getMessage());
        }
    }

    public final void testSetProperty() throws DataException {
        String badPropertyName = "bad_prop_123";
        try {
            this.m_statement.setProperty("bad_prop_123", "propValue");
            Assert.assertTrue((boolean)false);
        }
        catch (DataException ex) {
            Assert.assertTrue((ex.getCause().getMessage().indexOf("bad_prop_123") >= 0 ? 1 : 0) != 0);
        }
    }

    public final void testSetSortSpec() throws DataException {
        try {
            this.m_statement.setSortSpec(null);
            Assert.assertTrue((boolean)false);
        }
        catch (DataException ex) {
            Assert.assertEquals((Object)ex.getErrorCode(), (Object)"odaconsumer.CannotSetSortSpec");
            Assert.assertEquals((Object)"setSortSpec is not supported.", (Object)ex.getCause().getMessage());
        }
    }

    private void doTestSetMaxRows(int max, int expected, boolean setMax) throws DataException {
        if (setMax) {
            this.m_statement.setMaxRows(max);
        }
        Assert.assertTrue((boolean)this.m_statement.execute());
        ResultSet result = this.m_statement.getResultSet();
        Assert.assertNotNull((Object)result);
        int count = 0;
        while (result.fetch() != null) {
            ++count;
        }
        Assert.assertEquals((long)expected, (long)count);
    }

    public final void testSetMaxRows0() throws DataException {
        this.doTestSetMaxRows(0, 5, false);
    }

    public final void testSetMaxRows1() throws DataException {
        this.doTestSetMaxRows(2, 2, true);
    }

    public final void testSetMaxRows2() throws DataException {
        this.doTestSetMaxRows(0, 5, true);
    }

    public final void testSetMaxRows3() throws DataException {
        this.doTestSetMaxRows(10, 5, true);
    }

    public final void testGetRSMetaData() throws DataException {
        IResultClass metadata = this.m_statement.getMetaData();
        Assert.assertNotNull((Object)metadata);
    }

    public final void testGetMetaDataString() throws DataException {
        try {
            this.m_statement.getMetaData("someResultName");
            Assert.assertTrue((boolean)false);
        }
        catch (DataException ex) {
            Assert.assertEquals((Object)ex.getErrorCode(), (Object)"odaconsumer.NamedResultSetsUnsupported");
            Assert.assertTrue((boolean)(ex.getCause() instanceof UnsupportedOperationException));
        }
    }

    public final void testExecute0() throws DataException {
        Assert.assertTrue((boolean)this.m_statement.execute());
    }

    public final void testExecute1() {
        try {
            String command = "select * from \"testtable\" where \"intColumn\" = ?";
            PreparedStatement stmt = this.getConnection().prepareStatement(command, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
            stmt.execute();
            Assert.assertTrue((boolean)false);
        }
        catch (DataException ex) {
            Assert.assertEquals((Object)ex.getErrorCode(), (Object)"odaconsumer.CannotExecuteStatement");
        }
    }

    public final void testExecute2() throws DataException {
        this.m_statement.execute();
        ResultSet result = this.m_statement.getResultSet();
        Assert.assertNotNull((Object)result);
        IResultClass metadata = this.m_statement.getMetaData();
        Assert.assertNotNull((Object)metadata);
        IResultClass metadata1 = result.getMetaData();
        Assert.assertSame((Object)metadata, (Object)metadata1);
        int count = 0;
        while (result.fetch() != null) {
            ++count;
        }
        Assert.assertEquals((long)5L, (long)count);
    }

    public final void testGetResultSet() throws DataException {
        Assert.assertTrue((boolean)this.m_statement.execute());
        ResultSet result = this.m_statement.getResultSet();
        Assert.assertNotNull((Object)result);
    }

    public final void testGetResultSetString() throws DataException {
        try {
            this.m_statement.execute();
            this.m_statement.getResultSet("someResultName");
            Assert.assertTrue((boolean)false);
        }
        catch (DataException ex) {
            Assert.assertEquals((Object)ex.getErrorCode(), (Object)"odaconsumer.NamedResultSetsUnsupported");
            Assert.assertTrue((boolean)(ex.getCause() instanceof UnsupportedOperationException));
        }
    }

    public final void testFindOutParameter() throws DataException {
        try {
            this.m_statement.findOutParameter("someParamName");
            Assert.assertTrue((boolean)false);
        }
        catch (DataException ex) {
            Assert.assertEquals((Object)ex.getErrorCode(), (Object)"odaconsumer.OutputParameterUnsupported");
            Assert.assertTrue((boolean)(ex.getCause() instanceof UnsupportedOperationException));
        }
    }

    public final void testGetParameterTypeInt() {
        try {
            this.m_statement.getParameterType(1);
        }
        catch (DataException ex) {
            Assert.assertEquals((Object)"odaconsumer.CannotGetParameterMetaData", (Object)ex.getErrorCode());
        }
    }

    public final void testGetParameterTypeString() throws DataException {
        boolean hasException = false;
        try {
            this.m_statement.getParameterType("someParamName");
        }
        catch (DataException ex) {
            Assert.assertEquals((Object)ex.getErrorCode(), (Object)"odaconsumer.CannotGetParameterType");
            hasException = true;
        }
        Assert.assertTrue((boolean)hasException);
    }

    public final void testGetParameterValueInt() throws DataException {
        try {
            Assert.assertTrue((boolean)this.m_statement.execute());
            this.m_statement.getParameterValue(1);
            Assert.assertTrue((boolean)false);
        }
        catch (DataException ex) {
            Assert.assertEquals((Object)ex.getErrorCode(), (Object)"odaconsumer.OutputParameterUnsupported");
            Assert.assertTrue((boolean)(ex.getCause() instanceof UnsupportedOperationException));
        }
    }

    public final void testGetParameterValueString() throws DataException {
        try {
            Assert.assertTrue((boolean)this.m_statement.execute());
            this.m_statement.getParameterValue("someParamName");
            Assert.assertTrue((boolean)false);
        }
        catch (DataException ex) {
            Assert.assertEquals((Object)ex.getErrorCode(), (Object)"odaconsumer.OutputParameterUnsupported");
            Assert.assertTrue((boolean)(ex.getCause() instanceof UnsupportedOperationException));
        }
    }

    public final void testQueryClose() throws DataException {
        this.m_statement.close();
    }
}

