
/*******************************************************************************
 * Copyright (c) 2004, 2005 Actuate Corporation.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0/.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/
package org.eclipse.birt.data.engine.olap.data.util;

import java.util.Date;

/**
 *
 */

public class MemberForStressTest implements IComparableStructure {
	public int iField;
	public Date dateField;
	public String stringField;

	MemberForStressTest(int iField, Date dateField, String stringField) {
		this.iField = iField;
		this.dateField = dateField;
		this.stringField = stringField;
	}

	@Override
	public Object[] getFieldValues() {
		Object[] reFields = new Object[3];
		reFields[0] = new Integer(iField);
		reFields[1] = dateField;
		reFields[2] = stringField;
		return reFields;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object o) {
		MemberForStressTest other = (MemberForStressTest) o;
		if ((this.iField != other.iField) || !this.dateField.equals(other.dateField) || !this.stringField.equals(other.stringField)) {
			return false;
		}
		return true;
	}

	static public IStructureCreator getMemberCreator() {
		// TODO Auto-generated method stub
		return new MemberForStressTestCreator();
	}

	@Override
	public int compareTo(Object o) {
		MemberForStressTest other = (MemberForStressTest) o;
		if (this.iField > other.iField) {
			return 1;
		} else if (this.iField == other.iField) {
			return 0;
		} else {
			return -1;
		}
	}

}

class MemberForStressTestCreator implements IStructureCreator {

	@Override
	public IStructure createInstance(Object[] fields) {
		int iField = ((Integer) (fields[0])).intValue();
		Date dateField = (Date) fields[1];
		String stringField = (String) fields[2];
		return new MemberForStressTest(iField, dateField, stringField);
	}
}
