/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.ui.internal.search;

import java.text.Collator;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.DelegatingDragAdapter;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.common.ui.internal.UIPlugin;
import org.eclipse.wst.common.ui.internal.search.SearchMessages;
import org.eclipse.wst.common.ui.internal.search.SearchResultTableContentProvider;
import org.eclipse.wst.common.ui.internal.search.SearchResultTreeContentProvider;
import org.eclipse.wst.common.ui.internal.search.basecode.FileLabelProvider;
import org.eclipse.wst.common.ui.internal.search.basecode.IFileSearchContentProvider;
import org.eclipse.wst.common.ui.internal.search.basecode.ResourceTransferDragAdapter;
import org.eclipse.wst.common.ui.internal.search.basecode.SortAction;

public class SearchResultPage
extends AbstractTextSearchViewPage
implements IAdaptable {
    private static final String KEY_SORTING = "org.eclipse.search.resultpage.sorting";
    private ActionGroup fActionGroup;
    private IFileSearchContentProvider fContentProvider;
    private int fCurrentSortOrder;
    private SortAction fSortByNameAction;
    private SortAction fSortByPathAction;
    private static final String[] SHOW_IN_TARGETS = new String[]{"org.eclipse.ui.navigator.ProjectExplorer"};
    private static final IShowInTargetList SHOW_IN_TARGET_LIST = new IShowInTargetList(){

        public String[] getShowInTargetIds() {
            return SHOW_IN_TARGETS;
        }
    };

    public StructuredViewer getViewer() {
        return super.getViewer();
    }

    private void addDragAdapters(StructuredViewer viewer) {
        Transfer[] transfers = new Transfer[]{ResourceTransfer.getInstance()};
        int ops = 5;
        DelegatingDragAdapter adapter = new DelegatingDragAdapter();
        adapter.addDragSourceListener((TransferDragSourceListener)new ResourceTransferDragAdapter((ISelectionProvider)viewer));
        viewer.addDragSupport(ops, transfers, (DragSourceListener)adapter);
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setUseHashlookup(true);
        FileLabelProvider innerLabelProvider = new FileLabelProvider(this, this.fCurrentSortOrder);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)innerLabelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        viewer.setContentProvider((IContentProvider)new SearchResultTableContentProvider(this));
        viewer.setSorter((ViewerSorter)new DecoratorIgnoringViewerSorter((ILabelProvider)innerLabelProvider));
        this.fContentProvider = (IFileSearchContentProvider)viewer.getContentProvider();
        this.addDragAdapters((StructuredViewer)viewer);
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        FileLabelProvider innerLabelProvider = new FileLabelProvider(this, 1);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)innerLabelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        viewer.setContentProvider((IContentProvider)new SearchResultTreeContentProvider((AbstractTreeViewer)viewer));
        viewer.setSorter((ViewerSorter)new DecoratorIgnoringViewerSorter((ILabelProvider)innerLabelProvider));
        this.fContentProvider = (IFileSearchContentProvider)viewer.getContentProvider();
        this.addDragAdapters((StructuredViewer)viewer);
    }

    protected void showMatch(Match match, int offset, int length, boolean activate) throws PartInitException {
        IFile file = (IFile)match.getElement();
        IWorkbenchPage wbPage = UIPlugin.getActivePage();
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)wbPage, (IFile)((IFile)match.getElement()), (boolean)activate);
        if (offset != 0 && length != 0) {
            if (editor instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)editor;
                textEditor.selectAndReveal(offset, length);
            } else if (editor != null) {
                this.showWithMarker(editor, file, offset, length);
            }
        }
    }

    private void showWithMarker(IEditorPart editor, IFile file, int offset, int length) throws PartInitException {
        IMarker marker = null;
        try {
            try {
                marker = file.createMarker("org.eclipse.search.searchmarker");
                HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
                attributes.put("charStart", new Integer(offset));
                attributes.put("charEnd", new Integer(offset + length));
                marker.setAttributes(attributes);
                IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
            }
            catch (CoreException e) {
                throw new PartInitException(SearchMessages.FileSearchPage_error_marker, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (marker != null) {
                try {
                    marker.delete();
                }
                catch (CoreException coreException) {}
            }
            throw throwable;
        }
        if (marker != null) {
            try {
                marker.delete();
            }
            catch (CoreException coreException) {}
        }
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        this.addSortActions(mgr);
        this.fActionGroup.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
        this.fActionGroup.fillContextMenu(mgr);
    }

    private void addSortActions(IMenuManager mgr) {
        if (this.getLayout() != 1) {
            return;
        }
        MenuManager sortMenu = new MenuManager(SearchMessages.FileSearchPage_sort_by_label);
        sortMenu.add((IAction)this.fSortByNameAction);
        sortMenu.add((IAction)this.fSortByPathAction);
        this.fSortByNameAction.setChecked(this.fCurrentSortOrder == this.fSortByNameAction.getSortOrder());
        this.fSortByPathAction.setChecked(this.fCurrentSortOrder == this.fSortByPathAction.getSortOrder());
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)sortMenu);
    }

    public void setViewPart(ISearchResultViewPart part) {
        super.setViewPart(part);
        this.fActionGroup = new NewTextSearchActionGroup((IViewPart)part);
    }

    public void dispose() {
        this.fActionGroup.dispose();
        super.dispose();
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    public void setSortOrder(int sortOrder) {
        this.fCurrentSortOrder = sortOrder;
        DecoratingLabelProvider lpWrapper = (DecoratingLabelProvider)this.getViewer().getLabelProvider();
        ((FileLabelProvider)lpWrapper.getLabelProvider()).setOrder(sortOrder);
        this.getViewer().refresh();
        this.getSettings().put(KEY_SORTING, this.fCurrentSortOrder);
    }

    public void restoreState(IMemento memento) {
        Integer value;
        super.restoreState(memento);
        try {
            this.fCurrentSortOrder = this.getSettings().getInt(KEY_SORTING);
        }
        catch (NumberFormatException numberFormatException) {}
        if (memento != null && (value = memento.getInteger(KEY_SORTING)) != null) {
            this.fCurrentSortOrder = value;
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putInteger(KEY_SORTING, this.fCurrentSortOrder);
    }

    public Object getAdapter(Class adapter) {
        if (IShowInTargetList.class.equals((Object)adapter)) {
            return SHOW_IN_TARGET_LIST;
        }
        return null;
    }

    public String getLabel() {
        String label = super.getLabel();
        StructuredViewer viewer = this.getViewer();
        if (viewer instanceof TableViewer) {
            int fileCount;
            int itemCount;
            TableViewer tv = (TableViewer)viewer;
            AbstractTextSearchResult result = this.getInput();
            if (result != null && (itemCount = ((IStructuredContentProvider)tv.getContentProvider()).getElements((Object)this.getInput()).length) < (fileCount = this.getInput().getElements().length)) {
                String format = SearchMessages.FileSearchPage_limited_format;
                return MessageFormat.format(format, label, new Integer(itemCount), new Integer(fileCount));
            }
        }
        return label;
    }

    public static class DecoratorIgnoringViewerSorter
    extends ViewerSorter {
        private final ILabelProvider fLabelProvider;

        public DecoratorIgnoringViewerSorter(ILabelProvider labelProvider) {
            super(null);
            this.fLabelProvider = labelProvider;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            String name1 = this.fLabelProvider.getText(e1);
            String name2 = this.fLabelProvider.getText(e2);
            if (name1 == null) {
                name1 = "";
            }
            if (name2 == null) {
                name2 = "";
            }
            return this.getCollator().compare(name1, name2);
        }

        public final Collator getCollator() {
            if (this.collator == null) {
                this.collator = Collator.getInstance();
            }
            return this.collator;
        }
    }

    class NewTextSearchActionGroup
    extends ActionGroup {
        private ISelectionProvider fSelectionProvider;
        private IWorkbenchPage fPage;
        private OpenFileAction fOpenAction;
        private PropertyDialogAction fOpenPropertiesDialog;

        public NewTextSearchActionGroup(IViewPart part) {
            Assert.isNotNull((Object)part);
            IWorkbenchPartSite site = part.getSite();
            this.fSelectionProvider = site.getSelectionProvider();
            this.fPage = site.getPage();
            this.fOpenPropertiesDialog = new PropertyDialogAction((IShellProvider)site, this.fSelectionProvider);
            this.fOpenAction = new OpenFileAction(this.fPage);
            ISelection selection = this.fSelectionProvider.getSelection();
            if (selection instanceof IStructuredSelection) {
                this.fOpenPropertiesDialog.selectionChanged((IStructuredSelection)selection);
            } else {
                this.fOpenPropertiesDialog.selectionChanged(selection);
            }
        }

        public void fillContextMenu(IMenuManager menu) {
            ISelection selection = this.getContext().getSelection();
            if (selection instanceof IStructuredSelection) {
                this.addOpenWithMenu(menu, (IStructuredSelection)selection);
                if (this.fOpenPropertiesDialog != null && this.fOpenPropertiesDialog.isEnabled() && selection != null && this.fOpenPropertiesDialog.isApplicableForSelection((IStructuredSelection)selection)) {
                    menu.appendToGroup("group.properties", (IAction)this.fOpenPropertiesDialog);
                }
            }
        }

        private void addOpenWithMenu(IMenuManager menu, IStructuredSelection selection) {
            if (selection == null || selection.size() != 1) {
                return;
            }
            Object o = selection.getFirstElement();
            if (!(o instanceof IAdaptable)) {
                return;
            }
            this.fOpenAction.selectionChanged(selection);
            menu.appendToGroup("group.open", (IAction)this.fOpenAction);
            MenuManager submenu = new MenuManager(SearchMessages.OpenWithMenu_label);
            submenu.add((IContributionItem)new OpenWithMenu(this.fPage, (IAdaptable)o));
            menu.appendToGroup("group.open", (IContributionItem)submenu);
        }

        public void fillActionBars(IActionBars actionBar) {
            super.fillActionBars(actionBar);
            this.setGlobalActionHandlers(actionBar);
        }

        private void setGlobalActionHandlers(IActionBars actionBars) {
            actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.fOpenPropertiesDialog);
        }
    }
}

