/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.io.StorageFile;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

final class InputStreamContainer
extends FileContainer {
    private StorageFile containerPath;

    InputStreamContainer(BaseDataFileFactory factory) {
        super(factory);
        this.canUpdate = false;
    }

    @Override
    final boolean openContainer(ContainerKey newIdentity) throws StandardException {
        FilterInputStream dis = null;
        try {
            InputStream is = null;
            this.containerPath = this.dataFactory.getContainerPath(newIdentity, false);
            try {
                is = this.containerPath.getInputStream();
            }
            catch (IOException ioe) {
                this.containerPath = this.dataFactory.getContainerPath(newIdentity, true);
                try {
                    is = this.getInputStream();
                }
                catch (IOException ioe2) {
                    this.containerPath = null;
                    boolean bl = false;
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
            }
            dis = new DataInputStream(is);
            this.readHeader(this.getEmbryonicPage((DataInput)((Object)dis)));
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSDG3.D", ioe, this.getIdentity().toString(), "open", newIdentity.toString());
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    void closeContainer() {
        this.containerPath = null;
    }

    @Override
    public final void clean(boolean forRemove) throws StandardException {
    }

    @Override
    protected final int preAllocate(long lastPreallocPagenum, int preAllocSize) {
        return 0;
    }

    @Override
    protected void truncatePages(long lastValidPagenum) {
    }

    @Override
    void createContainer(ContainerKey newIdentity) throws StandardException {
    }

    @Override
    protected final void removeContainer(LogInstant instant, boolean leaveStub) throws StandardException {
    }

    @Override
    protected final void readPage(long pageNumber, byte[] pageData) throws IOException, StandardException {
        SanityManager.ASSERT(!this.getCommittedDropState());
        long pageOffset = pageNumber * (long)this.pageSize;
        this.readPositionedPage(pageOffset, pageData);
        if (this.dataFactory.databaseEncrypted() && pageNumber != 0L) {
            this.decryptPage(pageData, this.pageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPositionedPage(long pageOffset, byte[] pageData) throws IOException {
        InputStream is = null;
        try {
            is = this.getInputStream();
            InputStreamUtil.skipFully(is, pageOffset);
            InputStreamUtil.readFully(is, pageData, 0, this.pageSize);
            is.close();
            is = null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected final void writePage(long pageNumber, byte[] pageData, boolean syncPage) throws IOException, StandardException {
    }

    @Override
    protected final void flushAll() {
    }

    protected InputStream getInputStream() throws IOException {
        return this.containerPath.getInputStream();
    }

    @Override
    protected void backupContainer(BaseContainerHandle handle, String backupLocation) throws StandardException {
        throw StandardException.newException("XSAI3.S", new Object[0]);
    }

    @Override
    protected void encryptOrDecryptContainer(BaseContainerHandle handle, String newFilePath, boolean doEncrypt) throws StandardException {
        throw StandardException.newException("XSAI3.S", new Object[0]);
    }
}

