/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.shared.common.sanity;

import java.io.PrintWriter;
import java.util.Hashtable;
import org.apache.derby.shared.common.sanity.AssertFailure;

public class SanityManager {
    public static final boolean ASSERT = true;
    public static final boolean DEBUG = true;
    public static final String DEBUGDEBUG = "DumpSanityDebug";
    private static PrintWriter debugStream = new PrintWriter(System.err);
    private static Hashtable<String, Boolean> DebugFlags = new Hashtable();
    private static boolean AllDebugOn = false;
    private static boolean AllDebugOff = false;

    public static final void ASSERT(boolean mustBeTrue) {
        if (!mustBeTrue) {
            AssertFailure af = new AssertFailure("ASSERT FAILED");
            if (SanityManager.DEBUG_ON("AssertFailureTrace")) {
                SanityManager.showTrace(af);
            }
            throw af;
        }
    }

    public static final void ASSERT(boolean mustBeTrue, String msgIfFail) {
        if (!mustBeTrue) {
            AssertFailure af = new AssertFailure("ASSERT FAILED " + msgIfFail);
            if (SanityManager.DEBUG_ON("AssertFailureTrace")) {
                SanityManager.showTrace(af);
            }
            throw af;
        }
    }

    public static final void THROWASSERT(String msgIfFail) {
        SanityManager.THROWASSERT(msgIfFail, null);
    }

    public static final void THROWASSERT(String msg, Throwable t) {
        AssertFailure af = new AssertFailure("ASSERT FAILED " + msg, t);
        if (SanityManager.DEBUG_ON("AssertFailureTrace")) {
            SanityManager.showTrace(af);
        }
        if (t != null) {
            SanityManager.showTrace(t);
        }
        throw af;
    }

    public static final void THROWASSERT(Throwable t) {
        SanityManager.THROWASSERT(t.toString(), t);
    }

    public static final void DEBUG(String flag, String message) {
        if (SanityManager.DEBUG_ON(flag)) {
            SanityManager.DEBUG_PRINT(flag, message);
        }
    }

    public static final boolean DEBUG_ON(String flag) {
        if (AllDebugOn) {
            return true;
        }
        if (AllDebugOff) {
            return false;
        }
        Boolean flagValue = DebugFlags.get(flag);
        if (!DEBUGDEBUG.equals(flag) && SanityManager.DEBUG_ON(DEBUGDEBUG)) {
            SanityManager.DEBUG_PRINT(DEBUGDEBUG, "DEBUG_ON: Debug flag " + flag + " = " + flagValue);
        }
        if (flagValue == null) {
            return false;
        }
        return flagValue;
    }

    public static final void DEBUG_SET(String flag) {
        if (!DEBUGDEBUG.equals(flag) && SanityManager.DEBUG_ON(DEBUGDEBUG)) {
            SanityManager.DEBUG_PRINT(DEBUGDEBUG, "DEBUG_SET: Debug flag " + flag);
        }
        DebugFlags.put(flag, Boolean.TRUE);
    }

    public static final void DEBUG_CLEAR(String flag) {
        if (!DEBUGDEBUG.equals(flag) && SanityManager.DEBUG_ON(DEBUGDEBUG)) {
            SanityManager.DEBUG_PRINT(DEBUGDEBUG, "DEBUG_CLEAR: Debug flag " + flag);
        }
        DebugFlags.put(flag, Boolean.FALSE);
    }

    public static final void DEBUG_ALL_ON() {
        AllDebugOn = true;
        AllDebugOff = false;
    }

    public static final void DEBUG_ALL_OFF() {
        AllDebugOff = true;
        AllDebugOn = false;
    }

    public static void SET_DEBUG_STREAM(PrintWriter pw) {
        debugStream = pw;
    }

    public static PrintWriter GET_DEBUG_STREAM() {
        return debugStream;
    }

    private static void showTrace(AssertFailure af) {
        af.printStackTrace();
        PrintWriter assertStream = SanityManager.GET_DEBUG_STREAM();
        assertStream.println("Assertion trace:");
        af.printStackTrace(assertStream);
        assertStream.flush();
    }

    public static void showTrace(Throwable t) {
        PrintWriter assertStream = SanityManager.GET_DEBUG_STREAM();
        assertStream.println("Exception trace: ");
        t.printStackTrace(assertStream);
    }

    public static void DEBUG_PRINT(String flag, String message) {
        PrintWriter debugStream = SanityManager.GET_DEBUG_STREAM();
        debugStream.println("DEBUG " + flag + " OUTPUT: " + message);
        debugStream.flush();
    }

    public static void NOTREACHED() {
        SanityManager.THROWASSERT("code should not be reached");
    }
}

