/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import com.ibm.icu.util.StringTokenizer;
import java.util.Arrays;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.ColorSelector;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ColorBuilder
extends Composite {
    protected CCombo combo;
    protected ColorSelector colorSelector;
    private IChoiceSet choiceSet;
    private RGB oldRgb;
    private String predefinedColor;
    private static final String NONE_CHOICE = Messages.getString((String)"ColorBuilder.text.Auto");

    public ColorBuilder(Composite parent, int style) {
        super(parent, style);
        this.initColorBuilder(parent, style, false);
    }

    public ColorBuilder(Composite parent, int style, boolean isFormStyle) {
        super(parent, style);
        this.initColorBuilder(parent, style, isFormStyle);
    }

    private void initColorBuilder(Composite parent, int style, boolean isFormStyle) {
        this.setLayout((Layout)WidgetUtil.createSpaceGridLayout((int)2, (int)1));
        if (isFormStyle) {
            ((GridLayout)this.getLayout()).horizontalSpacing = 3;
        }
        this.colorSelector = new ColorSelector((Composite)this);
        GridData data = new GridData();
        data.horizontalAlignment = 32;
        this.colorSelector.getButton().setLayoutData((Object)data);
        this.colorSelector.getButton().setToolTipText(Messages.getString((String)"ColorBuilder.Button.ChooseColor"));
        this.colorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ColorBuilder.this.predefinedColor = null;
                ColorBuilder.this.processAction(ColorBuilder.this.colorSelector.getColorValue());
            }
        });
        if (isFormStyle) {
            this.combo = FormWidgetFactory.getInstance().createCCombo((Composite)this, false);
        } else {
            this.combo = new CCombo((Composite)this, 4);
            this.combo.setVisibleItemCount(30);
        }
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.combo.setLayoutData((Object)data);
        this.combo.add(NONE_CHOICE);
        this.combo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ColorBuilder.this.handleComboFocusGainedEvent(e);
            }

            public void focusLost(FocusEvent e) {
                ColorBuilder.this.handleComboFocusLostEvent(e);
            }
        });
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColorBuilder.this.handleComboSelectedEvent(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ColorBuilder.this.handleComboDefaultSelectedEvent(e);
            }
        });
        this.initAccessible();
    }

    protected void handleComboFocusLostEvent(FocusEvent e) {
        this.combo.notifyListeners(14, null);
    }

    protected void handleComboFocusGainedEvent(FocusEvent e) {
    }

    Label getAssociatedLabel() {
        Control[] siblings = this.getParent().getChildren();
        int i = 0;
        while (i < siblings.length) {
            if (siblings[i] == this && i > 0 && siblings[i - 1] instanceof Label) {
                return (Label)siblings[i - 1];
            }
            ++i;
        }
        return null;
    }

    String stripMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return string;
            }
            if (string.charAt(index) != '&') {
                return string.substring(0, index - 1) + string.substring(index, length);
            }
            if (++index >= length) break;
        }
        return string;
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return Character.toLowerCase(string.charAt(index));
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    void initAccessible() {
        AccessibleAdapter accessibleAdapter = new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String name = null;
                Label label = ColorBuilder.this.getAssociatedLabel();
                if (label != null) {
                    name = ColorBuilder.this.stripMnemonic(label.getText());
                }
                e.result = name;
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                char mnemonic;
                String text;
                String shortcut = null;
                Label label = ColorBuilder.this.getAssociatedLabel();
                if (label != null && (text = label.getText()) != null && (mnemonic = ColorBuilder.this._findMnemonic(text)) != '\u0000') {
                    shortcut = "Alt+" + mnemonic;
                }
                e.result = shortcut;
            }

            public void getHelp(AccessibleEvent e) {
                e.result = ColorBuilder.this.getToolTipText();
            }
        };
        this.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.combo.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String name = null;
                Label label = ColorBuilder.this.getAssociatedLabel();
                if (label != null) {
                    name = ColorBuilder.this.stripMnemonic(label.getText());
                }
                e.result = name;
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                e.result = "Alt+Down Arrow";
            }

            public void getHelp(AccessibleEvent e) {
                e.result = ColorBuilder.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = ColorBuilder.this.toControl(e.x, e.y);
                if (ColorBuilder.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = ColorBuilder.this.getBounds();
                Point pt = ColorBuilder.this.toDisplay(location.x, location.y);
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = ColorBuilder.this.combo.getText();
            }
        });
        this.combo.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = ColorBuilder.this.combo.getText();
            }
        });
    }

    public void setChoiceSet(IChoiceSet choiceSet) {
        this.choiceSet = choiceSet;
        Object[] colors = ChoiceSetFactory.getDisplayNamefromChoiceSet((IChoiceSet)choiceSet);
        Arrays.sort(colors);
        this.combo.removeAll();
        this.combo.add(NONE_CHOICE);
        if (colors != null) {
            int i = 0;
            while (i < colors.length) {
                this.combo.add((String)colors[i]);
                ++i;
            }
        }
    }

    protected RGB parseString(String string) {
        int[] colors = ColorUtil.getRGBs((String)string);
        if (colors != null) {
            return new RGB(colors[0], colors[1], colors[2]);
        }
        StringTokenizer st = new StringTokenizer(string, " ,()");
        if (!st.hasMoreTokens()) {
            return null;
        }
        int[] rgb = new int[3];
        int index = 0;
        while (st.hasMoreTokens()) {
            block6: {
                try {
                    rgb[index] = Integer.decode(st.nextToken());
                    if (rgb[index] >= 0 && rgb[index] <= 255) break block6;
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }
            ++index;
        }
        return new RGB(rgb[0], rgb[1], rgb[2]);
    }

    protected void processAction(RGB rgb) {
        String newComboText = this.predefinedColor;
        if (newComboText == null) {
            newComboText = this.formatRGB(rgb);
        }
        if (!this.combo.getText().equals(newComboText)) {
            this.combo.setText(newComboText);
        }
        if (this.oldRgb == null && rgb == null || rgb != null && rgb.equals((Object)this.oldRgb)) {
            this.notifyListeners(24, null);
            return;
        }
        this.oldRgb = rgb;
        if (rgb == null || !rgb.equals((Object)this.colorSelector.getColorValue())) {
            this.colorSelector.setColorValue(rgb);
        }
        this.notifyListeners(24, null);
    }

    public void setEnabled(boolean enabled) {
        this.combo.setEnabled(enabled);
        this.colorSelector.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public RGB getRGB() {
        return this.oldRgb;
    }

    public void setColorValue(String value) {
        int[] rgbValues;
        IChoice choice;
        this.predefinedColor = null;
        if (this.choiceSet != null && (choice = this.choiceSet.findChoice(value)) != null) {
            this.predefinedColor = choice.getDisplayName();
        }
        if ((rgbValues = ColorUtil.getRGBs((String)value)) == null) {
            this.setRGB(null);
        } else {
            this.setRGB(new RGB(rgbValues[0], rgbValues[1], rgbValues[2]));
        }
    }

    public void setRGB(RGB rgb) {
        this.oldRgb = rgb;
        if (this.combo.isDisposed()) {
            return;
        }
        this.colorSelector.setColorValue(rgb);
        String newComboText = this.predefinedColor;
        if (this.predefinedColor == null) {
            newComboText = rgb == null ? NONE_CHOICE : this.formatRGB(rgb);
        }
        if (!this.combo.getText().equals(newComboText)) {
            this.combo.setText(newComboText);
        }
    }

    private String formatRGB(RGB rgb) {
        if (rgb == null) {
            return NONE_CHOICE;
        }
        String value = ColorUtil.getPredefinedColor((int)DEUtil.getRGBInt((RGB)rgb));
        if (value != null && this.combo != null) {
            String[] items = this.combo.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].equalsIgnoreCase(value)) {
                    return items[i];
                }
                ++i;
            }
        }
        return ColorUtil.format((int)ColorUtil.formRGB((int)rgb.red, (int)rgb.green, (int)rgb.blue), (int)1);
    }

    public String getPredefinedColor() {
        return this.predefinedColor;
    }

    protected void handleComboSelectedEvent(SelectionEvent e) {
        this.predefinedColor = this.combo.getText();
        if (NONE_CHOICE.equals(this.predefinedColor)) {
            this.predefinedColor = null;
            this.processAction(null);
            return;
        }
        String colorName = this.predefinedColor;
        if (this.choiceSet != null && this.choiceSet.findChoiceByDisplayName(colorName) != null) {
            colorName = this.choiceSet.findChoiceByDisplayName(colorName).getName();
        }
        int[] intRgb = ColorUtil.getRGBs((String)colorName);
        RGB rgb = null;
        if (intRgb != null) {
            rgb = new RGB(intRgb[0], intRgb[1], intRgb[2]);
        }
        this.processAction(rgb);
    }

    protected void handleComboDefaultSelectedEvent(SelectionEvent e) {
        this.predefinedColor = null;
        String string = this.combo.getText();
        int index = -1;
        String[] items = this.combo.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].equalsIgnoreCase(string)) {
                index = i;
                this.combo.setText(items[i]);
                break;
            }
            ++i;
        }
        if (index != -1) {
            this.handleComboSelectedEvent(null);
            return;
        }
        RGB rgb = this.parseString(string);
        if (rgb == null) {
            this.combo.deselectAll();
            if (StringUtil.isBlank((String)string)) {
                this.setRGB(null);
            } else {
                this.setRGB(this.getRGB());
            }
            this.notifyListeners(24, null);
        } else {
            this.processAction(rgb);
        }
    }
}

