/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.support;

import java.net.URI;
import java.util.Objects;
import org.junit.platform.commons.support.Resource;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;

class DefaultResource
implements Resource {
    private final String name;
    private final URI uri;

    DefaultResource(String name, URI uri) {
        this.name = Preconditions.notNull(name, "name must not be null");
        this.uri = Preconditions.notNull(uri, "uri must not be null");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof org.junit.platform.commons.io.Resource) {
            org.junit.platform.commons.io.Resource that = (org.junit.platform.commons.io.Resource)obj;
            return this.name.equals(that.getName()) && this.uri.equals(that.getUri());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.uri);
    }

    public String toString() {
        return new ToStringBuilder(this).append("name", this.name).append("uri", this.uri).toString();
    }
}

