/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.xml;

import org.eclipse.birt.report.designer.internal.ui.editors.xml.ColorManager;
import org.eclipse.birt.report.designer.internal.ui.editors.xml.XMLConfiguration;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.designer.ui.editors.schematic.action.TextSaveAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.StatusTextEditor;

public abstract class XMLEditor
extends StatusTextEditor {
    protected SourceViewerDecorationSupport fSourceViewerDecorationSupport;
    protected IOverviewRuler fOverviewRuler;
    protected IAnnotationAccess fAnnotationAccess;
    private ColorManager colorManager = new ColorManager();

    public XMLEditor() {
        this.setSourceViewerConfiguration(new XMLConfiguration(this.colorManager));
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
    }

    protected void createActions() {
        super.createActions();
        this.setAction(ITextEditorActionConstants.SAVE, (IAction)new TextSaveAction((ITextEditor)this));
    }

    public void dispose() {
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.dispose();
            this.fSourceViewerDecorationSupport = null;
        }
        this.fAnnotationAccess = null;
        this.colorManager.dispose();
        super.dispose();
        ((MultiPageEditorSite)this.getSite()).dispose();
    }

    public void refreshDocument() {
        this.setInput(this.getEditorInput());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        IReportProvider provider = this.getProvider();
        if (provider != null) {
            this.setDocumentProvider(provider.getReportDocumentProvider((Object)input));
        }
        super.init(site, input);
    }

    protected abstract IReportProvider getProvider();

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ISourceViewer viewer = super.createSourceViewer(parent, ruler, styles);
        return viewer;
    }

    public void setHighlightRange(int offset, int length, boolean moveCursor) {
        ISourceViewer fSourceViewer = this.getSourceViewer();
        if (fSourceViewer == null) {
            return;
        }
        if (this.showsHighlightRangeOnly()) {
            if (moveCursor) {
                fSourceViewer.setVisibleRegion(offset, length);
            }
        } else {
            fSourceViewer.setRangeIndication(offset, length, moveCursor);
        }
    }
}

