/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;

public class SubqueryDefinitionCopyUtil {
    public static SubqueryDefinition createSubqueryDefinition(String name, ISubqueryDefinition srcSubQueryDefn) throws DataException {
        SubqueryDefinition destSubQueryDefn = new SubqueryDefinition(name, srcSubQueryDefn.getParentQuery());
        destSubQueryDefn.setApplyOnGroupFlag(srcSubQueryDefn.applyOnGroup());
        destSubQueryDefn.setMaxRows(srcSubQueryDefn.getMaxRows());
        destSubQueryDefn.setUsesDetails(srcSubQueryDefn.usesDetails());
        SubqueryDefinitionCopyUtil.copyGroupList(srcSubQueryDefn, destSubQueryDefn);
        SubqueryDefinitionCopyUtil.copyExpressions(srcSubQueryDefn, destSubQueryDefn);
        SubqueryDefinitionCopyUtil.copySubQueryList(srcSubQueryDefn, destSubQueryDefn);
        SubqueryDefinitionCopyUtil.copySortList(srcSubQueryDefn, destSubQueryDefn);
        SubqueryDefinitionCopyUtil.copyFilterList(srcSubQueryDefn, destSubQueryDefn);
        return destSubQueryDefn;
    }

    private static void copyExpressions(ISubqueryDefinition srcSubQueryDefn, SubqueryDefinition destSubQueryDefn) throws DataException {
        Map bindings = srcSubQueryDefn.getBindings();
        for (Map.Entry o : bindings.entrySet()) {
            destSubQueryDefn.addBinding(SubqueryDefinitionCopyUtil.convertToBindings(o.getValue()));
        }
    }

    private static IBinding convertToBindings(Object binding) {
        if (binding instanceof IBinding) {
            return (IBinding)binding;
        }
        return null;
    }

    private static void copyGroupList(ISubqueryDefinition srcSubQueryDefn, SubqueryDefinition destSubQueryDefn) {
        List<IGroupDefinition> groupList = srcSubQueryDefn.getGroups();
        int i = 0;
        while (i < groupList.size()) {
            destSubQueryDefn.addGroup((GroupDefinition)groupList.get(i));
            ++i;
        }
    }

    private static void copySubQueryList(ISubqueryDefinition srcSubQueryDefn, SubqueryDefinition destSubQueryDefn) {
        Object[] subQueryDefn = srcSubQueryDefn.getSubqueries().toArray();
        int i = 0;
        while (i < subQueryDefn.length) {
            destSubQueryDefn.addSubquery((SubqueryDefinition)subQueryDefn[i]);
            ++i;
        }
    }

    private static void copySortList(ISubqueryDefinition srcSubQueryDefn, SubqueryDefinition destSubQueryDefn) {
        List<ISortDefinition> sortList = srcSubQueryDefn.getSorts();
        int i = 0;
        while (i < sortList.size()) {
            destSubQueryDefn.addSort((SortDefinition)sortList.get(i));
            ++i;
        }
    }

    private static void copyFilterList(ISubqueryDefinition srcSubQueryDefn, SubqueryDefinition destSubQueryDefn) {
        List<IFilterDefinition> filterList = srcSubQueryDefn.getFilters();
        int i = 0;
        while (i < filterList.size()) {
            destSubQueryDefn.addFilter(filterList.get(i));
            ++i;
        }
    }
}

