/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLImageHandler;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.IImage;
import org.eclipse.birt.report.engine.api.ImageSize;

public class HTMLServerImageHandler
extends HTMLImageHandler {
    protected Logger log = Logger.getLogger(HTMLServerImageHandler.class.getName());
    private String handlerId;
    private int count = 0;
    private static HashMap<String, Serializable> map = new HashMap();
    private static HashMap<String, ImageSize> mapSize = new HashMap();

    public HTMLServerImageHandler() {
        String codePart = Integer.toHexString(this.hashCode());
        String timePart = Long.toHexString(System.currentTimeMillis());
        this.handlerId = codePart + timePart;
    }

    @Override
    @Deprecated
    public String onDesignImage(IImage image, Object context) {
        return this.handleImage(image, context, "design", true);
    }

    @Override
    @Deprecated
    public String onDocImage(IImage image, Object context) {
        return null;
    }

    @Override
    @Deprecated
    public String onURLImage(IImage image, Object context) {
        assert (image != null);
        String uri = image.getID();
        if (uri.startsWith("http:") || uri.startsWith("https:") || uri.startsWith("data:")) {
            return uri;
        }
        return this.handleImage(image, context, "uri", true);
    }

    @Override
    @Deprecated
    public String onCustomImage(IImage image, Object context) {
        return this.handleImage(image, context, "custom", false);
    }

    protected String createUniqueFileName(String imageDir, String prefix) {
        return this.createUniqueFileName(imageDir, prefix, null);
    }

    protected String createUniqueFileName(String imageDir, String prefix, String postfix) {
        File file = null;
        postfix = postfix == null ? "" : postfix;
        String uniCount = null;
        while ((file = new File(imageDir + "/" + prefix + (uniCount = this.genUniqueCount()) + postfix)).exists()) {
        }
        return prefix + uniCount + postfix;
    }

    private synchronized String genUniqueCount() {
        ++this.count;
        return this.handlerId + this.count;
    }

    @Override
    @Deprecated
    public String onFileImage(IImage image, Object context) {
        return this.handleImage(image, context, "file", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String handleImage(IImage image, Object context, String prefix, boolean needMap) {
        String mapID = null;
        if (needMap && map.containsKey(mapID = this.getImageMapID(image))) {
            HashMap<String, Serializable> hashMap = map;
            synchronized (hashMap) {
                ImageSize rawSize = mapSize.get(mapID);
                if (rawSize != null) {
                    image.setImageRawSize(rawSize);
                }
                return (String)((Object)map.get(mapID));
            }
        }
        Object ret = null;
        if (context != null && context instanceof HTMLRenderContext) {
            HTMLRenderContext myContext = (HTMLRenderContext)context;
            String imageURL = myContext.getBaseImageURL();
            String imageDir = myContext.getImageDirectory();
            if (imageURL == null || imageURL.length() == 0 || imageDir == null || imageDir.length() == 0) {
                this.log.log(Level.SEVERE, "imageURL or ImageDIR is not set!");
                return null;
            }
            String extension = image.getExtension();
            String fileName = this.createUniqueFileName(imageDir, prefix, extension);
            File file = new File(imageDir, fileName);
            try {
                image.writeImage(file);
            }
            catch (IOException e) {
                this.log.log(Level.SEVERE, e.getMessage(), e);
            }
            ret = imageURL.indexOf("?") > 0 ? imageURL + fileName : (imageURL.endsWith("/") ? imageURL + fileName : imageURL + "/" + fileName);
            if (needMap) {
                HashMap<String, Serializable> hashMap = map;
                synchronized (hashMap) {
                    map.put(mapID, (Serializable)ret);
                    mapSize.put(mapID, image.getImageRawSize());
                }
            }
        } else {
            ret = this.handleTempImage(image, prefix, needMap);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String handleTempImage(IImage image, String prefix, boolean needMap) {
        try {
            File tempFile = File.createTempFile(prefix, ".img");
            image.writeImage(tempFile);
            String fileName = tempFile.getAbsolutePath();
            if (needMap) {
                String mapID = this.getImageMapID(image);
                HashMap<String, Serializable> hashMap = map;
                synchronized (hashMap) {
                    map.put(mapID, (Serializable)((Object)fileName));
                }
            }
            return fileName;
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
            return "unknow.img";
        }
    }

    protected String getImageMapID(IImage image) {
        if (image.getReportRunnable() != null) {
            return image.getReportRunnable().hashCode() + image.getID();
        }
        return image.getID();
    }

    public void getImage(OutputStream out, String imageDir, String imageID) throws EngineException {
        if (imageID.indexOf("./") != -1 || imageID.indexOf(".\\") != -1) {
            throw new EngineException("Error.MissingImageFileError");
        }
        File imageFile = new File(imageDir, imageID);
        if (!imageFile.exists()) {
            throw new EngineException("Error.MissingImageFileError");
        }
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(imageFile);
                byte[] buffer = new byte[1024];
                int size = 0;
                do {
                    if ((size = ((InputStream)in).read(buffer)) <= 0) continue;
                    out.write(buffer, 0, size);
                } while (size > 0);
                ((InputStream)in).close();
            }
            catch (IOException ex) {
                throw new EngineException("Error.Error", ex);
            }
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

