/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;

public class NumberPropertyType
extends PropertyType {
    private static final String DISPLAY_NAME_KEY = "Property.number";
    private static final NumberFormat formatter = NumberFormat.getNumberInstance(DEFAULT_LOCALE);

    static {
        formatter.setGroupingUsed(false);
    }

    public NumberPropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    @Override
    public Object validateValue(Module module, DesignElement element, PropertyDefn defn, Object value) throws PropertyValueException {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return value;
        }
        if (value instanceof Double) {
            return new BigDecimal((Double)value);
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        if (value instanceof String) {
            return this.validateInputString(module, element, defn, (String)value);
        }
        throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 1);
    }

    @Override
    public Object validateXml(Module module, DesignElement element, PropertyDefn defn, Object value) throws PropertyValueException {
        assert (value == null || value instanceof String);
        String tmpValue = (String)value;
        if ((tmpValue = StringUtil.trimString(tmpValue)) == null) {
            return null;
        }
        try {
            return new BigDecimal(tmpValue);
        }
        catch (NumberFormatException e) {
            throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 1);
        }
    }

    @Override
    public int getTypeCode() {
        return 1;
    }

    @Override
    public String getName() {
        return "number";
    }

    @Override
    public double toDouble(Module module, Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return ((BigDecimal)value).doubleValue();
    }

    @Override
    public String toString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return formatter.format(((BigDecimal)value).doubleValue());
    }

    @Override
    public int toInteger(Module module, Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof String) {
            try {
                return Double.valueOf((String)value).intValue();
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return ((BigDecimal)value).intValue();
    }

    @Override
    public BigDecimal toNumber(Module module, Object value) {
        if (value instanceof String) {
            try {
                return new BigDecimal(formatter.parse((String)value).doubleValue());
            }
            catch (ParseException e) {
                return new BigDecimal(0.0);
            }
        }
        return (BigDecimal)value;
    }

    @Override
    public String toDisplayString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        ULocale locale = module == null ? ThreadResources.getLocale() : module.getLocale();
        NumberFormat formatter = NumberFormat.getNumberInstance(locale.toLocale());
        return formatter.format(((BigDecimal)value).doubleValue());
    }

    @Override
    public Object validateInputString(Module module, DesignElement element, PropertyDefn defn, String value) throws PropertyValueException {
        if (StringUtil.isBlank(value)) {
            return null;
        }
        ULocale locale = module == null ? ThreadResources.getLocale() : module.getLocale();
        NumberFormat formatter = NumberFormat.getNumberInstance(locale.toLocale());
        Number number = null;
        try {
            number = formatter.parse(value);
        }
        catch (ParseException e) {
            throw new PropertyValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", 1);
        }
        return new BigDecimal(number.doubleValue());
    }
}

