/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.format;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.sql.Time;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.format.IFormatter;

public class DateFormatter
implements IFormatter {
    private static final String UNFORMATTED = "Unformatted";
    public static final String DATETIME_UNFORMATTED = "DateTimeUnformatted";
    public static final String DATE_UNFORMATTED = "DateUnformatted";
    public static final String TIME_UNFORMATTED = "TimeUnformatted";
    private String formatPattern;
    private DateFormat dateTimeFormat;
    private DateFormat timeFormat;
    private DateFormat dateFormat;
    private ULocale locale = ULocale.getDefault();
    private TimeZone timeZone = null;
    protected static Logger logger = Logger.getLogger(DateFormatter.class.getName());

    public DateFormatter() {
        this(null, null, null);
    }

    public DateFormatter(TimeZone timeZone) {
        this(null, null, timeZone);
    }

    public DateFormatter(String pattern) {
        this(pattern, null, null);
    }

    public DateFormatter(ULocale localeLoc) {
        this(null, localeLoc, null);
    }

    public DateFormatter(ULocale localeLoc, TimeZone timeZone) {
        this(null, localeLoc, timeZone);
    }

    public DateFormatter(String pattern, ULocale localeLoc) {
        this(pattern, localeLoc, null);
    }

    public DateFormatter(String pattern, ULocale localeLoc, TimeZone timeZone) {
        if (localeLoc != null) {
            this.locale = localeLoc;
        }
        if (timeZone != null) {
            this.timeZone = timeZone;
        }
        this.applyPattern(pattern);
    }

    public String getPattern() {
        return this.formatPattern;
    }

    public void applyPattern(String formatString) {
        this.createPattern(formatString);
        if (this.dateFormat == null) {
            this.dateFormat = this.dateTimeFormat.clone();
        }
        if (this.timeFormat == null) {
            this.timeFormat = this.dateTimeFormat.clone();
        }
        this.applyTimeZone();
    }

    private SimpleDateFormat toPredefinedPattern(SimpleDateFormat dateformat, ULocale locale) {
        if ("en".equals(locale.getLanguage())) {
            String PredefinePattern = dateformat.toPattern().replace("y,", "y");
            return new SimpleDateFormat(PredefinePattern, locale);
        }
        return dateformat;
    }

    private void createPattern(String formatString) {
        try {
            this.formatPattern = formatString;
            this.dateTimeFormat = null;
            this.dateFormat = null;
            this.timeFormat = null;
            if (formatString == null || UNFORMATTED.equals(formatString)) {
                this.formatPattern = UNFORMATTED;
                this.dateTimeFormat = DateFormat.getDateTimeInstance((int)2, (int)3, (ULocale)this.locale);
                this.dateTimeFormat = this.toPredefinedPattern((SimpleDateFormat)this.dateTimeFormat, this.locale);
                this.dateFormat = DateFormat.getDateInstance((int)2, (ULocale)this.locale);
                this.timeFormat = DateFormat.getTimeInstance((int)2, (ULocale)this.locale);
                return;
            }
            if (formatString.equals(DATETIME_UNFORMATTED)) {
                this.dateTimeFormat = DateFormat.getDateTimeInstance((int)2, (int)3, (ULocale)this.locale);
                this.dateTimeFormat = this.toPredefinedPattern((SimpleDateFormat)this.dateTimeFormat, this.locale);
                return;
            }
            if (formatString.equals(DATE_UNFORMATTED)) {
                this.dateTimeFormat = DateFormat.getDateInstance((int)2, (ULocale)this.locale);
                return;
            }
            if (formatString.equals(TIME_UNFORMATTED)) {
                this.dateTimeFormat = DateFormat.getTimeInstance((int)2, (ULocale)this.locale);
                return;
            }
            if (formatString.length() == 1) {
                char patternTemp = formatString.charAt(0);
                switch (patternTemp) {
                    case 'G': {
                        this.dateTimeFormat = DateFormat.getDateTimeInstance((int)1, (int)1, (ULocale)this.locale);
                        this.dateFormat = DateFormat.getDateInstance((int)1, (ULocale)this.locale);
                        this.timeFormat = DateFormat.getTimeInstance((int)1, (ULocale)this.locale);
                        return;
                    }
                    case 'D': {
                        this.dateTimeFormat = DateFormat.getDateInstance((int)1, (ULocale)this.locale);
                        return;
                    }
                    case 'd': {
                        this.dateTimeFormat = DateFormat.getDateInstance((int)3, (ULocale)this.locale);
                        return;
                    }
                    case 'T': {
                        this.dateTimeFormat = DateFormat.getTimeInstance((int)1, (ULocale)this.locale);
                        return;
                    }
                    case 't': {
                        this.dateTimeFormat = new SimpleDateFormat("HH:mm", this.locale);
                        return;
                    }
                    case 'f': {
                        this.dateTimeFormat = DateFormat.getDateTimeInstance((int)1, (int)3, (ULocale)this.locale);
                        return;
                    }
                    case 'F': {
                        this.dateTimeFormat = DateFormat.getDateTimeInstance((int)1, (int)1, (ULocale)this.locale);
                        return;
                    }
                    case 'A': 
                    case 'I': 
                    case 'a': 
                    case 'i': {
                        int timeForm = patternTemp == 'i' || patternTemp == 'a' ? 2 : 1;
                        DateFormat factoryFormat = DateFormat.getTimeInstance((int)timeForm, (ULocale)this.locale);
                        this.timeFormat = patternTemp == 'a' || patternTemp == 'A' ? this.hackMilliSecond(factoryFormat) : factoryFormat;
                        factoryFormat = DateFormat.getDateInstance((int)3, (ULocale)this.locale);
                        this.dateFormat = this.hackYear(factoryFormat);
                        factoryFormat = DateFormat.getDateTimeInstance((int)3, (int)timeForm, (ULocale)this.locale);
                        this.dateTimeFormat = this.hackYear(factoryFormat);
                        if (patternTemp == 'a' || patternTemp == 'A') {
                            this.dateTimeFormat = this.hackMilliSecond(this.dateTimeFormat);
                        }
                        return;
                    }
                    case 'g': {
                        this.dateTimeFormat = DateFormat.getDateTimeInstance((int)3, (int)3, (ULocale)this.locale);
                        return;
                    }
                    case 'M': 
                    case 'm': {
                        this.dateTimeFormat = new SimpleDateFormat("MM/dd", this.locale);
                        return;
                    }
                    case 'R': 
                    case 'r': {
                        this.dateTimeFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss a", this.locale);
                        this.dateTimeFormat.setTimeZone(TimeZone.getTimeZone((String)"GMT"));
                        return;
                    }
                    case 's': {
                        this.dateTimeFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss", this.locale);
                        return;
                    }
                    case 'u': {
                        this.dateTimeFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss  Z", this.locale);
                        return;
                    }
                    case 'Y': 
                    case 'y': {
                        this.dateTimeFormat = new SimpleDateFormat("yyyy/mm", this.locale);
                        return;
                    }
                }
                this.dateTimeFormat = new SimpleDateFormat(formatString, this.locale);
                return;
            }
            if (formatString.equals("General Date")) {
                this.dateTimeFormat = DateFormat.getDateTimeInstance((int)1, (int)1, (ULocale)this.locale);
                return;
            }
            if (formatString.equals("Long Date")) {
                this.dateTimeFormat = DateFormat.getDateInstance((int)1, (ULocale)this.locale);
                return;
            }
            if (formatString.equals("Medium Date")) {
                this.dateTimeFormat = DateFormat.getDateInstance((int)2, (ULocale)this.locale);
                return;
            }
            if (formatString.equals("Short Date")) {
                this.dateTimeFormat = DateFormat.getDateInstance((int)3, (ULocale)this.locale);
                return;
            }
            if (formatString.equals("Long Time")) {
                this.dateTimeFormat = DateFormat.getTimeInstance((int)1, (ULocale)this.locale);
                return;
            }
            if (formatString.equals("Medium Time")) {
                this.dateTimeFormat = DateFormat.getTimeInstance((int)2, (ULocale)this.locale);
                return;
            }
            if (formatString.equals("Short Time")) {
                this.dateTimeFormat = new SimpleDateFormat("kk:mm", this.locale);
                return;
            }
            if (formatString.equals("Date Picker")) {
                this.dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd", this.locale);
                return;
            }
            if (formatString.equals("Date Picker, Short Time")) {
                this.dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm", this.locale);
                return;
            }
            if (formatString.equals("Date Picker, Medium Time")) {
                this.dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", this.locale);
                return;
            }
            if (formatString.equals("Time Picker, Short Time")) {
                this.dateTimeFormat = new SimpleDateFormat("HH:mm", this.locale);
                return;
            }
            if (formatString.equals("Time Picker, Medium Time")) {
                this.dateTimeFormat = new SimpleDateFormat("HH:mm:ss", this.locale);
                return;
            }
            this.dateTimeFormat = new SimpleDateFormat(formatString, this.locale);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private void applyTimeZone() {
        if (this.timeZone != null) {
            if (this.dateTimeFormat != null) {
                this.dateTimeFormat.setTimeZone(this.timeZone);
            }
            if (this.timeFormat != null) {
                this.timeFormat.setTimeZone(this.timeZone);
            }
        }
    }

    private DateFormat hackYear(DateFormat factoryFormat) {
        if (factoryFormat instanceof SimpleDateFormat) {
            int idx;
            SimpleDateFormat factorySimpleFormat = (SimpleDateFormat)factoryFormat;
            String pattern = factorySimpleFormat.toPattern();
            if (pattern.indexOf("yyyy") == -1 && (idx = pattern.indexOf("yy")) >= 0) {
                StringBuilder strBuf = new StringBuilder(pattern);
                strBuf.insert(idx, 'y');
                pattern = strBuf.toString();
            }
            return new SimpleDateFormat(pattern, this.locale);
        }
        return factoryFormat;
    }

    private DateFormat hackMilliSecond(DateFormat factoryFormat) {
        if (factoryFormat instanceof SimpleDateFormat) {
            int idx;
            SimpleDateFormat factorySimpleFormat = (SimpleDateFormat)factoryFormat;
            String pattern = factorySimpleFormat.toPattern();
            if (pattern.indexOf("SSS") == -1 && (idx = pattern.indexOf("ss")) >= 0) {
                StringBuilder strBuf = new StringBuilder(pattern);
                strBuf.insert(idx + 2, ".SSS");
                pattern = strBuf.toString();
            }
            return new SimpleDateFormat(pattern, this.locale);
        }
        return factoryFormat;
    }

    public String format(Date date) {
        try {
            if (date instanceof java.sql.Date) {
                if (this.dateFormat != null) {
                    return this.dateFormat.format(date);
                }
            } else if (date instanceof Time && this.timeFormat != null) {
                return this.timeFormat.format(date);
            }
            return this.dateTimeFormat.format(date);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public String getFormatCode() {
        if (UNFORMATTED.equals(this.formatPattern) || DATETIME_UNFORMATTED.equals(this.formatPattern) || DATE_UNFORMATTED.equals(this.formatPattern) || TIME_UNFORMATTED.equals(this.formatPattern)) {
            return ((SimpleDateFormat)this.dateFormat).toPattern();
        }
        SimpleDateFormat format = this.getFormatter();
        if (format == null) {
            return ((SimpleDateFormat)this.dateFormat).toPattern();
        }
        return format.toPattern();
    }

    public String getLocalizedFormatCode() {
        if (UNFORMATTED.equals(this.formatPattern) || DATETIME_UNFORMATTED.equals(this.formatPattern) || DATE_UNFORMATTED.equals(this.formatPattern) || TIME_UNFORMATTED.equals(this.formatPattern)) {
            return ((SimpleDateFormat)this.dateFormat).toLocalizedPattern();
        }
        SimpleDateFormat format = this.getFormatter();
        if (format == null) {
            return ((SimpleDateFormat)this.dateFormat).toPattern();
        }
        return format.toLocalizedPattern();
    }

    public SimpleDateFormat getFormatter() {
        SimpleDateFormat dateFormat = null;
        if (this.formatPattern.equals("General Date")) {
            dateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance((int)1, (int)1, (ULocale)this.locale);
        }
        if (this.formatPattern.equals("Long Date")) {
            dateFormat = (SimpleDateFormat)DateFormat.getDateInstance((int)1, (ULocale)this.locale);
        }
        if (this.formatPattern.equals("Medium Date")) {
            dateFormat = (SimpleDateFormat)DateFormat.getDateInstance((int)2, (ULocale)this.locale);
        }
        if (this.formatPattern.equals("Short Date")) {
            dateFormat = (SimpleDateFormat)DateFormat.getDateInstance((int)3, (ULocale)this.locale);
        }
        if (this.formatPattern.equals("Long Time")) {
            dateFormat = (SimpleDateFormat)DateFormat.getTimeInstance((int)1, (ULocale)this.locale);
        }
        if (this.formatPattern.equals("Medium Time")) {
            dateFormat = (SimpleDateFormat)DateFormat.getTimeInstance((int)2, (ULocale)this.locale);
        }
        if (this.formatPattern.equals("Short Time")) {
            dateFormat = new SimpleDateFormat("kk:mm", this.locale);
        }
        return dateFormat;
    }

    public Date parse(String date) throws ParseException {
        try {
            return this.dateTimeFormat.parse(date);
        }
        catch (ParseException ex) {
            if (this.dateFormat != null) {
                try {
                    return this.dateFormat.parse(date);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (this.timeFormat != null) {
                try {
                    return this.timeFormat.parse(date);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    @Override
    public String formatValue(Object value) {
        assert (value instanceof Date);
        return this.format((Date)value);
    }
}

