/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.engine.computation;

import junit.framework.TestCase;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.withaxes.ScaleContext;
import org.eclipse.birt.chart.util.CDateTime;

public class ScaleContextTest
extends TestCase {
    public void testLinearScaleWithoutFixed() {
        ScaleContext scale = new ScaleContext(0, 2, (Object)0, (Object)5, (Object)1);
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)new Double(0.0), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)new Double(6.0), (Object)scale.getMax());
        ScaleContextTest.assertEquals(null, (Object)scale.getMinWithMargin());
        ScaleContextTest.assertEquals(null, (Object)scale.getMaxWithMargin());
        scale = new ScaleContext(0, 2, (Object)0, (Object)5, (Object)new Double(1.2));
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)new Double(0.0), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)new Double(6.0), (Object)scale.getMax());
        scale = new ScaleContext(0, 2, (Object)0, (Object)6, (Object)new Double(1.2));
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)new Double(0.0), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)new Double(7.2), (Object)scale.getMax());
        scale = new ScaleContext(0, 2, (Object)1, (Object)6, (Object)new Double(1.5));
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)new Double(0.0), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)new Double(7.5), (Object)scale.getMax());
        scale = new ScaleContext(0, 2, (Object)-1, (Object)6, (Object)new Double(1.5));
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)new Double(-1.5), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)new Double(7.5), (Object)scale.getMax());
    }

    public void testLinearScaleWithFixed() {
        ScaleContext scale = new ScaleContext(0, 2, (Object)0, (Object)5, (Object)1);
        scale.setFixedValue(true, false, (Object)new Double(1.0), null);
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)new Double(1.0), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)new Double(6.0), (Object)scale.getMax());
        ScaleContextTest.assertEquals(null, (Object)scale.getMinWithMargin());
        ScaleContextTest.assertEquals(null, (Object)scale.getMaxWithMargin());
        scale = new ScaleContext(0, 2, (Object)0, (Object)5, (Object)new Double(1.2));
        scale.setFixedValue(true, true, (Object)new Double(1.0), (Object)new Double(5.0));
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)new Double(1.0), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)new Double(5.0), (Object)scale.getMax());
        ScaleContextTest.assertEquals(null, (Object)scale.getMinWithMargin());
        ScaleContextTest.assertEquals(null, (Object)scale.getMaxWithMargin());
    }

    public void testLinearScaleWithMargin() {
        ScaleContext scale = new ScaleContext(20, 2, (Object)1, (Object)5, (Object)1);
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)new Double(0.0), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)new Double(6.0), (Object)scale.getMax());
        scale = new ScaleContext(20, 2, (Object)1, (Object)6, (Object)new Double(1.0));
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)new Double(0.0), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)new Double(7.0), (Object)scale.getMax());
        scale = new ScaleContext(20, 2, (Object)new Double(0.0), (Object)new Double(6.0), (Object)new Double(2.0));
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)new Double(-2.0), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)new Double(8.0), (Object)scale.getMax());
        scale = new ScaleContext(20, 2, (Object)new Double(-1.0), (Object)new Double(7.0), (Object)new Double(2.0));
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)new Double(-4.0), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)new Double(10.0), (Object)scale.getMax());
        scale = new ScaleContext(20, 2, (Object)new Double(3.0), (Object)new Double(4.0), (Object)new Double(1.0));
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)new Double(2.0), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)new Double(5.0), (Object)scale.getMax());
        scale = new ScaleContext(20, 2, (Object)new Double(-4.0), (Object)new Double(-3.0), (Object)new Double(1.0));
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)new Double(-5.0), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)new Double(-2.0), (Object)scale.getMax());
        scale = new ScaleContext(20, 2, (Object)new Double(25.21), (Object)new Double(27.9), (Object)new Double(1.0));
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)new Double(24.0), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)new Double(29.0), (Object)scale.getMax());
    }

    public void testLinearScaleWithMarginAndFixed() {
        ScaleContext scale = new ScaleContext(20, 2, (Object)new Double(1.0), (Object)new Double(5.0), (Object)new Double(1.0));
        scale.setFixedValue(true, true, (Object)new Double(0.0), (Object)new Double(7.0));
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)new Double(0.0), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)new Double(7.0), (Object)scale.getMax());
        ScaleContextTest.assertEquals(null, (Object)scale.getMinWithMargin());
        ScaleContextTest.assertEquals(null, (Object)scale.getMaxWithMargin());
        scale = new ScaleContext(20, 2, (Object)new Double(1.0), (Object)new Double(5.0), (Object)new Double(1.0));
        scale.setFixedValue(true, true, (Object)new Double(1.0), (Object)new Double(5.0));
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)new Double(1.0), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)new Double(5.0), (Object)scale.getMax());
        ScaleContextTest.assertEquals((long)0L, (long)Math.round(Methods.asDouble((Object)scale.getMinWithMargin())));
        ScaleContextTest.assertEquals((long)6L, (long)Math.round(Methods.asDouble((Object)scale.getMaxWithMargin())));
    }

    public void testDateTimeScaleWithoutFixed() {
        ScaleContext scale = new ScaleContext(0, 8, (Object)1, (Object)CDateTime.parse((String)"01-01-2007 00:00:00"), (Object)CDateTime.parse((String)"03-31-2007 00:00:00"), (Object)1);
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"01-01-2006 00:00:00"), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"01-01-2008 00:00:00"), (Object)scale.getMax());
        ScaleContextTest.assertEquals(null, (Object)scale.getMinWithMargin());
        ScaleContextTest.assertEquals(null, (Object)scale.getMaxWithMargin());
        scale = new ScaleContext(0, 8, (Object)2, (Object)CDateTime.parse((String)"01-01-2007 00:00:00"), (Object)CDateTime.parse((String)"03-31-2007 00:00:00"), (Object)1);
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"12-01-2006 00:00:00"), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"04-01-2007 00:00:00"), (Object)scale.getMax());
        scale = new ScaleContext(0, 8, (Object)5, (Object)CDateTime.parse((String)"01-01-2007 00:00:00"), (Object)CDateTime.parse((String)"03-31-2007 00:00:00"), (Object)1);
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"12-31-2006 00:00:00"), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"04-01-2007 00:00:00"), (Object)scale.getMax());
        scale = new ScaleContext(0, 8, (Object)10, (Object)CDateTime.parse((String)"03-10-2007 10:12:12"), (Object)CDateTime.parse((String)"03-31-2007 09:13:22"), (Object)1);
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"03-10-2007 09:00:00"), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"03-31-2007 10:00:00"), (Object)scale.getMax());
        scale = new ScaleContext(0, 8, (Object)12, (Object)CDateTime.parse((String)"03-10-2007 10:12:12"), (Object)CDateTime.parse((String)"03-31-2007 09:13:22"), (Object)1);
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"03-10-2007 10:11:00"), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"03-31-2007 09:14:00"), (Object)scale.getMax());
        scale = new ScaleContext(0, 8, (Object)13, (Object)CDateTime.parse((String)"03-10-2007 10:12:12"), (Object)CDateTime.parse((String)"03-31-2007 09:13:22"), (Object)1);
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"03-10-2007 10:12:11"), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"03-31-2007 09:13:23"), (Object)scale.getMax());
    }

    public void testDateTimeScaleWithFixed() {
        ScaleContext scale = new ScaleContext(0, 8, (Object)1, (Object)CDateTime.parse((String)"01-01-2007 00:00:00"), (Object)CDateTime.parse((String)"03-31-2007 00:00:00"), (Object)1);
        scale.setFixedValue(true, false, (Object)CDateTime.parse((String)"01-01-2007 00:00:00"), null);
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"01-01-2007 00:00:00"), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"01-01-2008 00:00:00"), (Object)scale.getMax());
        ScaleContextTest.assertEquals(null, (Object)scale.getMinWithMargin());
        ScaleContextTest.assertEquals(null, (Object)scale.getMaxWithMargin());
        scale = new ScaleContext(0, 8, (Object)2, (Object)CDateTime.parse((String)"01-01-2007 00:00:00"), (Object)CDateTime.parse((String)"03-31-2007 00:00:00"), (Object)1);
        scale.setFixedValue(true, true, (Object)CDateTime.parse((String)"01-01-2007 00:00:00"), (Object)CDateTime.parse((String)"03-01-2007 00:00:00"));
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"01-01-2007 00:00:00"), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"03-01-2007 00:00:00"), (Object)scale.getMax());
        scale = new ScaleContext(0, 8, (Object)5, (Object)CDateTime.parse((String)"01-01-2007 00:00:00"), (Object)CDateTime.parse((String)"03-31-2007 00:00:00"), (Object)1);
        scale.setFixedValue(true, true, (Object)CDateTime.parse((String)"01-01-2007 00:00:00"), (Object)CDateTime.parse((String)"03-01-2007 00:00:00"));
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"01-01-2007 00:00:00"), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"03-01-2007 00:00:00"), (Object)scale.getMax());
        scale = new ScaleContext(0, 8, (Object)10, (Object)CDateTime.parse((String)"03-10-2007 10:12:12"), (Object)CDateTime.parse((String)"03-31-2007 09:13:22"), (Object)1);
        scale.setFixedValue(true, true, (Object)CDateTime.parse((String)"03-10-2007 11:00:00"), (Object)CDateTime.parse((String)"04-01-2007 00:00:00"));
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"03-10-2007 11:00:00"), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"04-01-2007 00:00:00"), (Object)scale.getMax());
        scale = new ScaleContext(0, 8, (Object)12, (Object)CDateTime.parse((String)"03-10-2007 10:12:12"), (Object)CDateTime.parse((String)"03-31-2007 09:13:22"), (Object)1);
        scale.setFixedValue(true, true, (Object)CDateTime.parse((String)"03-01-2007 01:12:00"), (Object)CDateTime.parse((String)"03-31-2007 10:01:00"));
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"03-01-2007 01:12:00"), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"03-31-2007 10:01:00"), (Object)scale.getMax());
        scale = new ScaleContext(0, 8, (Object)13, (Object)CDateTime.parse((String)"03-10-2007 10:12:12"), (Object)CDateTime.parse((String)"03-31-2007 09:13:22"), (Object)1);
        scale.setFixedValue(true, true, (Object)CDateTime.parse((String)"03-01-2007 01:12:12"), (Object)CDateTime.parse((String)"03-31-2007 10:01:31"));
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"03-01-2007 01:12:12"), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)CDateTime.parse((String)"03-31-2007 10:01:31"), (Object)scale.getMax());
    }

    public void testLogScaleWithoutFixed() {
        ScaleContext scale = new ScaleContext(0, 4, (Object)0, (Object)5, (Object)10);
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)new Double(0.0), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)new Double(10.0), (Object)scale.getMax());
        scale = new ScaleContext(0, 4, (Object)1, (Object)5, (Object)10);
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)new Double(1.0), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)new Double(10.0), (Object)scale.getMax());
        scale = new ScaleContext(0, 4, (Object)2, (Object)12, (Object)10);
        scale.computeMinMax();
        ScaleContextTest.assertEquals((Object)new Double(1.0), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)new Double(100.0), (Object)scale.getMax());
    }

    public void testLogScaleWithFixed() {
        ScaleContext scale = new ScaleContext(0, 4, (Object)0, (Object)5, (Object)10);
        scale.computeMinMax();
        scale.setFixedValue(true, true, (Object)new Double(1.0), (Object)new Double(6.0));
        ScaleContextTest.assertEquals((Object)new Double(1.0), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)new Double(6.0), (Object)scale.getMax());
        scale = new ScaleContext(0, 4, (Object)1, (Object)5, (Object)10);
        scale.computeMinMax();
        scale.setFixedValue(true, true, (Object)new Double(1.0), (Object)new Double(6.0));
        ScaleContextTest.assertEquals((Object)new Double(1.0), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)new Double(6.0), (Object)scale.getMax());
        scale = new ScaleContext(0, 4, (Object)2, (Object)12, (Object)10);
        scale.computeMinMax();
        scale.setFixedValue(true, true, (Object)new Double(1.0), (Object)new Double(100.0));
        ScaleContextTest.assertEquals((Object)new Double(1.0), (Object)scale.getMin());
        ScaleContextTest.assertEquals((Object)new Double(100.0), (Object)scale.getMax());
    }
}

