/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ArchiveRemoveTest
extends TestCase {
    static final String ARCHIVE_FOLDER = "./utest/";
    static final String ARCHIVE_FILE = "./utest/archive.rptdocument";

    @Before
    public void setUp() {
        new File(ARCHIVE_FOLDER).mkdirs();
    }

    @After
    public void tearDown() {
        new File(ARCHIVE_FILE).delete();
        new File(ARCHIVE_FOLDER).delete();
    }

    @Test
    public void testArchiveFileRemove() throws IOException {
        archive.setCacheSize(65536L);
        try (ArchiveFile archive = new ArchiveFile(ARCHIVE_FILE, "rw");){
            this.createEntry((IArchiveFile)archive, "ENTRY", 9);
            archive.flush();
            ArchiveRemoveTest.assertEquals((int)12, (int)this.getFileSize((IArchiveFile)archive));
            archive.removeEntry("ENTRY");
            this.createEntry((IArchiveFile)archive, "ENTRY", 10);
            ArchiveRemoveTest.assertEquals((int)14, (int)this.getFileSize((IArchiveFile)archive));
            archive.removeEntry("ENTRY");
            this.createEntry((IArchiveFile)archive, "ENTRY", 1033);
            ArchiveRemoveTest.assertEquals((int)1037, (int)this.getFileSize((IArchiveFile)archive));
            archive.removeEntry("ENTRY");
            this.createEntry((IArchiveFile)archive, "ENTRY", 1034);
            ArchiveRemoveTest.assertEquals((int)1040, (int)this.getFileSize((IArchiveFile)archive));
            archive.removeEntry("ENTRY");
            this.createEntry((IArchiveFile)archive, "ENTRY", 1035);
            ArchiveRemoveTest.assertEquals((int)1041, (int)this.getFileSize((IArchiveFile)archive));
        }
    }

    @Test
    public void testArchiveFileRandomRemove() throws IOException {
        archive.setCacheSize(65536L);
        try (ArchiveFile archive = new ArchiveFile(ARCHIVE_FILE, "rw");){
            int i = 0;
            while (i < 32) {
                this.createEntry((IArchiveFile)archive, "ENTRY", 9 + i * 2);
                archive.removeEntry("ENTRY");
                if (i % 10 == 0) {
                    System.out.println(i + ":" + archive.getUsedCache() / 4096L + "/" + ArchiveFile.getTotalUsedCache() / 4096L);
                }
                ++i;
            }
        }
    }

    protected void createEntry(IArchiveFile af, String name, int block) throws IOException {
        try (ArchiveEntry entry = af.createEntry(name);){
            long position = 0L;
            byte[] buffer = new byte[4096];
            int j = 0;
            while (j < block) {
                entry.write(position, buffer, 0, buffer.length);
                position += (long)buffer.length;
                ++j;
            }
        }
    }

    int getFileSize(IArchiveFile af) throws IOException {
        af.flush();
        String filename = af.getName();
        return (int)((new File(filename).length() + 4095L) / 4096L);
    }
}

