/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.api.impl.LogicalPageSequence;

public class LogicalPageSequenceTest
extends TestCase {
    public void testMerge() {
        long[][] pages1 = new long[][]{{200L, 700L}, {900L, 1200L}, {1500L, 1600L}};
        long[][] pages2 = new long[][]{{100L, 300L}, {400L, 500L}, {600L, 800L}, {1000L, 1100L}, {1300L, 1400L}};
        ArrayList<long[][]> pages = new ArrayList<long[][]>();
        pages.add(pages1);
        pages.add(pages2);
        LogicalPageSequence sequence = new LogicalPageSequence(pages);
        LogicalPageSequenceTest.assertEquals((long)404L, (long)sequence.getTotalVisiblePageCount());
        LogicalPageSequenceTest.assertEquals((String)"[200-300],[400-500],[600-700],[1000-1100]", (String)this.toString(sequence.getVisiblePages()));
    }

    public void testMergeWithMax() {
        long[][] pages1 = new long[][]{{200L, 700L}, {900L, 1200L}, {1500L, 1600L}};
        long[][] pages2 = new long[][]{{100L, 300L}, {400L, 500L}, {600L, 800L}, {1000L, 1100L}, {1300L, 1400L}};
        ArrayList<long[][]> pages = new ArrayList<long[][]>();
        pages.add(pages1);
        pages.add(pages2);
        LogicalPageSequence sequence = new LogicalPageSequence(pages, 659L);
        LogicalPageSequenceTest.assertEquals((long)262L, (long)sequence.getTotalVisiblePageCount());
        LogicalPageSequenceTest.assertEquals((String)"[200-300],[400-500],[600-659]", (String)this.toString(sequence.getVisiblePages()));
    }

    public void testGetLogicalPageNumber() {
        LogicalPageSequence sequence = new LogicalPageSequence((long[][])new long[][]{{100L, 199L}, {300L, 399L}});
        LogicalPageSequenceTest.assertEquals((long)200L, (long)sequence.getTotalVisiblePageCount());
        long logicalNumber = sequence.getLogicalPageNumber(1L);
        LogicalPageSequenceTest.assertEquals((long)-1L, (long)logicalNumber);
        LogicalPageSequenceTest.assertEquals((long)1L, (long)sequence.getLogicalPageNumber(100L));
        LogicalPageSequenceTest.assertEquals((long)100L, (long)sequence.getLogicalPageNumber(199L));
        LogicalPageSequenceTest.assertEquals((long)-1L, (long)sequence.getLogicalPageNumber(201L));
        LogicalPageSequenceTest.assertEquals((long)101L, (long)sequence.getLogicalPageNumber(300L));
        LogicalPageSequenceTest.assertEquals((long)200L, (long)sequence.getLogicalPageNumber(399L));
        LogicalPageSequenceTest.assertEquals((long)-1L, (long)sequence.getLogicalPageNumber(400L));
    }

    public void testGetPhysicalPageSequence() {
        LogicalPageSequence sequence = new LogicalPageSequence((long[][])new long[][]{{100L, 199L}, {300L, 399L}});
        long[][] pages = sequence.getPhysicalPageNumbers((long[][])new long[][]{{1L, 200L}});
        LogicalPageSequenceTest.assertEquals((String)"[100-199],[300-399]", (String)this.toString(pages));
        pages = sequence.getPhysicalPageNumbers((long[][])new long[][]{{10L, 20L}, {99L, 102L}, {200L, 200L}});
        LogicalPageSequenceTest.assertEquals((String)"[109-119],[198-199],[300-301],[399-399]", (String)this.toString(pages));
    }

    public String toString(long[][] pages) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < pages.length) {
            builder.append("[");
            builder.append(pages[i][0]);
            builder.append("-");
            builder.append(pages[i][1]);
            builder.append("]");
            builder.append(",");
            ++i;
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }
}

