/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter;

import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.api.HTMLActionHandler;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.impl.Action;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.impl.ActionContent;

public class EmbeddedHyperlinkProcessorTest
extends TestCase {
    HTMLActionHandler processor;
    HTMLRenderContext context;

    protected void setUp() {
        this.processor = new HTMLActionHandler();
        this.context = new HTMLRenderContext();
        this.context.setBaseURL("http://localhost/birt/servlet");
        this.context.setImageDirectory("image");
        this.context.setBaseImageURL("http://localhost/birt/image");
    }

    public void testBookmark() {
        String bookmark = "bookmark";
        ActionContent action = new ActionContent();
        action.setBookmark(bookmark);
        Action act = new Action((IHyperlinkAction)action);
        String url = this.processor.getURL((IAction)act, (Object)this.context);
        EmbeddedHyperlinkProcessorTest.assertEquals((String)url, (String)("#" + bookmark));
    }

    public void testHyperlink() {
        String hyperlink = "hyperlink";
        String target = "target";
        ActionContent action = new ActionContent();
        action.setHyperlink(hyperlink, target);
        Action act = new Action((IHyperlinkAction)action);
        String url = this.processor.getURL((IAction)act, (Object)this.context);
        EmbeddedHyperlinkProcessorTest.assertEquals((String)url, (String)hyperlink);
    }

    public void testDrillThrough() {
        String bookmark = "bookmark";
        String reportName = "report";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("param1", "string");
        String goldenUrl = "http://localhost/birt/servlet?__report=report&__format=html&param1=string&__overwrite=true&__bookmark=bookmark";
        ActionContent action = new ActionContent();
        action.setDrillThrough(bookmark, true, reportName, params, null, "_blank", "html", null);
        Action act = new Action((IHyperlinkAction)action);
        String url = this.processor.getURL((IAction)act, (Object)this.context);
        EmbeddedHyperlinkProcessorTest.assertEquals((String)goldenUrl, (String)url);
    }
}

