/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientPreparedStatement;
import org.apache.derby.client.am.ClientResultSet;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.ConnectionCallbackInterface;
import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.MaterialStatement;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.SqlWarning;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.StatementCallbackInterface;
import org.apache.derby.client.am.Utils;
import org.apache.derby.shared.common.sanity.SanityManager;

public class ClientStatement
implements Statement,
StatementCallbackInterface {
    private static long fetchedRowBase = 0L;
    private MaterialStatement materialStatement_ = null;
    ClientConnection connection_;
    private Section section_;
    Agent agent_;
    private Statement owner = null;
    ClientResultSet resultSet_;
    long updateCount_ = -1L;
    static final int executeQueryMethod__ = 1;
    static final int executeUpdateMethod__ = 2;
    static final int executeMethod__ = 3;
    protected int sqlMode_ = 0;
    static final int isQuery__ = 1;
    static final int isCall__ = 2;
    static final int isUpdate__ = 4;
    int sqlUpdateMode_ = 0;
    static final int isInsertSql__ = 32;
    static final int isDeleteSql__ = 64;
    static final int isUpdateSql__ = 128;
    ColumnMetaData resultSetMetaData_;
    public Cursor cachedCursor_ = null;
    public Cursor cachedSingletonRowData_ = null;
    boolean isPreparedStatement_ = false;
    String cursorName_ = null;
    boolean openOnClient_ = true;
    private int indexOfCurrentResultSet_ = -1;
    ClientResultSet[] resultSetList_ = null;
    protected static final String TIMEOUT_STATEMENT = "SET STATEMENT_TIMEOUT ";
    protected ArrayList<String> timeoutArrayList = new ArrayList(1);
    protected boolean doWriteTimeout = false;
    int timeout_ = 0;
    long maxRows_ = 0L;
    int maxFieldSize_ = 0;
    boolean isAutoCommittableStatement_ = true;
    boolean isCatalogQuery_ = false;
    final ArrayList<Object> batch_ = new ArrayList();
    public int resultSetType_ = 1003;
    public int resultSetConcurrency_ = 1007;
    int resultSetHoldability_;
    int fetchSize_ = 0;
    int fetchDirection_ = 1000;
    Cursor singletonRowData_ = null;
    public String cursorAttributesToSendOnPrepare_ = null;
    ClientPreparedStatement preparedStatementForAutoGeneratedKeys_;
    ClientResultSet generatedKeysResultSet_;
    String[] generatedKeysColumnNames_;
    int[] generatedKeysColumnIndexes_;
    int autoGeneratedKeys_ = 2;
    private SqlWarning warnings_ = null;
    protected boolean isPoolable = false;
    private boolean closeOnCompletion_ = false;
    private boolean closingResultSets_ = false;
    private Section setSpecialRegisterSection_ = null;
    private static final int OUTSIDE = 0;
    private static final int INSIDE_SIMPLECOMMENT = 1;
    private static final int INSIDE_BRACKETED_COMMENT = 2;

    public static void setFetchedRowBase(long newBase) {
        fetchedRowBase = newBase;
    }

    public MaterialStatement getMaterialStatement() {
        return this.materialStatement_;
    }

    public void setMaterialStatement(MaterialStatement materialStatement) {
        this.materialStatement_ = materialStatement;
    }

    private ClientStatement() {
        this.initStatement();
    }

    private void resetStatement() {
        this.initStatement();
    }

    private void initStatement() {
        this.materialStatement_ = null;
        this.connection_ = null;
        this.agent_ = null;
        this.resultSetType_ = 1003;
        this.resultSetConcurrency_ = 1007;
        this.resultSetHoldability_ = 0;
        this.cursorAttributesToSendOnPrepare_ = null;
        if (this.timeoutArrayList.size() == 0) {
            this.timeoutArrayList.add(null);
        }
        this.initResetStatement();
    }

    private void initResetStatement() {
        this.initResetPreparedStatement();
        if (this.section_ != null) {
            this.section_.free();
        }
        if (this.setSpecialRegisterSection_ != null) {
            this.setSpecialRegisterSection_.free();
            this.setSpecialRegisterSection_ = null;
        }
        this.sqlMode_ = 0;
        this.sqlUpdateMode_ = 0;
        this.resultSetMetaData_ = null;
    }

    protected void initResetPreparedStatement() {
        this.warnings_ = null;
        this.resultSet_ = null;
        this.updateCount_ = -1L;
        this.openOnClient_ = true;
        this.indexOfCurrentResultSet_ = -1;
        this.resultSetList_ = null;
        this.isCatalogQuery_ = false;
        this.isAutoCommittableStatement_ = true;
        this.batch_.clear();
        this.singletonRowData_ = null;
        this.preparedStatementForAutoGeneratedKeys_ = null;
        this.generatedKeysResultSet_ = null;
        this.generatedKeysColumnNames_ = null;
        this.generatedKeysColumnIndexes_ = null;
        this.autoGeneratedKeys_ = 2;
        this.resetUserControllableAttributes();
    }

    private void resetUserControllableAttributes() {
        this.cursorName_ = null;
        this.timeout_ = 0;
        this.doWriteTimeout = false;
        this.maxRows_ = 0L;
        this.maxFieldSize_ = 0;
        this.fetchSize_ = 0;
        this.fetchDirection_ = 1000;
        this.isPoolable = this.isPreparedStatement_;
    }

    public void reset(boolean fullReset) throws SqlException {
        if (fullReset) {
            this.connection_.resetStatement(this);
        } else {
            this.initResetStatement();
            this.materialStatement_.reset_();
        }
    }

    void resetForReuse() throws SqlException {
        this.batch_.clear();
        this.clearWarningsX();
        int numberOfResultSetsToClose = 0;
        if (this.resultSetList_ != null) {
            numberOfResultSetsToClose = this.resultSetList_.length;
        }
        try {
            if (this.willTickleServer(numberOfResultSetsToClose, this.connection_.autoCommit_)) {
                this.flowClose();
            } else {
                this.flowCloseOutsideUOW();
            }
        }
        finally {
            this.markResultSetsClosed(false);
            this.removeClientCursorNameFromCache();
            this.markPreparedStatementForAutoGeneratedKeysClosed();
            if (this.setSpecialRegisterSection_ != null) {
                this.setSpecialRegisterSection_.free();
                this.setSpecialRegisterSection_ = null;
            }
            this.resetUserControllableAttributes();
        }
    }

    public ClientStatement(Agent agent, ClientConnection connection) throws SqlException {
        this();
        this.initStatement(agent, connection);
    }

    void resetStatement(Agent agent, ClientConnection connection) throws SqlException {
        this.resetStatement();
        this.initStatement(agent, connection);
    }

    private void initStatement(Agent agent, ClientConnection connection) {
        this.agent_ = agent;
        this.connection_ = connection;
    }

    public ClientStatement(Agent agent, ClientConnection connection, int type, int concurrency, int holdability, int autoGeneratedKeys, String[] columnNames, int[] columnIndexes) throws SqlException {
        this(agent, connection);
        this.initStatement(type, concurrency, holdability, autoGeneratedKeys, columnNames, columnIndexes);
    }

    public void resetStatement(Agent agent, ClientConnection connection, int type, int concurrency, int holdability, int autoGeneratedKeys, String[] columnNames, int[] columnIndexes) throws SqlException {
        this.resetStatement(agent, connection);
        this.initStatement(type, concurrency, holdability, autoGeneratedKeys, columnNames, columnIndexes);
    }

    private void initStatement(int type, int concurrency, int holdability, int autoGeneratedKeys, String[] columnNames, int[] columnIndexes) throws SqlException {
        switch (type) {
            case 1003: 
            case 1004: 
            case 1005: {
                this.resultSetType_ = type;
                break;
            }
            default: {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), type, "type", "createStatement()");
            }
        }
        switch (concurrency) {
            case 1007: 
            case 1008: {
                this.resultSetConcurrency_ = concurrency;
                break;
            }
            default: {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), concurrency, "concurrency", "createStatement()");
            }
        }
        switch (holdability) {
            case 1: 
            case 2: {
                this.resultSetHoldability_ = holdability;
                break;
            }
            default: {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), holdability, "holdability", "createStatement()");
            }
        }
        switch (autoGeneratedKeys) {
            case 1: 
            case 2: {
                this.autoGeneratedKeys_ = autoGeneratedKeys;
                break;
            }
            default: {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), autoGeneratedKeys, "autoGeneratedKeys", "createStatement");
            }
        }
        this.generatedKeysColumnNames_ = columnNames;
        this.generatedKeysColumnIndexes_ = columnIndexes;
    }

    protected void finalize() throws Throwable {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "finalize", new Object[0]);
        }
        if (this.openOnClient_) {
            this.markClosed();
        }
        super.finalize();
    }

    protected SqlWarning getSqlWarnings() {
        return this.warnings_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeQuery", sql);
                }
                ClientResultSet resultSet = this.executeQueryX(sql);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeQuery", resultSet);
                }
                return resultSet;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ClientResultSet executeQueryX(String sql) throws SqlException {
        this.flowExecute(1, sql);
        return this.resultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeUpdate", sql);
                }
                int updateValue = (int)this.executeUpdateX(sql);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeUpdate", updateValue);
                }
                return updateValue;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeLargeUpdate", sql);
                }
                long updateValue = this.executeUpdateX(sql);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeLargeUpdate", updateValue);
                }
                return updateValue;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private long executeUpdateX(String sql) throws SqlException {
        this.flowExecute(2, sql);
        return this.updateCount_;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            this.checkForClosedStatement();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            this.checkForClosedStatement();
            try {
                return iface.cast(this);
            }
            catch (ClassCastException cce) {
                throw new SqlException(null, new ClientMessageId("XJ128.S"), iface);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "isClosed", !this.openOnClient_);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "isClosed", !this.openOnClient_);
        }
        return !this.openOnClient_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "close", new Object[0]);
                }
                this.closeX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    void closeX() throws SqlException {
        if (!this.openOnClient_) {
            return;
        }
        int numberOfResultSetsToClose = this.resultSetList_ == null ? 0 : this.resultSetList_.length;
        boolean willTickleServer = this.willTickleServer(numberOfResultSetsToClose, true);
        try {
            if (willTickleServer) {
                this.flowClose();
            } else {
                this.flowCloseOutsideUOW();
            }
        }
        finally {
            this.markClosed(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPoolable() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "isPoolable", new Object[0]);
                }
                this.checkForClosedStatement();
                return this.isPoolable;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setPoolable", poolable);
                }
                this.checkForClosedStatement();
                this.isPoolable = poolable;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getMaxFieldSize", new Object[0]);
            }
            this.checkForClosedStatement();
            return this.maxFieldSize_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setMaxFieldSize", max);
                }
                this.checkForClosedStatement();
                if (max < 0) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ066.S"), max);
                }
                this.maxFieldSize_ = max;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getMaxRows", this.maxRows_);
        }
        return (int)this.getLargeMaxRows();
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getLargeMaxRows", this.maxRows_);
            }
            return this.maxRows_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "setMaxRows", maxRows);
            }
            this.setLargeMaxRows(maxRows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLargeMaxRows(long maxRows) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setLargeMaxRows", maxRows);
                }
                this.checkForClosedStatement();
                if (maxRows < 0L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ063.S"), maxRows);
                }
                this.maxRows_ = maxRows;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setEscapeProcessing", enable);
                }
                this.checkForClosedStatement();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getQueryTimeout", this.timeout_);
            }
            return this.timeout_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setQueryTimeout", seconds);
                }
                this.checkForClosedStatement();
                if (seconds < 0) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ074.S"), seconds);
                }
                if (seconds != this.timeout_) {
                    this.timeout_ = seconds;
                    this.doWriteTimeout = true;
                }
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "cancel", new Object[0]);
            }
            this.checkForClosedStatement();
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.4"), new Object[0]);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getWarnings", this.warnings_);
        }
        try {
            this.checkForClosedStatement();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        return this.warnings_ == null ? null : this.warnings_.getSQLWarning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "clearWarnings", new Object[0]);
            }
            try {
                this.checkForClosedStatement();
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
            this.clearWarningsX();
        }
    }

    final void clearWarningsX() {
        this.warnings_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursorName(String name) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setCursorName", name);
                }
                this.checkForClosedStatement();
                if (name == null || name.equals("")) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ202.S"), name);
                }
                if (this.resultSet_ != null && this.resultSet_.openOnClient_) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("X0X95.S"), "setCursorName()", "Statement");
                }
                this.cursorName_ = name;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "execute", sql);
                }
                boolean b = this.executeX(sql);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "execute", b);
                }
                return b;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    boolean executeX(String sql) throws SqlException {
        this.flowExecute(3, sql);
        return this.resultSet_ != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getResultSet", new Object[0]);
                }
                this.checkForClosedStatement();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getResultSet", this.resultSet_);
                }
                return this.resultSet_;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUpdateCount() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getUpdateCount", new Object[0]);
                }
                this.checkForClosedStatement();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getUpdateCount", this.updateCount_);
                }
                return (int)this.updateCount_;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLargeUpdateCount() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getUpdateCount", new Object[0]);
                }
                this.checkForClosedStatement();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getUpdateCount", this.updateCount_);
                }
                return this.updateCount_;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getMoreResults", new Object[0]);
                }
                boolean resultIsResultSet = this.getMoreResultsX(3);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getMoreResults", resultIsResultSet);
                }
                return resultIsResultSet;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setFetchDirection", direction);
                }
                this.checkForClosedStatement();
                switch (direction) {
                    case 1000: 
                    case 1001: 
                    case 1002: {
                        this.fetchDirection_ = direction;
                        break;
                    }
                    default: {
                        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ064.S"), direction);
                    }
                }
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getFetchDirection", this.fetchDirection_);
            }
            return this.fetchDirection_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setFetchSize", rows);
                }
                this.checkForClosedStatement();
                if (rows < 0 || this.maxRows_ != 0L && (long)rows > this.maxRows_) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ065.S"), rows).getSQLException();
                }
                this.fetchSize_ = rows;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getFetchSize", this.fetchSize_);
            }
            return this.fetchSize_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getResultSetConcurrency", this.resultSetConcurrency_);
            }
            return this.resultSetConcurrency_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getResultSetType", this.resultSetType_);
            }
            return this.resultSetType_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "addBatch", sql);
                }
                this.checkForClosedStatement();
                sql = this.connection_.nativeSQLX(sql);
                this.batch_.add(sql);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBatch() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "clearBatch", new Object[0]);
                }
                this.checkForClosedStatement();
                this.batch_.clear();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeBatch", new Object[0]);
                }
                long[] updateCounts = this.executeBatchX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeBatch", updateCounts);
                }
                return Utils.squashLongs(updateCounts);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeLargeBatch", new Object[0]);
                }
                long[] updateCounts = this.executeBatchX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeLargeBatch", updateCounts);
                }
                return updateCounts;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private long[] executeBatchX() throws SqlException, BatchUpdateException {
        this.checkForClosedStatement();
        this.clearWarningsX();
        this.resultSetList_ = null;
        long[] updateCounts = new long[this.batch_.size()];
        Arrays.fill(updateCounts, -3L);
        this.flowExecuteBatch(updateCounts);
        return updateCounts;
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getConnection", this.connection_);
            }
            return this.connection_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults(int current) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getMoreResults", current);
                }
                boolean resultIsResultSet = this.getMoreResultsX(current);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getMoreResults", resultIsResultSet);
                }
                return resultIsResultSet;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean getMoreResultsX(int current) throws SqlException {
        boolean resultIsResultSet;
        this.checkForClosedStatement();
        this.updateCount_ = -1L;
        if (this.resultSetList_ == null) {
            if (this.resultSet_ != null) {
                if (current != 2) {
                    this.resultSet_.closeX();
                }
                this.resultSet_ = null;
            }
            resultIsResultSet = false;
        } else {
            if (current == 1 && this.resultSetList_[this.indexOfCurrentResultSet_] != null) {
                this.resultSetList_[this.indexOfCurrentResultSet_].closeX();
            }
            boolean bl = resultIsResultSet = this.indexOfCurrentResultSet_ + 1 < this.resultSetList_.length;
        }
        if (current == 3) {
            int numberOfResultSetsToClose = this.resultSetList_ == null ? 0 : this.indexOfCurrentResultSet_ + 1;
            boolean willTickleServer = this.willTickleServer(numberOfResultSetsToClose, false);
            if (willTickleServer) {
                this.flowCloseRetrievedResultSets();
            } else {
                this.flowCloseRetrievedResultSetsOutsideUOW();
            }
        }
        this.resultSet_ = resultIsResultSet ? this.resultSetList_[++this.indexOfCurrentResultSet_] : null;
        return resultIsResultSet;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getGeneratedKeys", new Object[0]);
            }
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getGeneratedKeys", this.generatedKeysResultSet_);
            }
            return this.generatedKeysResultSet_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeUpdate", sql, autoGeneratedKeys);
                }
                this.autoGeneratedKeys_ = autoGeneratedKeys;
                int updateValue = (int)this.executeUpdateX(sql);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeUpdate", updateValue);
                }
                return updateValue;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeLargeUpdate", sql, autoGeneratedKeys);
                }
                this.autoGeneratedKeys_ = autoGeneratedKeys;
                long updateValue = this.executeUpdateX(sql);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeLargeUpdate", updateValue);
                }
                return updateValue;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeUpdate", sql, columnIndexes);
                }
                if (columnIndexes != null && columnIndexes.length > 0) {
                    this.autoGeneratedKeys_ = 1;
                    this.generatedKeysColumnIndexes_ = (int[])columnIndexes.clone();
                } else {
                    this.generatedKeysColumnIndexes_ = null;
                }
                int updateValue = (int)this.executeUpdateX(sql);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeUpdate", updateValue);
                }
                return updateValue;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeLargeUpdate", sql, columnIndexes);
                }
                if (columnIndexes != null && columnIndexes.length > 0) {
                    this.autoGeneratedKeys_ = 1;
                    this.generatedKeysColumnIndexes_ = (int[])columnIndexes.clone();
                } else {
                    this.generatedKeysColumnIndexes_ = null;
                }
                long updateValue = this.executeUpdateX(sql);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeLargeUpdate", updateValue);
                }
                return updateValue;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeUpdate", sql, columnNames);
                }
                if (columnNames != null && columnNames.length > 0) {
                    this.autoGeneratedKeys_ = 1;
                    this.generatedKeysColumnNames_ = (String[])columnNames.clone();
                } else {
                    this.generatedKeysColumnNames_ = null;
                }
                int updateValue = (int)this.executeUpdateX(sql);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeUpdate", updateValue);
                }
                return updateValue;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeLargeUpdate", sql, columnNames);
                }
                if (columnNames != null && columnNames.length > 0) {
                    this.autoGeneratedKeys_ = 1;
                    this.generatedKeysColumnNames_ = (String[])columnNames.clone();
                } else {
                    this.generatedKeysColumnIndexes_ = null;
                }
                long updateValue = this.executeUpdateX(sql);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeLargeUpdate", updateValue);
                }
                return updateValue;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "execute", sql, autoGeneratedKeys);
                }
                this.autoGeneratedKeys_ = autoGeneratedKeys;
                boolean b = this.executeX(sql);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "execute", b);
                }
                return b;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "execute", sql, columnIndexes);
                }
                if (columnIndexes != null && columnIndexes.length > 0) {
                    this.autoGeneratedKeys_ = 1;
                    this.generatedKeysColumnIndexes_ = (int[])columnIndexes.clone();
                } else {
                    this.generatedKeysColumnIndexes_ = null;
                }
                boolean b = this.executeX(sql);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "execute", b);
                }
                return b;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "execute", sql, columnNames);
                }
                if (columnNames != null && columnNames.length > 0) {
                    this.autoGeneratedKeys_ = 1;
                    this.generatedKeysColumnNames_ = (String[])columnNames.clone();
                } else {
                    this.generatedKeysColumnNames_ = null;
                }
                boolean b = this.executeX(sql);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "execute", b);
                }
                return b;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getResultSetHoldability", new Object[0]);
            }
            this.checkForClosedStatement();
            return this.resultSetHoldability_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    void writeSetSpecialRegister(ArrayList sqlsttList) throws SqlException {
        if (this.setSpecialRegisterSection_ == null) {
            this.setSpecialRegisterSection_ = this.agent_.sectionManager_.getDynamicSection(1);
        }
        this.materialStatement_.writeSetSpecialRegister_(this.setSpecialRegisterSection_, sqlsttList);
    }

    void readSetSpecialRegister() throws SqlException {
        SanityManager.ASSERT(this.setSpecialRegisterSection_ != null);
        this.materialStatement_.readSetSpecialRegister_();
    }

    private void writeExecuteImmediate(String sql, Section section) throws SqlException {
        this.materialStatement_.writeExecuteImmediate_(sql, section);
    }

    private void readExecuteImmediate() throws SqlException {
        this.materialStatement_.readExecuteImmediate_();
    }

    @Override
    public void completeExecuteImmediate(Sqlca sqlca) {
        int sqlcode = this.completeSqlca(sqlca);
        if (sqlcode < 0) {
            return;
        }
        if (sqlca != null) {
            this.updateCount_ = sqlca.getUpdateCount();
        }
    }

    private void readExecuteImmediateForBatch(String sql) throws SqlException {
        this.materialStatement_.readExecuteImmediateForBatch_(sql);
    }

    void writePrepareDescribeOutput(String sql, Section section) throws SqlException {
        this.materialStatement_.writePrepareDescribeOutput_(sql, section);
    }

    void readPrepareDescribeOutput() throws SqlException {
        this.materialStatement_.readPrepareDescribeOutput_();
    }

    @Override
    public void completePrepareDescribeOutput(ColumnMetaData resultSetMetaData, Sqlca sqlca) {
        this.completePrepare(sqlca);
        this.resultSetMetaData_ = resultSetMetaData;
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceResultSetMetaData(this, this.resultSetMetaData_);
        }
    }

    void writePrepare(String sql, Section section) throws SqlException {
        this.materialStatement_.writePrepare_(sql, section);
    }

    void readPrepare() throws SqlException {
        this.materialStatement_.readPrepare_();
    }

    @Override
    public void completePrepare(Sqlca sqlca) {
        int sqlcode = this.completeSqlca(sqlca);
        if (sqlcode < 0) {
            return;
        }
        this.markPrepared();
    }

    void writeOpenQuery(Section section, int fetchSize, int resultSetType) throws SqlException {
        this.materialStatement_.writeOpenQuery_(section, fetchSize, resultSetType);
    }

    void readOpenQuery() throws SqlException {
        this.materialStatement_.readOpenQuery_();
    }

    @Override
    public void completeOpenQuery(Sqlca sqlca, ClientResultSet resultSet) {
        this.completeSqlca(sqlca);
        this.resultSet_ = resultSet;
        if (resultSet == null) {
            return;
        }
        resultSet.resultSetMetaData_ = this.resultSetMetaData_;
        resultSet.resultSetMetaData_.resultSetConcurrency_ = resultSet.resultSetConcurrency_;
        resultSet.createLOBColumnTracker();
        if (this.cachedCursor_ == null && this.isPreparedStatement_) {
            this.cachedCursor_ = this.resultSet_.cursor_;
        }
        if (sqlca != null && sqlca.getSqlCode() < 0) {
            return;
        }
        resultSet.cursor_.rowsRead_ = fetchedRowBase;
        if (this.resultSet_.fetchSize_ == 0 && (this.resultSet_.resultSetType_ == 1004 || this.resultSet_.resultSetType_ == 1005)) {
            this.resultSet_.setFetchSize_(64);
        }
    }

    @Override
    public void completeExecuteCallOpenQuery(Sqlca sqlca, ClientResultSet resultSet, ColumnMetaData resultSetMetaData, Section generatedSection) {
        resultSet.completeSqlca(sqlca);
        resultSet.resultSetMetaData_ = resultSetMetaData;
        resultSet.createLOBColumnTracker();
        if (sqlca != null && sqlca.getSqlCode() < 0) {
            return;
        }
        resultSet.cursor_.rowsRead_ = fetchedRowBase;
        resultSet.generatedSection_ = generatedSection;
        if (resultSet.fetchSize_ == 0) {
            resultSet.fetchSize_ = 64;
        }
    }

    void writeExecuteCall(boolean outputExpected, String procedureName, Section section, int fetchSize, boolean suppressResultSets, int resultSetType, ColumnMetaData parameterMetaData, Object[] inputs) throws SqlException {
        this.materialStatement_.writeExecuteCall_(outputExpected, procedureName, section, fetchSize, suppressResultSets, resultSetType, parameterMetaData, inputs);
    }

    void readExecuteCall() throws SqlException {
        this.materialStatement_.readExecuteCall_();
    }

    @Override
    public void completeExecuteCall(Sqlca sqlca, Cursor singletonParams, ClientResultSet[] resultSets) {
        this.completeExecuteCall(sqlca, singletonParams);
        this.resultSetList_ = (ClientResultSet[])resultSets.clone();
        if (resultSets != null) {
            this.resultSet_ = resultSets[0];
        }
        this.indexOfCurrentResultSet_ = 0;
    }

    @Override
    public void completeExecuteCall(Sqlca sqlca, Cursor singletonParams) {
        this.completeExecute(sqlca);
        if (sqlca != null && sqlca.getSqlCode() < 0) {
            this.singletonRowData_ = null;
        } else {
            this.singletonRowData_ = singletonParams;
            if (this.cachedSingletonRowData_ == null && this.isPreparedStatement_) {
                this.cachedSingletonRowData_ = this.singletonRowData_;
            }
        }
    }

    @Override
    public void completeExecute(Sqlca sqlca) {
        if (sqlca == null) {
            return;
        }
        int sqlcode = sqlca.getSqlCode();
        if (sqlcode < 0) {
            this.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, sqlca));
        } else {
            this.updateCount_ = sqlca.getUpdateCount();
            if (this.sqlMode_ == 2) {
                this.updateCount_ = -1L;
            }
            if (sqlcode > 0 && sqlcode != 466 && sqlcode != 100) {
                this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, sqlca));
            }
        }
    }

    public void setUpdateCount(long updateCount) {
        this.updateCount_ = updateCount;
    }

    protected final void setOwner(Statement owner) {
        this.owner = owner;
    }

    final Statement getOwner() {
        return this.owner;
    }

    private boolean willTickleServer(int number, boolean allowAutoCommits) throws SqlException {
        boolean requiresAutocommit = false;
        if (this.resultSetList_ != null) {
            for (int i = 0; i < number; ++i) {
                if (this.resultSetList_[i] == null) continue;
                if (this.resultSetList_[i].openOnServer_) {
                    return true;
                }
                if (this.resultSetList_[i].autoCommitted_ || !allowAutoCommits) continue;
                requiresAutocommit = true;
            }
        } else if (this.generatedKeysResultSet_ != null && this.generatedKeysResultSet_.openOnServer_) {
            this.generatedKeysResultSet_.writeClose();
        } else if (this.resultSet_ != null) {
            if (this.resultSet_.openOnServer_) {
                return true;
            }
            if (!this.resultSet_.autoCommitted_ && allowAutoCommits) {
                requiresAutocommit = true;
            }
        }
        if (this.connection_.autoCommit_ && requiresAutocommit) {
            if (this.connection_.isXAConnection_) {
                return this.connection_.getXAState() == 0;
            }
            return true;
        }
        return false;
    }

    private void flowClose() throws SqlException {
        this.agent_.beginWriteChain(this);
        this.writeClose(true);
        this.agent_.flow(this);
        this.readClose(true);
        this.agent_.endReadChain();
    }

    private void flowCloseOutsideUOW() throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.writeClose(true);
        this.agent_.flowOutsideUOW();
        this.readClose(true);
        this.agent_.endReadChain();
    }

    final void writeClose(boolean allowAutoCommits) throws SqlException {
        this.writeCloseResultSets(allowAutoCommits);
    }

    final void readClose(boolean allowAutoCommits) throws SqlException {
        this.readCloseResultSets(allowAutoCommits);
    }

    final boolean writeCloseResultSets(boolean allowAutoCommits) throws SqlException {
        int numberOfResultSetsToClose = this.resultSetList_ == null ? 0 : this.resultSetList_.length;
        return this.writeCloseResultSets(numberOfResultSetsToClose, allowAutoCommits);
    }

    private boolean writeCloseResultSets(int number, boolean allowAutoCommits) throws SqlException {
        boolean requiresAutocommit = false;
        if (this.resultSetList_ != null) {
            for (int i = 0; i < number; ++i) {
                if (this.resultSetList_[i] == null) continue;
                if (this.resultSetList_[i].openOnServer_) {
                    this.resultSetList_[i].writeClose();
                }
                if (this.resultSetList_[i].autoCommitted_ || !allowAutoCommits) continue;
                requiresAutocommit = true;
            }
        } else if (this.generatedKeysResultSet_ != null && this.generatedKeysResultSet_.openOnServer_) {
            this.generatedKeysResultSet_.writeClose();
        } else if (this.resultSet_ != null) {
            if (this.resultSet_.openOnServer_) {
                this.resultSet_.writeClose();
            }
            if (!this.resultSet_.autoCommitted_ && allowAutoCommits) {
                requiresAutocommit = true;
            }
        }
        if (this.connection_.autoCommit_ && requiresAutocommit && this.isAutoCommittableStatement_) {
            this.connection_.writeAutoCommit();
            if (this.connection_.isXAConnection_) {
                return this.connection_.getXAState() == 0;
            }
            return true;
        }
        return false;
    }

    final void readCloseResultSets(boolean allowAutoCommits) throws SqlException {
        int numberOfResultSetsToClose = this.resultSetList_ == null ? 0 : this.resultSetList_.length;
        this.readCloseResultSets(numberOfResultSetsToClose, allowAutoCommits);
    }

    private void readCloseResultSets(int number, boolean allowAutoCommits) throws SqlException {
        boolean requiredAutocommit = false;
        if (this.resultSetList_ != null) {
            for (int i = 0; i < number; ++i) {
                if (this.resultSetList_[i] == null) continue;
                if (this.resultSetList_[i].openOnServer_) {
                    this.resultSetList_[i].readClose();
                } else {
                    this.resultSetList_[i].markClosed();
                }
                if (this.resultSetList_[i].autoCommitted_ || !allowAutoCommits) continue;
                requiredAutocommit = true;
            }
        } else if (this.generatedKeysResultSet_ != null) {
            if (this.generatedKeysResultSet_.openOnServer_) {
                this.generatedKeysResultSet_.readClose();
            } else {
                this.generatedKeysResultSet_.markClosed();
            }
        } else if (this.resultSet_ != null) {
            if (this.resultSet_.openOnServer_) {
                this.resultSet_.readClose();
            } else {
                this.resultSet_.markClosed();
            }
            if (!this.resultSet_.autoCommitted_ && allowAutoCommits) {
                requiredAutocommit = true;
            }
        }
        if (this.connection_.autoCommit_ && requiredAutocommit && this.isAutoCommittableStatement_) {
            this.connection_.readAutoCommit();
        }
    }

    private void flowCloseRetrievedResultSets() throws SqlException {
        int numberOfResultSetsToClose = this.resultSetList_ == null ? 0 : this.indexOfCurrentResultSet_ + 1;
        this.agent_.beginWriteChain(this);
        this.writeCloseResultSets(numberOfResultSetsToClose, false);
        this.agent_.flow(this);
        this.readCloseResultSets(numberOfResultSetsToClose, false);
        this.agent_.endReadChain();
    }

    private void flowCloseRetrievedResultSetsOutsideUOW() throws SqlException {
        int numberOfResultSetsToClose = this.resultSetList_ == null ? 0 : this.indexOfCurrentResultSet_ + 1;
        this.agent_.beginWriteChainOutsideUOW();
        this.writeCloseResultSets(numberOfResultSetsToClose, false);
        this.agent_.flowOutsideUOW();
        this.readCloseResultSets(numberOfResultSetsToClose, false);
        this.agent_.endReadChain();
    }

    @Override
    public int completeSqlca(Sqlca sqlca) {
        if (sqlca == null) {
            return 0;
        }
        int sqlcode = sqlca.getSqlCode();
        if (sqlcode < 0) {
            this.connection_.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, sqlca));
        } else if (sqlcode > 0) {
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, sqlca));
        }
        return sqlcode;
    }

    @Override
    public void completeExecuteSetStatement(Sqlca sqlca) {
    }

    void markClosed() {
        this.markClosed(false);
    }

    void markClosed(boolean removeListener) {
        this.openOnClient_ = false;
        this.markResultSetsClosed(false);
        this.closeEverythingExceptResultSets(removeListener);
    }

    private void closeEverythingExceptResultSets(boolean removeListener) {
        this.removeClientCursorNameFromCache();
        this.markPreparedStatementForAutoGeneratedKeysClosed();
        this.setSection(null);
        if (this.resultSetMetaData_ != null) {
            this.resultSetMetaData_.markClosed();
            this.resultSetMetaData_ = null;
        }
        if (removeListener) {
            this.connection_.openStatements_.remove(this);
        }
        if (this.setSpecialRegisterSection_ != null) {
            this.setSpecialRegisterSection_.free();
            this.setSpecialRegisterSection_ = null;
        }
    }

    private void markPreparedStatementForAutoGeneratedKeysClosed() {
        if (this.preparedStatementForAutoGeneratedKeys_ != null) {
            this.preparedStatementForAutoGeneratedKeys_.markClosed();
        }
    }

    final void markResultSetsClosed(boolean removeListener) {
        try {
            this.closingResultSets_ = true;
            if (this.resultSetList_ != null) {
                for (int i = 0; i < this.resultSetList_.length; ++i) {
                    if (this.resultSetList_[i] != null) {
                        this.resultSetList_[i].markClosed(removeListener);
                    }
                    this.resultSetList_[i] = null;
                }
            }
            if (this.generatedKeysResultSet_ != null) {
                this.generatedKeysResultSet_.markClosed(removeListener);
            }
            if (this.resultSet_ != null) {
                this.resultSet_.markClosed(removeListener);
            }
            this.resultSet_ = null;
            this.resultSetList_ = null;
            this.generatedKeysResultSet_ = null;
        }
        finally {
            this.closingResultSets_ = false;
        }
    }

    private void flowExecute(int executeType, String sql) throws SqlException {
        this.checkForClosedStatement();
        this.clearWarningsX();
        sql = this.escape(sql);
        this.sqlMode_ = executeType == 1 ? 1 : 4;
        this.parseSqlAndSetSqlModes(sql);
        this.checkAutoGeneratedKeysParameters();
        this.updateCount_ = this.sqlMode_ == 4 ? 0L : -1L;
        this.checkForAppropriateSqlMode(executeType, this.sqlMode_);
        if (this.sqlMode_ == 1) {
            this.checkForDuplicateCursorName();
        }
        boolean timeoutSent = false;
        this.agent_.beginWriteChain(this);
        boolean piggybackedAutoCommit = this.writeCloseResultSets(true);
        ClientResultSet scrollableRS = null;
        Section newSection = null;
        boolean repositionedCursor = false;
        boolean prepareSentForAutoGeneratedKeys = false;
        if (this.doWriteTimeout && this.timeout_ > 0) {
            this.timeoutArrayList.set(0, TIMEOUT_STATEMENT + this.timeout_);
            this.writeSetSpecialRegister(this.timeoutArrayList);
            timeoutSent = true;
        }
        switch (this.sqlMode_) {
            case 1: {
                newSection = this.agent_.sectionManager_.getDynamicSection(this.resultSetHoldability_);
                this.writePrepareDescribeOutput(sql, newSection);
                this.writeOpenQuery(newSection, this.fetchSize_, this.resultSetType_);
                break;
            }
            case 4: {
                String[] sqlAndCursorName;
                String cursorName = null;
                if ((this.sqlUpdateMode_ == 64 || this.sqlUpdateMode_ == 128) && (sqlAndCursorName = this.extractCursorNameFromWhereCurrentOf(sql)) != null) {
                    cursorName = sqlAndCursorName[0];
                    sql = sqlAndCursorName[1];
                }
                if (cursorName != null) {
                    newSection = this.agent_.sectionManager_.getPositionedUpdateSection(cursorName, true);
                    if (newSection == null) {
                        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("42X30"), cursorName);
                    }
                    scrollableRS = this.agent_.sectionManager_.getPositionedUpdateResultSet(cursorName);
                    if (scrollableRS != null && !scrollableRS.isRowsetCursor_ && !(repositionedCursor = scrollableRS.repositionScrollableResultSetBeforeJDBC1PositionedUpdateDelete())) {
                        scrollableRS = null;
                    }
                    if (newSection.getClientCursorName() != null && cursorName.compareTo(newSection.getClientCursorName()) == 0) {
                        sql = this.substituteClientCursorNameWithServerCursorName(sql, newSection);
                    }
                    this.writeExecuteImmediate(sql, newSection);
                } else {
                    newSection = this.agent_.sectionManager_.getDynamicSection(this.resultSetHoldability_);
                    this.writeExecuteImmediate(sql, newSection);
                    if ((this.sqlUpdateMode_ == 32 || this.sqlUpdateMode_ == 128) && this.autoGeneratedKeys_ == 1) {
                        if (this.preparedStatementForAutoGeneratedKeys_ == null) {
                            this.preparedStatementForAutoGeneratedKeys_ = ClientStatement.prepareAutoGeneratedKeysStatement(this.connection_);
                            prepareSentForAutoGeneratedKeys = true;
                        }
                        this.writeOpenQuery(this.preparedStatementForAutoGeneratedKeys_.getSection(), this.preparedStatementForAutoGeneratedKeys_.fetchSize_, this.preparedStatementForAutoGeneratedKeys_.resultSetType_);
                    }
                }
                if (!this.connection_.autoCommit_) break;
                this.connection_.writeAutoCommit();
                break;
            }
            case 2: {
                newSection = this.writeExecuteCall(sql, false);
            }
        }
        this.agent_.flow(this);
        this.readCloseResultSets(true);
        if (timeoutSent) {
            this.readSetSpecialRegister();
        }
        if (piggybackedAutoCommit) {
            this.connection_.completeTransactionStart();
        }
        this.markResultSetsClosed(true);
        this.setSection(newSection);
        switch (this.sqlMode_) {
            case 1: {
                this.readPrepareDescribeOutput();
                this.readOpenQuery();
                if (this.resultSet_ == null) break;
                this.resultSet_.parseScrollableRowset();
                this.setupCursorNameCacheAndMappings();
                break;
            }
            case 4: {
                if (scrollableRS != null && !scrollableRS.isRowsetCursor_) {
                    scrollableRS.readPositioningFetch_();
                }
                this.readExecuteImmediate();
                if ((this.sqlUpdateMode_ == 32 || this.sqlUpdateMode_ == 128) && this.autoGeneratedKeys_ == 1) {
                    if (prepareSentForAutoGeneratedKeys) {
                        this.preparedStatementForAutoGeneratedKeys_.materialPreparedStatement_.readPrepareDescribeOutput_();
                    }
                    this.preparedStatementForAutoGeneratedKeys_.readOpenQuery();
                    this.generatedKeysResultSet_ = this.preparedStatementForAutoGeneratedKeys_.resultSet_;
                    this.preparedStatementForAutoGeneratedKeys_.resultSet_ = null;
                    this.generatedKeysResultSet_.outerStatement_ = this;
                }
                if (!this.connection_.autoCommit_) break;
                this.connection_.readAutoCommit();
                break;
            }
            case 2: {
                this.readPrepare();
                this.readExecuteCall();
            }
        }
        this.agent_.endReadChain();
        if (this.resultSet_ != null && this.resultSet_.resultSetHoldability_ != this.resultSetHoldability_ && this.sqlMode_ != 2) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ204.S"), this.resultSetHoldability_);
        }
        if (this.sqlMode_ == 2) {
            this.parseStorProcReturnedScrollableRowset();
            this.checkForStoredProcResultSetCount(executeType);
            if (this.connection_.autoCommit_ && this.resultSet_ == null && this.resultSetList_ == null) {
                this.connection_.flowAutoCommit();
            }
        }
        if (executeType == 2 && this.updateCount_ < 0L) {
            this.updateCount_ = 0L;
        }
    }

    private void flowExecuteBatch(long[] updateCounts) throws SqlException, BatchUpdateException {
        String sql;
        int i;
        SqlException chainBreaker = null;
        boolean isCallCataloguedBestGuess = true;
        this.agent_.beginBatchedWriteChain(this);
        for (i = 0; i < this.batch_.size(); ++i) {
            boolean flowSQL = true;
            sql = (String)this.batch_.get(i);
            this.parseSqlAndSetSqlModes(sql);
            try {
                this.checkForInvalidBatchedSql(sql);
            }
            catch (SqlException e) {
                flowSQL = false;
            }
            if (!flowSQL) continue;
            if (this.sqlMode_ != 2) {
                this.setSection(this.agent_.sectionManager_.getDynamicSection(this.resultSetHoldability_));
                this.writeExecuteImmediate(sql, this.getSection());
                continue;
            }
            this.setSection(this.writeExecuteCall(sql, true));
        }
        if (this.connection_.autoCommit_) {
            this.connection_.writeAutoCommit();
        }
        this.agent_.flowBatch(this, this.batch_.size());
        try {
            for (i = 0; i < this.batch_.size(); ++i) {
                this.agent_.setBatchedExceptionLabelIndex(i);
                SqlException invalidSQLCaughtByClient = null;
                sql = (String)this.batch_.get(i);
                this.parseSqlAndSetSqlModes(sql);
                try {
                    this.checkForInvalidBatchedSql(sql);
                }
                catch (SqlException e) {
                    invalidSQLCaughtByClient = e;
                }
                if (invalidSQLCaughtByClient == null) {
                    this.updateCount_ = -1L;
                    if (this.sqlMode_ != 2) {
                        this.readExecuteImmediateForBatch(sql);
                    } else {
                        if (isCallCataloguedBestGuess) {
                            this.readPrepare();
                        }
                        this.readExecuteCall();
                    }
                } else {
                    this.agent_.accumulateReadException(invalidSQLCaughtByClient);
                    this.updateCount_ = -3L;
                    invalidSQLCaughtByClient = null;
                }
                updateCounts[i] = this.updateCount_;
                if (updateCounts[i] != -1L) continue;
                updateCounts[i] = 0L;
            }
            this.agent_.disableBatchedExceptionTracking();
            if (this.connection_.autoCommit_) {
                this.connection_.readAutoCommit();
            }
        }
        catch (SqlException e) {
            chainBreaker = e;
            chainBreaker.setNextException(new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ211.S"), new Object[0]));
        }
        this.batch_.clear();
        this.agent_.endBatchedReadChain(updateCounts, chainBreaker);
    }

    private Section writeExecuteCall(String sql, boolean isBatch) throws SqlException {
        Section newSection = null;
        newSection = this.agent_.sectionManager_.getDynamicSection(this.resultSetHoldability_);
        this.writePrepare(sql, newSection);
        this.writeExecuteCall(false, null, newSection, this.fetchSize_, isBatch, this.resultSetType_, null, null);
        return newSection;
    }

    @Override
    public void listenToUnitOfWork() {
    }

    @Override
    public void completeLocalCommit(Iterator listenerIterator) {
    }

    @Override
    public void completeLocalRollback(Iterator listenerIterator) {
    }

    @Override
    public void accumulateWarning(SqlWarning e) {
        if (this.warnings_ == null) {
            this.warnings_ = e;
        } else {
            this.warnings_.setNextWarning(e);
        }
    }

    private void markPrepared() {
        this.listenToUnitOfWork();
    }

    protected String getJdbcStatementInterfaceName() {
        return "java.sql.Statement";
    }

    void parseSqlAndSetSqlModes(String sql) throws SqlException {
        this.sqlUpdateMode_ = 0;
        String firstToken = this.getStatementToken(sql);
        if (firstToken == null) {
            return;
        }
        if (firstToken.equalsIgnoreCase("select") || firstToken.equalsIgnoreCase("values")) {
            this.sqlMode_ = 1;
        } else if (firstToken.equalsIgnoreCase("call")) {
            this.sqlMode_ = 2;
        } else {
            this.parseUpdateSql(firstToken);
        }
    }

    private String isolateAnyInitialIdentifier(String sql) {
        char ch;
        int idx;
        for (idx = 0; idx < sql.length() && Character.isLetter(ch = sql.charAt(idx)); ++idx) {
        }
        return idx > 0 ? sql.substring(0, idx) : sql;
    }

    private String getStatementToken(String sql) throws SqlException {
        int bracketNesting = 0;
        int state = 0;
        int idx = 0;
        String tokenFound = null;
        block17: while (idx < sql.length() && tokenFound == null) {
            char next = sql.charAt(idx);
            switch (state) {
                case 0: {
                    switch (next) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': 
                        case '(': 
                        case '=': 
                        case '?': 
                        case '{': {
                            ++idx;
                            continue block17;
                        }
                        case '/': {
                            if (idx == sql.length() - 1) {
                                tokenFound = "/";
                            } else if (sql.charAt(idx + 1) == '*') {
                                state = 2;
                                ++bracketNesting;
                                ++idx;
                            }
                            ++idx;
                            continue block17;
                        }
                        case '-': {
                            if (idx == sql.length() - 1) {
                                tokenFound = "-";
                            } else if (sql.charAt(idx + 1) == '-') {
                                state = 1;
                                ++idx;
                            }
                            ++idx;
                            continue block17;
                        }
                    }
                    tokenFound = this.isolateAnyInitialIdentifier(sql.substring(idx));
                    continue block17;
                }
                case 1: {
                    switch (next) {
                        case '\n': 
                        case '\f': 
                        case '\r': {
                            state = 0;
                            ++idx;
                            continue block17;
                        }
                    }
                    ++idx;
                    continue block17;
                }
                case 2: {
                    switch (next) {
                        case '/': {
                            if (idx != sql.length() - 1 && sql.charAt(idx + 1) == '*') {
                                ++bracketNesting;
                                ++idx;
                            }
                            ++idx;
                            continue block17;
                        }
                        case '*': {
                            if (idx != sql.length() - 1 && sql.charAt(idx + 1) == '/' && --bracketNesting == 0) {
                                state = 0;
                                ++idx;
                            }
                            ++idx;
                            continue block17;
                        }
                    }
                    ++idx;
                    continue block17;
                }
            }
            SanityManager.ASSERT(false);
        }
        return tokenFound;
    }

    private void parseUpdateSql(String firstToken) {
        this.sqlMode_ = 4;
        if (firstToken.equalsIgnoreCase("insert")) {
            this.sqlUpdateMode_ = 32;
        }
        if (firstToken.equalsIgnoreCase("delete")) {
            this.sqlUpdateMode_ = 64;
        }
        if (firstToken.equalsIgnoreCase("update")) {
            this.sqlUpdateMode_ = 128;
        }
    }

    final void checkForAppropriateSqlMode(int executeType, int sqlMode) throws SqlException {
        if (executeType == 1 && sqlMode == 4) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ207.S"), new Object[0]);
        }
        if (executeType == 2 && sqlMode == 1) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("X0Y79.S"), new Object[0]);
        }
    }

    private void checkResultSetCount(int executeType) throws SqlException {
        switch (executeType) {
            case 1: {
                if (this.resultSetList_ != null && this.resultSetList_.length > 1) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("X0Y78.S.1"), this.getJdbcStatementInterfaceName(), this.getJdbcStatementInterfaceName());
                }
                if (this.resultSet_ != null && this.resultSetList_.length != 0) break;
                ClientMessageId messageId = new ClientMessageId("X0Y78.S.2");
                throw new SqlException(this.agent_.logWriter_, messageId, this.getJdbcStatementInterfaceName(), this.getJdbcStatementInterfaceName());
            }
            case 2: {
                if (this.resultSet_ == null || this.resultSetList_.length <= 0) break;
                ClientMessageId messageId = new ClientMessageId("X0Y79.S");
                throw new SqlException(this.agent_.logWriter_, messageId, new Object[0]);
            }
        }
    }

    protected final void checkForStoredProcResultSetCount(int executeType) throws SqlException {
        try {
            this.checkResultSetCount(executeType);
        }
        catch (SqlException se) {
            if (this.connection_.autoCommit_) {
                this.connection_.flowRollback();
            }
            throw se;
        }
    }

    final void checkForClosedStatement() throws SqlException {
        if (this.connection_ == null || this.connection_.isClosed()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("08003"), new Object[0]);
        }
        if (!this.openOnClient_) {
            this.agent_.checkForDeferredExceptions();
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ012.S"), "Statement");
        }
        this.agent_.checkForDeferredExceptions();
    }

    private void checkForInvalidBatchedSql(String sql) throws SqlException {
        if (sql == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ067.S"), new Object[0]);
        }
        if (this.sqlMode_ != 2 && (this.sqlMode_ != 4 || this.sqlUpdateMode_ != 32 && this.sqlUpdateMode_ != 64 && this.sqlUpdateMode_ != 128 && this.sqlUpdateMode_ != 0)) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("42ZA1"), sql);
        }
    }

    protected void checkForDuplicateCursorName() throws SqlException {
        if (this.cursorName_ != null && this.connection_.clientCursorNameCache_.containsKey(this.cursorName_)) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ203.S"), this.cursorName_);
        }
    }

    protected void setupCursorNameCacheAndMappings() {
        if (this.cursorName_ != null) {
            this.agent_.sectionManager_.mapCursorNameToQuerySection(this.cursorName_, this.getSection());
            this.getSection().setClientCursorName(this.cursorName_);
            this.connection_.clientCursorNameCache_.put(this.cursorName_, this.cursorName_);
        } else {
            this.agent_.sectionManager_.mapCursorNameToQuerySection(this.getSection().getServerCursorName(), this.getSection());
        }
        this.mapCursorNameToResultSet();
    }

    String[] extractCursorNameFromWhereCurrentOf(String sql) {
        int whereIndex;
        String lowerSql = ((String)sql).toLowerCase();
        int currentIndex = lowerSql.lastIndexOf("current");
        if (currentIndex != -1 && (whereIndex = lowerSql.lastIndexOf("where")) != -1) {
            String[] whereCurrentOf = new String[]{"where", "current", "of"};
            StringTokenizer st = new StringTokenizer(((String)sql).substring(whereIndex));
            while (st.hasMoreTokens()) {
                String cursorName;
                if (!st.nextToken().equalsIgnoreCase(whereCurrentOf[0]) || !st.nextToken().equalsIgnoreCase(whereCurrentOf[1]) || !st.nextToken().equalsIgnoreCase(whereCurrentOf[2])) continue;
                String oldCursorName = cursorName = st.nextToken();
                int originalCursorNameLength = cursorName.length();
                int index = ((String)sql).lastIndexOf(cursorName);
                cursorName = cursorName.charAt(0) == '\"' && cursorName.charAt(cursorName.length() - 1) == '\"' ? cursorName.substring(1, cursorName.length() - 1) : cursorName.toUpperCase();
                sql = ((String)sql).length() > index + originalCursorNameLength ? ((String)sql).substring(0, index) + cursorName + ((String)sql).substring(index + oldCursorName.length(), ((String)sql).length()) : ((String)sql).substring(0, index) + cursorName;
                return new String[]{cursorName, sql};
            }
        }
        return null;
    }

    protected String substituteClientCursorNameWithServerCursorName(String sql, Section section) throws SqlException {
        String clientCursorName = section.getClientCursorName();
        int index = sql.lastIndexOf(clientCursorName);
        if (sql.length() > index + clientCursorName.length()) {
            return sql.substring(0, index) + section.getServerCursorNameForPositionedUpdate() + sql.substring(index + clientCursorName.length(), sql.length());
        }
        return sql.substring(0, index) + section.getServerCursorNameForPositionedUpdate();
    }

    @Override
    public ConnectionCallbackInterface getConnectionCallbackInterface() {
        return this.connection_;
    }

    void resetCursorNameAndRemoveFromWhereCurrentOfMappings() {
        if (this.section_ != null) {
            this.agent_.sectionManager_.removeCursorNameToResultSetMapping(this.cursorName_, this.getSection().getServerCursorNameForPositionedUpdate());
            this.agent_.sectionManager_.removeCursorNameToResultSetMapping(this.cursorName_, this.getSection().getServerCursorName());
            this.agent_.sectionManager_.removeCursorNameToQuerySectionMapping(this.cursorName_, this.getSection().getServerCursorNameForPositionedUpdate());
        }
    }

    private void mapCursorNameToResultSet() {
        if (this.cursorName_ != null) {
            this.agent_.sectionManager_.mapCursorNameToResultSet(this.cursorName_, this.resultSet_);
        } else {
            this.agent_.sectionManager_.mapCursorNameToResultSet(this.getSection().getServerCursorName(), this.resultSet_);
        }
    }

    void parseStorProcReturnedScrollableRowset() throws SqlException {
        if (this.resultSetList_ != null) {
            for (int i = 0; i < this.resultSetList_.length; ++i) {
                if (!this.resultSetList_[i].scrollable_ || !this.resultSetList_[i].cursor_.dataBufferHasUnprocessedData()) continue;
                this.resultSetList_[i].parseScrollableRowset();
                if (!this.resultSetList_[i].rowCountIsUnknown()) continue;
                this.resultSetList_[i].getRowCount();
            }
        }
    }

    String escape(String sql) throws SqlException {
        String nativeSQL = sql;
        nativeSQL = this.connection_.nativeSQLX(sql);
        return nativeSQL;
    }

    String cacheCursorAttributesToSendOnPrepare() throws SqlException {
        StringBuffer cursorAttributes = new StringBuffer();
        if (this.resultSetType_ == 1005) {
            cursorAttributes.append("SENSITIVE STATIC SCROLL ");
        } else if (this.resultSetType_ == 1004) {
            cursorAttributes.append("INSENSITIVE SCROLL ");
        }
        if (this.resultSetConcurrency_ == 1008) {
            cursorAttributes.append("FOR UPDATE ");
        }
        if (this.resultSetHoldability_ == 1) {
            cursorAttributes.append("WITH HOLD ");
        }
        return cursorAttributes == null || cursorAttributes.toString().equals("") ? null : cursorAttributes.toString();
    }

    protected static ClientPreparedStatement prepareAutoGeneratedKeysStatement(ClientConnection cc) throws SqlException {
        String s = "select IDENTITY_VAL_LOCAL() from SYSIBM.SYSDUMMY1";
        ClientPreparedStatement cps = cc.newPreparedStatement_(s, 1003, 1007, 1, 2, null, null);
        cps.cursorAttributesToSendOnPrepare_ = "WITH HOLD ";
        cps.materialPreparedStatement_.writePrepareDescribeOutput_(cps.sql_, cps.getSection());
        return cps;
    }

    void checkAutoGeneratedKeysParameters() throws SqlException {
        if (this.autoGeneratedKeys_ != 2 && this.autoGeneratedKeys_ != 1) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), this.autoGeneratedKeys_, "autoGeneratedKeys", "Statement.execute()/executeQuery()");
        }
        if (this.sqlUpdateMode_ == 32) {
            if (this.generatedKeysColumnNames_ != null && this.generatedKeysColumnNames_.length > 1) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("X0X0D.S"), this.generatedKeysColumnNames_.length);
            }
            if (this.generatedKeysColumnIndexes_ != null && this.generatedKeysColumnIndexes_.length > 1) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("X0X0D.S"), this.generatedKeysColumnIndexes_.length);
            }
        }
    }

    @Override
    public ColumnMetaData getGuessedResultSetMetaData() {
        return this.resultSetMetaData_;
    }

    public boolean isQueryMode() {
        return this.sqlMode_ == 1;
    }

    protected void removeClientCursorNameFromCache() {
        if (this.cursorName_ != null && this.connection_.clientCursorNameCache_.containsKey(this.cursorName_)) {
            this.connection_.clientCursorNameCache_.remove(this.cursorName_);
        }
    }

    void resultSetCommitting(ClientResultSet closingRS) throws SqlException {
        this.resultSetCommitting(closingRS, false);
    }

    boolean resultSetCommitting(ClientResultSet closingRS, boolean writeChain) throws SqlException {
        if (!this.connection_.autoCommit_ || closingRS.autoCommitted_) {
            return false;
        }
        if (this.resultSetList_ != null) {
            for (int i = 0; i < this.resultSetList_.length; ++i) {
                ClientResultSet crs = this.resultSetList_[i];
                if (crs == null || !crs.openOnClient_ || crs == closingRS) continue;
                return false;
            }
        }
        if (writeChain) {
            this.connection_.writeAutoCommit();
            return true;
        }
        if (this.connection_.flowAutoCommit()) {
            this.markAutoCommitted();
            return true;
        }
        return false;
    }

    private void markAutoCommitted() {
        if (this.resultSetList_ != null) {
            for (int i = 0; i < this.resultSetList_.length; ++i) {
                if (this.resultSetList_[i] == null) continue;
                this.resultSetList_[i].markAutoCommitted();
            }
        } else if (this.resultSet_ != null) {
            this.resultSet_.markAutoCommitted();
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            this.checkForClosedStatement();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        this.closeOnCompletion_ = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            this.checkForClosedStatement();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        return this.closeOnCompletion_;
    }

    void closeMeOnCompletion() {
        boolean active;
        boolean bl = active = this.connection_ != null && !this.connection_.isClosed();
        if (active && !this.closingResultSets_ && this.closeOnCompletion_) {
            try {
                if (this.isOpen(this.resultSet_)) {
                    return;
                }
                if (this.isOpen(this.generatedKeysResultSet_)) {
                    return;
                }
                if (this.resultSetList_ != null) {
                    int count = this.resultSetList_.length;
                    for (int i = 0; i < count; ++i) {
                        if (!this.isOpen(this.resultSetList_[i])) continue;
                        return;
                    }
                }
                this.openOnClient_ = false;
                this.closeEverythingExceptResultSets(true);
            }
            catch (SQLException se) {
                se.printStackTrace(this.agent_.getLogWriter());
            }
        }
    }

    private boolean isOpen(ClientResultSet rs) throws SQLException {
        return rs != null && !rs.isClosed();
    }

    void resetResultSetList() {
        this.indexOfCurrentResultSet_ = -1;
    }

    public Section getSection() {
        return this.section_;
    }

    protected void setSection(Section s) {
        if (this.section_ != null) {
            this.section_.free();
        }
        this.section_ = s;
    }
}

