/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.io.PrintWriter;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.derby.iapi.jdbc.InternalDriver;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.shared.common.error.StandardException;

public class JDBCBoot {
    private Properties bootProperties = new Properties();
    private static final String NETWORK_SERVER_AUTOSTART_CLASS_NAME = "org.apache.derby.iapi.jdbc.DRDAServerStarter";

    void addProperty(String name, String value) {
        this.bootProperties.put(name, value);
    }

    public static void boot() {
        block3: {
            PrintWriter pw = DriverManager.getLogWriter();
            if (pw == null) {
                pw = new PrintWriter(System.err, true);
            }
            try {
                new JDBCBoot().boot("jdbc:derby:", pw);
            }
            catch (Throwable t) {
                t.printStackTrace(pw);
                if (!(t instanceof RuntimeException)) break block3;
                throw (RuntimeException)t;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void boot(String protocol, PrintWriter logging) {
        String string = NETWORK_SERVER_AUTOSTART_CLASS_NAME;
        synchronized (NETWORK_SERVER_AUTOSTART_CLASS_NAME) {
            if (InternalDriver.activeDriver() == null) {
                this.addProperty("derby.service.jdbc", InternalDriver.class.getName());
                this.addProperty("derby.service.authentication", "org.apache.derby.iapi.jdbc.AuthenticationService");
                JDBCBoot.boot(this.bootProperties, logging);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static void boot(Properties props, PrintWriter logging) {
        Monitor.startMonitor(props, logging);
        if (Boolean.valueOf(PropertyUtil.getSystemProperty("derby.drda.startNetworkServer")).booleanValue()) {
            try {
                Monitor.startSystemModule(NETWORK_SERVER_AUTOSTART_CLASS_NAME);
            }
            catch (StandardException se) {
                Monitor.logTextMessage("J102", se.getMessage());
            }
        }
    }
}

