/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.ptoca;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.afp.fonts.CharactersetEncoder;

final class TransparentDataControlSequence
implements Iterable<TransparentData> {
    private static final int MAX_SBCS_TRN_SIZE = 253;
    private static final int MAX_DBCS_TRN_SIZE = 252;
    private final List<TransparentData> trns;

    public TransparentDataControlSequence(CharactersetEncoder.EncodedChars encChars) {
        int maxTrnLength = encChars.isDBCS() ? 252 : 253;
        int numTransData = encChars.getLength() / maxTrnLength;
        int currIndex = 0;
        ArrayList<TransparentData> trns = new ArrayList<TransparentData>();
        for (int transDataCnt = 0; transDataCnt < numTransData; ++transDataCnt) {
            trns.add(new TransparentData(currIndex, maxTrnLength, encChars));
            currIndex += maxTrnLength;
        }
        int left = encChars.getLength() - currIndex;
        trns.add(new TransparentData(currIndex, left, encChars));
        this.trns = Collections.unmodifiableList(trns);
    }

    @Override
    public Iterator<TransparentData> iterator() {
        return this.trns.iterator();
    }

    static final class TransparentData {
        private final int offset;
        private final int length;
        private final CharactersetEncoder.EncodedChars encodedChars;

        private TransparentData(int offset, int length, CharactersetEncoder.EncodedChars encChars) {
            this.offset = offset;
            this.length = length;
            this.encodedChars = encChars;
        }

        void writeTo(OutputStream outStream) throws IOException {
            this.encodedChars.writeTo(outStream, this.offset, this.length);
        }
    }
}

